/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.NearCacheProvider;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordStatistics;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class LocalMapStatsProvider {
    private static final int WAIT_PARTITION_TABLE_UPDATE_MILLIS = 100;
    private static final int RETRY_COUNT = 3;
    private final ConcurrentMap<String, LocalMapStatsImpl> statsMap = new ConcurrentHashMap<String, LocalMapStatsImpl>(1000);
    private final ConstructorFunction<String, LocalMapStatsImpl> constructorFunction = new ConstructorFunction<String, LocalMapStatsImpl>(){

        @Override
        public LocalMapStatsImpl createNew(String key) {
            return new LocalMapStatsImpl();
        }
    };
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;

    public LocalMapStatsProvider(MapServiceContext mapServiceContext, NodeEngine nodeEngine) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = nodeEngine;
    }

    public LocalMapStatsImpl getLocalMapStatsImpl(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.constructorFunction);
    }

    public void destroyLocalMapStatsImpl(String name) {
        this.statsMap.remove(name);
    }

    public LocalMapStatsImpl createLocalMapStats(String mapName) {
        NodeEngine nodeEngine = this.nodeEngine;
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        LocalMapStatsImpl localMapStats = this.getLocalMapStatsImpl(mapName);
        if (!mapContainer.getMapConfig().isStatisticsEnabled()) {
            return localMapStats;
        }
        int backupCount = mapContainer.getTotalBackupCount();
        ClusterService clusterService = nodeEngine.getClusterService();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        Address thisAddress = clusterService.getThisAddress();
        LocalMapOnDemandCalculatedStats localMapOnDemandCalculatedStats = new LocalMapOnDemandCalculatedStats();
        localMapOnDemandCalculatedStats.setBackupCount(backupCount);
        this.addNearCacheStats(localMapStats, localMapOnDemandCalculatedStats, mapContainer);
        for (int partitionId = 0; partitionId < partitionService.getPartitionCount(); ++partitionId) {
            InternalPartition partition = partitionService.getPartition(partitionId);
            Address owner = partition.getOwnerOrNull();
            if (owner == null) continue;
            if (owner.equals(thisAddress)) {
                this.addOwnerPartitionStats(localMapStats, localMapOnDemandCalculatedStats, mapName, partitionId);
                continue;
            }
            this.addReplicaPartitionStats(localMapOnDemandCalculatedStats, mapName, partitionId, partition, partitionService, backupCount, thisAddress);
        }
        localMapOnDemandCalculatedStats.copyValuesTo(localMapStats);
        return localMapStats;
    }

    private void addOwnerPartitionStats(LocalMapStatsImpl localMapStats, LocalMapOnDemandCalculatedStats localMapOnDemandCalculatedStats, String mapName, int partitionId) {
        RecordStore recordStore = this.getRecordStoreOrNull(mapName, partitionId);
        if (!this.hasRecords(recordStore)) {
            return;
        }
        int lockedEntryCount = 0;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        long ownedEntryMemoryCost = 0L;
        long hits = 0L;
        Iterator<Record> iterator = recordStore.iterator();
        while (iterator.hasNext()) {
            Record record = iterator.next();
            hits += this.getHits(record);
            ownedEntryMemoryCost += record.getCost();
            lockedEntryCount += this.isLocked(record, recordStore);
            lastAccessTime = Math.max(lastAccessTime, record.getLastAccessTime());
            lastUpdateTime = Math.max(lastUpdateTime, record.getLastUpdateTime());
        }
        localMapOnDemandCalculatedStats.incrementOwnedEntryMemoryCost(ownedEntryMemoryCost);
        localMapOnDemandCalculatedStats.incrementLockedEntryCount(lockedEntryCount);
        localMapOnDemandCalculatedStats.incrementHits(hits);
        localMapOnDemandCalculatedStats.incrementDirtyEntryCount(recordStore.getMapDataStore().notFinishedOperationsCount());
        localMapStats.setLastAccessTime(lastAccessTime);
        localMapStats.setLastUpdateTime(lastUpdateTime);
        localMapOnDemandCalculatedStats.incrementHeapCost(recordStore.getHeapCost());
        localMapOnDemandCalculatedStats.incrementOwnedEntryCount(recordStore.size());
    }

    private long getHits(Record record) {
        RecordStatistics stats = record.getStatistics();
        return stats.getHits();
    }

    private int isLocked(Record record, RecordStore recordStore) {
        if (recordStore.isLocked(record.getKey())) {
            return 1;
        }
        return 0;
    }

    private void addReplicaPartitionStats(LocalMapOnDemandCalculatedStats localMapOnDemandCalculatedStats, String mapName, int partitionId, InternalPartition partition, InternalPartitionService partitionService, int backupCount, Address thisAddress) {
        long heapCost = 0L;
        long backupEntryCount = 0L;
        long backupEntryMemoryCost = 0L;
        for (int replica = 1; replica <= backupCount; ++replica) {
            RecordStore recordStore;
            Address replicaAddress = this.getReplicaAddress(replica, partition, partitionService, backupCount);
            if (this.notGotReplicaAddress(replicaAddress, partitionService, backupCount)) {
                this.printWarning(partition, replica);
                continue;
            }
            if (!this.gotReplicaAddress(replicaAddress, thisAddress) || !this.hasRecords(recordStore = this.getRecordStoreOrNull(mapName, partitionId))) continue;
            heapCost += recordStore.getHeapCost();
            backupEntryCount += (long)recordStore.size();
            backupEntryMemoryCost += this.getMemoryCost(recordStore);
        }
        localMapOnDemandCalculatedStats.incrementHeapCost(heapCost);
        localMapOnDemandCalculatedStats.incrementBackupEntryCount(backupEntryCount);
        localMapOnDemandCalculatedStats.incrementBackupEntryMemoryCost(backupEntryMemoryCost);
    }

    private boolean hasRecords(RecordStore recordStore) {
        return recordStore != null && recordStore.size() > 0;
    }

    private boolean notGotReplicaAddress(Address replicaAddress, InternalPartitionService partitionService, int backupCount) {
        return replicaAddress == null && partitionService.getMemberGroupsSize() > backupCount;
    }

    private boolean gotReplicaAddress(Address replicaAddress, Address thisAddress) {
        return replicaAddress != null && replicaAddress.equals(thisAddress);
    }

    private void printWarning(InternalPartition partition, int replica) {
        this.nodeEngine.getLogger(this.getClass()).warning("Partition: " + partition + ", replica: " + replica + " has no owner!");
    }

    private long getMemoryCost(RecordStore recordStore) {
        Iterator<Record> iterator = recordStore.iterator();
        long cost = 0L;
        while (iterator.hasNext()) {
            Record record = iterator.next();
            cost += record.getCost();
        }
        return cost;
    }

    private RecordStore getRecordStoreOrNull(String mapName, int partitionId) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        return partitionContainer.getExistingRecordStore(mapName);
    }

    private Address getReplicaAddress(int replica, InternalPartition partition, InternalPartitionService partitionService, int backupCount) {
        Address replicaAddress = partition.getReplicaAddress(replica);
        if (replicaAddress == null) {
            replicaAddress = this.waitForReplicaAddress(replica, partition, partitionService, backupCount);
        }
        return replicaAddress;
    }

    private Address waitForReplicaAddress(int replica, InternalPartition partition, InternalPartitionService partitionService, int backupCount) {
        int tryCount = 3;
        Address replicaAddress = null;
        while (replicaAddress == null && partitionService.getMemberGroupsSize() > backupCount && tryCount-- > 0) {
            this.sleep();
            replicaAddress = partition.getReplicaAddress(replica);
        }
        return replicaAddress;
    }

    private void sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void addNearCacheStats(LocalMapStatsImpl localMapStats, LocalMapOnDemandCalculatedStats localMapOnDemandCalculatedStats, MapContainer mapContainer) {
        if (!mapContainer.getMapConfig().isNearCacheEnabled()) {
            return;
        }
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        NearCacheStatsImpl nearCacheStats = nearCacheProvider.getNearCache(mapContainer.getName()).getNearCacheStats();
        long nearCacheHeapCost = mapContainer.getNearCacheSizeEstimator().getSize();
        localMapStats.setNearCacheStats(nearCacheStats);
        localMapOnDemandCalculatedStats.incrementHeapCost(nearCacheHeapCost);
    }

    private static class LocalMapOnDemandCalculatedStats {
        private long hits;
        private long ownedEntryCount;
        private long backupEntryCount;
        private long ownedEntryMemoryCost;
        private long backupEntryMemoryCost;
        private long heapCost;
        private long lockedEntryCount;
        private long dirtyEntryCount;
        private int backupCount;

        private LocalMapOnDemandCalculatedStats() {
        }

        public void setBackupCount(int backupCount) {
            this.backupCount = backupCount;
        }

        public void incrementHits(long hits) {
            this.hits += hits;
        }

        public void incrementOwnedEntryCount(long ownedEntryCount) {
            this.ownedEntryCount += ownedEntryCount;
        }

        public void incrementBackupEntryCount(long backupEntryCount) {
            this.backupEntryCount += backupEntryCount;
        }

        public void incrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
            this.ownedEntryMemoryCost += ownedEntryMemoryCost;
        }

        public void incrementBackupEntryMemoryCost(long backupEntryMemoryCost) {
            this.backupEntryMemoryCost += backupEntryMemoryCost;
        }

        public void incrementLockedEntryCount(long lockedEntryCount) {
            this.lockedEntryCount += lockedEntryCount;
        }

        public void incrementDirtyEntryCount(long dirtyEntryCount) {
            this.dirtyEntryCount += dirtyEntryCount;
        }

        public void incrementHeapCost(long heapCost) {
            this.heapCost += heapCost;
        }

        public void copyValuesTo(LocalMapStatsImpl localMapStats) {
            localMapStats.setBackupCount(this.backupCount);
            localMapStats.setHits(this.hits);
            localMapStats.setOwnedEntryCount(this.ownedEntryCount);
            localMapStats.setBackupEntryCount(this.backupEntryCount);
            localMapStats.setOwnedEntryMemoryCost(this.ownedEntryMemoryCost);
            localMapStats.setBackupEntryMemoryCost(this.backupEntryMemoryCost);
            localMapStats.setHeapCost(this.heapCost);
            localMapStats.setLockedEntryCount(this.lockedEntryCount);
            localMapStats.setDirtyEntryCount(this.dirtyEntryCount);
        }
    }
}

