/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit.examples;

import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.examples.TextDifferenceListenerBase;

public class FloatingPointTolerantDifferenceListener
extends TextDifferenceListenerBase {
    private final double tolerance;

    public FloatingPointTolerantDifferenceListener(DifferenceListener delegateTo, double tolerance) {
        super(delegateTo);
        this.tolerance = tolerance;
    }

    protected int textualDifference(Difference d) {
        String control = d.getControlNodeDetail().getValue();
        String test = d.getTestNodeDetail().getValue();
        if (control != null && test != null) {
            try {
                double controlVal = Double.parseDouble(control);
                double testVal = Double.parseDouble(test);
                return Math.abs(controlVal - testVal) <= this.tolerance ? 1 : 0;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return super.textualDifference(d);
    }
}

