/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions.logstash;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.spi.LifeCycle;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.openexchange.logback.extensions.logstash.CustomField;
import com.openexchange.logback.extensions.logstash.LogstashFieldName;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;

public class LogstashFormatter
implements LifeCycle {
    private boolean isStarted;
    public static final FastDateFormat LOGSTASH_TIMEFORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private List<CustomField> customFields = new ArrayList<CustomField>();

    public void start() {
        this.isStarted = true;
    }

    public void stop() {
        this.isStarted = false;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(ILoggingEvent event, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)baos);){
            generator.configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false);
            generator.writeStartObject();
            generator.writeStringField(LogstashFieldName.timestamp.getLogstashName(), LOGSTASH_TIMEFORMAT.format(event.getTimeStamp()));
            generator.writeNumberField(LogstashFieldName.version.getLogstashName(), 1);
            generator.writeStringField(LogstashFieldName.level.getLogstashName(), event.getLevel().levelStr);
            generator.writeStringField(LogstashFieldName.logger.getLogstashName(), event.getLoggerName());
            generator.writeStringField(LogstashFieldName.thread.getLogstashName(), event.getThreadName());
            generator.writeStringField(LogstashFieldName.message.getLogstashName(), event.getFormattedMessage());
            generator.writeNumberField(LogstashFieldName.line.getLogstashName(), LogstashFormatter.getLineNumber(event));
            generator.writeStringField(LogstashFieldName.clazz.getLogstashName(), LogstashFormatter.getFullyQualifiedName(event));
            if (event.getMarker() != null) {
                generator.writeStringField(LogstashFieldName.marker.getLogstashName(), event.getMarker().getName());
            }
            if (event.getThrowableProxy() != null) {
                generator.writeStringField(LogstashFieldName.stacktrace.getLogstashName(), ThrowableProxyUtil.asString((IThrowableProxy)event.getThrowableProxy()));
            }
            Map mdc = event.getMDCPropertyMap();
            for (String key : mdc.keySet()) {
                generator.writeFieldName(key);
                generator.writeObject(mdc.get(key));
            }
            for (CustomField customField : this.customFields) {
                generator.writeFieldName(customField.getKey());
                generator.writeObject((Object)customField.getValue());
            }
            generator.writeEndObject();
            generator.flush();
        }
        outputStream.write(baos.toByteArray());
    }

    private static int getLineNumber(ILoggingEvent event) {
        StackTraceElement[] cda = event.getCallerData();
        if (cda != null && cda.length > 0) {
            return cda[0].getLineNumber();
        }
        return -1;
    }

    private static String getFullyQualifiedName(ILoggingEvent event) {
        StackTraceElement[] cda = event.getCallerData();
        if (cda != null && cda.length > 0) {
            return cda[0].getClassName();
        }
        return "?";
    }

    public void addCustomField(CustomField customField) {
        this.customFields.add(customField);
    }
}

