/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.apache.felix.eventadmin.impl.handler.EventHandlerProxy;
import org.apache.felix.eventadmin.impl.tasks.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.tasks.Rendezvous;
import org.apache.felix.eventadmin.impl.tasks.SyncThread;
import org.osgi.service.event.Event;

public class SyncDeliverTasks {
    private final DefaultThreadPool pool;
    private long timeout;

    public SyncDeliverTasks(DefaultThreadPool pool, long timeout) {
        this.pool = pool;
        this.update(timeout);
    }

    public void update(long timeout) {
        this.timeout = timeout;
    }

    private boolean useTimeout(EventHandlerProxy proxy) {
        if (this.timeout > 0L) {
            return proxy.useTimeout();
        }
        return false;
    }

    public void execute(Collection<EventHandlerProxy> tasks, final Event event, boolean filterAsyncUnordered) {
        Thread sleepingThread = Thread.currentThread();
        SyncThread syncThread = sleepingThread instanceof SyncThread ? (SyncThread)sleepingThread : null;
        for (final EventHandlerProxy task : tasks) {
            if (!this.useTimeout(task)) {
                task.sendEvent(event);
                continue;
            }
            if (syncThread != null) {
                long startTime = System.currentTimeMillis();
                task.sendEvent(event);
                if (System.currentTimeMillis() - startTime <= this.timeout) continue;
                task.blackListHandler();
                continue;
            }
            final Rendezvous startBarrier = new Rendezvous();
            final Rendezvous timerBarrier = new Rendezvous();
            this.pool.executeTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        startBarrier.waitForRendezvous();
                        task.sendEvent(event);
                        timerBarrier.waitForRendezvous();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            });
            startBarrier.waitForRendezvous();
            try {
                timerBarrier.waitAttemptForRendezvous(this.timeout);
            }
            catch (TimeoutException ie) {
                task.blackListHandler();
            }
        }
    }
}

