/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lambda.AWSLambdaAsync;
import com.amazonaws.services.lambda.AWSLambdaClient;
import com.amazonaws.services.lambda.model.AddPermissionRequest;
import com.amazonaws.services.lambda.model.AddPermissionResult;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingResult;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.services.lambda.model.GetEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.GetEventSourceMappingResult;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.GetPolicyRequest;
import com.amazonaws.services.lambda.model.GetPolicyResult;
import com.amazonaws.services.lambda.model.InvokeAsyncRequest;
import com.amazonaws.services.lambda.model.InvokeAsyncResult;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsRequest;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsResult;
import com.amazonaws.services.lambda.model.ListFunctionsRequest;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.amazonaws.services.lambda.model.RemovePermissionRequest;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSLambdaAsyncClient
extends AWSLambdaClient
implements AWSLambdaAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSLambdaAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSLambdaAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLambdaAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSLambdaAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSLambdaAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> deleteFunctionAsync(final DeleteFunctionRequest deleteFunctionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLambdaAsyncClient.this.deleteFunction(deleteFunctionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteFunctionAsync(final DeleteFunctionRequest deleteFunctionRequest, final AsyncHandler<DeleteFunctionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLambdaAsyncClient.this.deleteFunction(deleteFunctionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteFunctionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(final AddPermissionRequest addPermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddPermissionResult>(){

            @Override
            public AddPermissionResult call() throws Exception {
                return AWSLambdaAsyncClient.this.addPermission(addPermissionRequest);
            }
        });
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(final AddPermissionRequest addPermissionRequest, final AsyncHandler<AddPermissionRequest, AddPermissionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddPermissionResult>(){

            @Override
            public AddPermissionResult call() throws Exception {
                AddPermissionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.addPermission(addPermissionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(addPermissionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListFunctionsResult> listFunctionsAsync(final ListFunctionsRequest listFunctionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListFunctionsResult>(){

            @Override
            public ListFunctionsResult call() throws Exception {
                return AWSLambdaAsyncClient.this.listFunctions(listFunctionsRequest);
            }
        });
    }

    @Override
    public Future<ListFunctionsResult> listFunctionsAsync(final ListFunctionsRequest listFunctionsRequest, final AsyncHandler<ListFunctionsRequest, ListFunctionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListFunctionsResult>(){

            @Override
            public ListFunctionsResult call() throws Exception {
                ListFunctionsResult result;
                try {
                    result = AWSLambdaAsyncClient.this.listFunctions(listFunctionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listFunctionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> removePermissionAsync(final RemovePermissionRequest removePermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLambdaAsyncClient.this.removePermission(removePermissionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> removePermissionAsync(final RemovePermissionRequest removePermissionRequest, final AsyncHandler<RemovePermissionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLambdaAsyncClient.this.removePermission(removePermissionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(removePermissionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateFunctionResult> createFunctionAsync(final CreateFunctionRequest createFunctionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateFunctionResult>(){

            @Override
            public CreateFunctionResult call() throws Exception {
                return AWSLambdaAsyncClient.this.createFunction(createFunctionRequest);
            }
        });
    }

    @Override
    public Future<CreateFunctionResult> createFunctionAsync(final CreateFunctionRequest createFunctionRequest, final AsyncHandler<CreateFunctionRequest, CreateFunctionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateFunctionResult>(){

            @Override
            public CreateFunctionResult call() throws Exception {
                CreateFunctionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.createFunction(createFunctionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createFunctionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEventSourceMappingResult> updateEventSourceMappingAsync(final UpdateEventSourceMappingRequest updateEventSourceMappingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateEventSourceMappingResult>(){

            @Override
            public UpdateEventSourceMappingResult call() throws Exception {
                return AWSLambdaAsyncClient.this.updateEventSourceMapping(updateEventSourceMappingRequest);
            }
        });
    }

    @Override
    public Future<UpdateEventSourceMappingResult> updateEventSourceMappingAsync(final UpdateEventSourceMappingRequest updateEventSourceMappingRequest, final AsyncHandler<UpdateEventSourceMappingRequest, UpdateEventSourceMappingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateEventSourceMappingResult>(){

            @Override
            public UpdateEventSourceMappingResult call() throws Exception {
                UpdateEventSourceMappingResult result;
                try {
                    result = AWSLambdaAsyncClient.this.updateEventSourceMapping(updateEventSourceMappingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateEventSourceMappingRequest, result);
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<InvokeAsyncResult> invokeAsyncAsync(final InvokeAsyncRequest invokeAsyncRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<InvokeAsyncResult>(){

            @Override
            public InvokeAsyncResult call() throws Exception {
                return AWSLambdaAsyncClient.this.invokeAsync(invokeAsyncRequest);
            }
        });
    }

    @Override
    public Future<InvokeAsyncResult> invokeAsyncAsync(final InvokeAsyncRequest invokeAsyncRequest, final AsyncHandler<InvokeAsyncRequest, InvokeAsyncResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<InvokeAsyncResult>(){

            @Override
            public InvokeAsyncResult call() throws Exception {
                InvokeAsyncResult result;
                try {
                    result = AWSLambdaAsyncClient.this.invokeAsync(invokeAsyncRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(invokeAsyncRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFunctionConfigurationResult> updateFunctionConfigurationAsync(final UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateFunctionConfigurationResult>(){

            @Override
            public UpdateFunctionConfigurationResult call() throws Exception {
                return AWSLambdaAsyncClient.this.updateFunctionConfiguration(updateFunctionConfigurationRequest);
            }
        });
    }

    @Override
    public Future<UpdateFunctionConfigurationResult> updateFunctionConfigurationAsync(final UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest, final AsyncHandler<UpdateFunctionConfigurationRequest, UpdateFunctionConfigurationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateFunctionConfigurationResult>(){

            @Override
            public UpdateFunctionConfigurationResult call() throws Exception {
                UpdateFunctionConfigurationResult result;
                try {
                    result = AWSLambdaAsyncClient.this.updateFunctionConfiguration(updateFunctionConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateFunctionConfigurationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<InvokeResult> invokeAsync(final InvokeRequest invokeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<InvokeResult>(){

            @Override
            public InvokeResult call() throws Exception {
                return AWSLambdaAsyncClient.this.invoke(invokeRequest);
            }
        });
    }

    @Override
    public Future<InvokeResult> invokeAsync(final InvokeRequest invokeRequest, final AsyncHandler<InvokeRequest, InvokeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<InvokeResult>(){

            @Override
            public InvokeResult call() throws Exception {
                InvokeResult result;
                try {
                    result = AWSLambdaAsyncClient.this.invoke(invokeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(invokeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(final GetPolicyRequest getPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetPolicyResult>(){

            @Override
            public GetPolicyResult call() throws Exception {
                return AWSLambdaAsyncClient.this.getPolicy(getPolicyRequest);
            }
        });
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(final GetPolicyRequest getPolicyRequest, final AsyncHandler<GetPolicyRequest, GetPolicyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetPolicyResult>(){

            @Override
            public GetPolicyResult call() throws Exception {
                GetPolicyResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getPolicy(getPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getPolicyRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListEventSourceMappingsResult> listEventSourceMappingsAsync(final ListEventSourceMappingsRequest listEventSourceMappingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListEventSourceMappingsResult>(){

            @Override
            public ListEventSourceMappingsResult call() throws Exception {
                return AWSLambdaAsyncClient.this.listEventSourceMappings(listEventSourceMappingsRequest);
            }
        });
    }

    @Override
    public Future<ListEventSourceMappingsResult> listEventSourceMappingsAsync(final ListEventSourceMappingsRequest listEventSourceMappingsRequest, final AsyncHandler<ListEventSourceMappingsRequest, ListEventSourceMappingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListEventSourceMappingsResult>(){

            @Override
            public ListEventSourceMappingsResult call() throws Exception {
                ListEventSourceMappingsResult result;
                try {
                    result = AWSLambdaAsyncClient.this.listEventSourceMappings(listEventSourceMappingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listEventSourceMappingsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetEventSourceMappingResult> getEventSourceMappingAsync(final GetEventSourceMappingRequest getEventSourceMappingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetEventSourceMappingResult>(){

            @Override
            public GetEventSourceMappingResult call() throws Exception {
                return AWSLambdaAsyncClient.this.getEventSourceMapping(getEventSourceMappingRequest);
            }
        });
    }

    @Override
    public Future<GetEventSourceMappingResult> getEventSourceMappingAsync(final GetEventSourceMappingRequest getEventSourceMappingRequest, final AsyncHandler<GetEventSourceMappingRequest, GetEventSourceMappingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetEventSourceMappingResult>(){

            @Override
            public GetEventSourceMappingResult call() throws Exception {
                GetEventSourceMappingResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getEventSourceMapping(getEventSourceMappingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getEventSourceMappingRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetFunctionConfigurationResult> getFunctionConfigurationAsync(final GetFunctionConfigurationRequest getFunctionConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFunctionConfigurationResult>(){

            @Override
            public GetFunctionConfigurationResult call() throws Exception {
                return AWSLambdaAsyncClient.this.getFunctionConfiguration(getFunctionConfigurationRequest);
            }
        });
    }

    @Override
    public Future<GetFunctionConfigurationResult> getFunctionConfigurationAsync(final GetFunctionConfigurationRequest getFunctionConfigurationRequest, final AsyncHandler<GetFunctionConfigurationRequest, GetFunctionConfigurationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFunctionConfigurationResult>(){

            @Override
            public GetFunctionConfigurationResult call() throws Exception {
                GetFunctionConfigurationResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getFunctionConfiguration(getFunctionConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getFunctionConfigurationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEventSourceMappingResult> deleteEventSourceMappingAsync(final DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteEventSourceMappingResult>(){

            @Override
            public DeleteEventSourceMappingResult call() throws Exception {
                return AWSLambdaAsyncClient.this.deleteEventSourceMapping(deleteEventSourceMappingRequest);
            }
        });
    }

    @Override
    public Future<DeleteEventSourceMappingResult> deleteEventSourceMappingAsync(final DeleteEventSourceMappingRequest deleteEventSourceMappingRequest, final AsyncHandler<DeleteEventSourceMappingRequest, DeleteEventSourceMappingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteEventSourceMappingResult>(){

            @Override
            public DeleteEventSourceMappingResult call() throws Exception {
                DeleteEventSourceMappingResult result;
                try {
                    result = AWSLambdaAsyncClient.this.deleteEventSourceMapping(deleteEventSourceMappingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteEventSourceMappingRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateEventSourceMappingResult> createEventSourceMappingAsync(final CreateEventSourceMappingRequest createEventSourceMappingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateEventSourceMappingResult>(){

            @Override
            public CreateEventSourceMappingResult call() throws Exception {
                return AWSLambdaAsyncClient.this.createEventSourceMapping(createEventSourceMappingRequest);
            }
        });
    }

    @Override
    public Future<CreateEventSourceMappingResult> createEventSourceMappingAsync(final CreateEventSourceMappingRequest createEventSourceMappingRequest, final AsyncHandler<CreateEventSourceMappingRequest, CreateEventSourceMappingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateEventSourceMappingResult>(){

            @Override
            public CreateEventSourceMappingResult call() throws Exception {
                CreateEventSourceMappingResult result;
                try {
                    result = AWSLambdaAsyncClient.this.createEventSourceMapping(createEventSourceMappingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createEventSourceMappingRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFunctionCodeResult> updateFunctionCodeAsync(final UpdateFunctionCodeRequest updateFunctionCodeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateFunctionCodeResult>(){

            @Override
            public UpdateFunctionCodeResult call() throws Exception {
                return AWSLambdaAsyncClient.this.updateFunctionCode(updateFunctionCodeRequest);
            }
        });
    }

    @Override
    public Future<UpdateFunctionCodeResult> updateFunctionCodeAsync(final UpdateFunctionCodeRequest updateFunctionCodeRequest, final AsyncHandler<UpdateFunctionCodeRequest, UpdateFunctionCodeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateFunctionCodeResult>(){

            @Override
            public UpdateFunctionCodeResult call() throws Exception {
                UpdateFunctionCodeResult result;
                try {
                    result = AWSLambdaAsyncClient.this.updateFunctionCode(updateFunctionCodeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateFunctionCodeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetFunctionResult> getFunctionAsync(final GetFunctionRequest getFunctionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFunctionResult>(){

            @Override
            public GetFunctionResult call() throws Exception {
                return AWSLambdaAsyncClient.this.getFunction(getFunctionRequest);
            }
        });
    }

    @Override
    public Future<GetFunctionResult> getFunctionAsync(final GetFunctionRequest getFunctionRequest, final AsyncHandler<GetFunctionRequest, GetFunctionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFunctionResult>(){

            @Override
            public GetFunctionResult call() throws Exception {
                GetFunctionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getFunction(getFunctionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getFunctionRequest, result);
                return result;
            }
        });
    }
}

