/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import org.javasimon.Counter;
import org.javasimon.Manager;
import org.javasimon.ManagerConfiguration;
import org.javasimon.Simon;
import org.javasimon.SimonFilter;
import org.javasimon.Stopwatch;
import org.javasimon.SwitchingManager;
import org.javasimon.callback.CompositeCallback;
import org.javasimon.utils.SystemDebugCallback;

public final class SimonManager {
    public static final String PROPERTY_CONFIG_FILE_NAME = "javasimon.config.file";
    public static final String PROPERTY_CONFIG_RESOURCE_NAME = "javasimon.config.resource";
    private static Manager manager = new SwitchingManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init() {
        SystemDebugCallback temporaryDebugCallback = new SystemDebugCallback();
        manager.callback().addCallback(temporaryDebugCallback);
        try {
            String resourceName;
            manager.configuration().clear();
            String fileName = System.getProperty(PROPERTY_CONFIG_FILE_NAME);
            if (fileName != null) {
                FileReader fileReader = new FileReader(fileName);
                try {
                    manager.configuration().readConfig(fileReader);
                }
                finally {
                    fileReader.close();
                }
            }
            if ((resourceName = System.getProperty(PROPERTY_CONFIG_RESOURCE_NAME)) != null) {
                InputStream is = SimonManager.class.getClassLoader().getResourceAsStream(resourceName);
                if (is == null) {
                    throw new FileNotFoundException(resourceName);
                }
                manager.configuration().readConfig(new InputStreamReader(is));
            }
        }
        catch (Exception e) {
            manager.callback().onManagerWarning("SimonManager initialization error", e);
        }
        manager.callback().removeCallback(temporaryDebugCallback);
    }

    private SimonManager() {
        throw new AssertionError();
    }

    public static Simon getSimon(String name) {
        return manager.getSimon(name);
    }

    public static void destroySimon(String name) {
        manager.destroySimon(name);
    }

    public static Counter getCounter(String name) {
        return manager.getCounter(name);
    }

    public static Stopwatch getStopwatch(String name) {
        return manager.getStopwatch(name);
    }

    public static void enable() {
        manager.enable();
    }

    public static void disable() {
        manager.disable();
    }

    public static boolean isEnabled() {
        return manager.isEnabled();
    }

    public static Simon getRootSimon() {
        return manager.getRootSimon();
    }

    public static Collection<String> getSimonNames() {
        return manager.getSimonNames();
    }

    public static Collection<Simon> getSimons(SimonFilter simonFilter) {
        return manager.getSimons(simonFilter);
    }

    public static void clear() {
        manager.clear();
    }

    public static CompositeCallback callback() {
        return manager.callback();
    }

    public static ManagerConfiguration configuration() {
        return manager.configuration();
    }

    public static Manager manager() {
        return manager;
    }

    public static void message(String message) {
        manager.message(message);
    }

    public static void warning(String warning, Exception cause) {
        manager.warning(warning, cause);
    }

    static {
        SimonManager.init();
    }
}

