/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.templating;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum TemplateErrorMessage implements DisplayableOXExceptionCode
{
    IOException(CATEGORY_SERVICE_DOWN, 1, "An I/O error occurred.", null),
    UnderlyingException(CATEGORY_ERROR, 2, "The underlying templating system threw an exception: %1$s", null),
    TemplateNotFound(CATEGORY_ERROR, 3, "The template %1$s does not exist.", null),
    SQLException(CATEGORY_ERROR, 4, "An SQL error occurred: %1$s", "Error while reading/writing data from/to the database."),
    AccessDenied(CATEGORY_PERMISSION_DENIED, 5, "File access denied.", "File access denied."),
    TemplateNotWhitelisted(CATEGORY_PERMISSION_DENIED, 6, "This template was not whitelisted,", "This template was not whitelisted,");

    public static final String PREFIX = "TMPL";
    private final Category category;
    private final int errorCode;
    private final String message;
    private String displayMessage;

    private TemplateErrorMessage(Category category, int errorCode, String message, String displayMessage) {
        this.category = category;
        this.errorCode = errorCode;
        this.message = message;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

