/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.ids;

import org.jdom2.Attribute;
import org.jdom2.AttributeType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.contrib.ids.IdDocument;

public class IdAttribute
extends Attribute {
    private static final long serialVersionUID = 1L;

    public IdAttribute(String name, String value, Namespace namespace) {
        super(name, value, namespace);
    }

    public IdAttribute(String name, String value, AttributeType type, Namespace namespace) {
        super(name, value, type, namespace);
    }

    public IdAttribute(String name, String value) {
        this(name, value, UNDECLARED_TYPE, Namespace.NO_NAMESPACE);
    }

    public IdAttribute(String name, String value, AttributeType type) {
        this(name, value, type, Namespace.NO_NAMESPACE);
    }

    protected Attribute setParent(Element parent) {
        Element oldParent = this.getParent();
        super.setParent(parent);
        if (this.getAttributeType() == Attribute.ID_TYPE) {
            Document doc;
            if (oldParent != null && (doc = oldParent.getDocument()) instanceof IdDocument) {
                ((IdDocument)doc).removeId(this.getValue());
            }
            if ((doc = this.getDocument()) instanceof IdDocument) {
                ((IdDocument)doc).addId(this.getValue(), this.getParent());
            }
        }
        return this;
    }

    public Attribute setValue(String value) {
        Document doc;
        String oldValue = this.getValue();
        super.setValue(value);
        if (this.getAttributeType() == Attribute.ID_TYPE && (doc = this.getDocument()) instanceof IdDocument) {
            ((IdDocument)doc).removeId(oldValue);
            ((IdDocument)doc).addId(this.getValue(), this.getParent());
        }
        return this;
    }

    public Attribute setAttributeType(AttributeType type) {
        AttributeType oldType = this.getAttributeType();
        if (type != oldType) {
            super.setAttributeType(type);
            Document doc = this.getDocument();
            if (doc instanceof IdDocument) {
                if (oldType == Attribute.ID_TYPE) {
                    ((IdDocument)doc).removeId(this.getValue());
                }
                if (type == Attribute.ID_TYPE) {
                    ((IdDocument)doc).addId(this.getValue(), this.getParent());
                }
            }
        }
        return this;
    }
}

