/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.metadata.AbstractEntry;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.exif.EXIFWriter;
import com.twelvemonkeys.imageio.metadata.exif.Rational;
import com.twelvemonkeys.imageio.metadata.exif.TIFF;
import com.twelvemonkeys.imageio.plugins.tiff.CCITTFaxEncoderStream;
import com.twelvemonkeys.imageio.plugins.tiff.HorizontalDifferencingStream;
import com.twelvemonkeys.imageio.plugins.tiff.LZWEncoder;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageMetadata;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReader;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageWriteParam;
import com.twelvemonkeys.imageio.stream.SubImageOutputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.io.enc.PackBitsEncoder;
import com.twelvemonkeys.lang.Validate;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.IIOParam;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class TIFFImageWriter
extends ImageWriterBase {
    public static final Rational STANDARD_DPI = new Rational(72L);

    TIFFImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        long l;
        Object object;
        int[] nArray;
        int[] nArray2;
        this.assertOutput();
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        ColorModel colorModel = renderedImage.getColorModel();
        int n = colorModel.getNumComponents();
        TIFFImageMetadata tIFFImageMetadata = iIOImage.getMetadata() != null ? this.convertImageMetadata(iIOImage.getMetadata(), ImageTypeSpecifier.createFromRenderedImage(renderedImage), imageWriteParam) : this.initMeta(null, ImageTypeSpecifier.createFromRenderedImage(renderedImage), imageWriteParam);
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            nArray2 = ((ComponentSampleModel)sampleModel).getBandOffsets();
            nArray = null;
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
            nArray2 = null;
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            nArray = null;
            nArray2 = new int[]{0};
        } else {
            throw new IllegalArgumentException("Unknown bit/bandOffsets for sample model: " + sampleModel);
        }
        LinkedHashMap<Integer, Entry> linkedHashMap = new LinkedHashMap<Integer, Entry>();
        linkedHashMap.put(256, (Entry)new TIFFEntry(256, renderedImage.getWidth()));
        linkedHashMap.put(257, (Entry)new TIFFEntry(257, renderedImage.getHeight()));
        linkedHashMap.put(258, (Entry)new TIFFEntry(258, this.asShortArray(sampleModel.getSampleSize())));
        if (n > colorModel.getNumColorComponents()) {
            if (colorModel.hasAlpha()) {
                linkedHashMap.put(338, (Entry)new TIFFEntry(338, colorModel.isAlphaPremultiplied() ? 1 : 2));
            } else {
                linkedHashMap.put(338, (Entry)new TIFFEntry(338, 0));
            }
        }
        int n2 = (imageWriteParam == null || imageWriteParam.getCompressionMode() == 3) && iIOImage.getMetadata() != null && tIFFImageMetadata.getIFD().getEntryById((Object)259) != null ? (Integer)tIFFImageMetadata.getIFD().getEntryById((Object)259).getValue() : TIFFImageWriteParam.getCompressionType(imageWriteParam);
        linkedHashMap.put(259, (Entry)new TIFFEntry(259, n2));
        switch (n2) {
            case 5: 
            case 8: 
            case 32946: {
                linkedHashMap.put(317, (Entry)new TIFFEntry(317, 2));
                break;
            }
            case 3: {
                Object object2 = tIFFImageMetadata.getIFD().getEntryById((Object)292);
                if (object2 == null) {
                    object2 = new TIFFEntry(292, 1L);
                }
                linkedHashMap.put(292, (Entry)object2);
                break;
            }
            case 4: {
                object = tIFFImageMetadata.getIFD().getEntryById((Object)293);
                if (object == null) {
                    object = new TIFFEntry(293, 0L);
                }
                linkedHashMap.put(293, (Entry)object);
                break;
            }
        }
        int n3 = n2 == 7 ? 6 : this.getPhotometricInterpretation(colorModel);
        linkedHashMap.put(262, (Entry)new TIFFEntry(262, n3));
        if (n3 == 3 && colorModel instanceof IndexColorModel) {
            linkedHashMap.put(320, (Entry)new TIFFEntry(320, this.createColorMap((IndexColorModel)colorModel)));
            linkedHashMap.put(277, (Entry)new TIFFEntry(277, 1));
        } else {
            if (colorModel.getPixelSize() == 1) {
                n = 1;
            }
            linkedHashMap.put(277, (Entry)new TIFFEntry(277, n));
            object = colorModel.getColorSpace();
            if (object instanceof ICC_ColorSpace && !((ColorSpace)object).isCS_sRGB()) {
                linkedHashMap.put(34675, (Entry)new TIFFEntry(34675, ((ICC_ColorSpace)object).getProfile().getData()));
            }
        }
        if (sampleModel.getDataType() == 2) {
            linkedHashMap.put(339, (Entry)new TIFFEntry(339, 2));
        }
        object = tIFFImageMetadata.getIFD().getEntryById((Object)305);
        linkedHashMap.put(305, (Entry)(object != null ? object : new TIFFEntry(305, "TwelveMonkeys ImageIO TIFF writer " + this.originatingProvider.getVersion())));
        Entry entry = tIFFImageMetadata.getIFD().getEntryById((Object)282);
        linkedHashMap.put(282, (Entry)(entry != null ? entry : new TIFFEntry(282, STANDARD_DPI)));
        Entry entry2 = tIFFImageMetadata.getIFD().getEntryById((Object)283);
        linkedHashMap.put(283, (Entry)(entry2 != null ? entry2 : new TIFFEntry(283, STANDARD_DPI)));
        Entry entry3 = tIFFImageMetadata.getIFD().getEntryById((Object)296);
        linkedHashMap.put(296, (Entry)(entry3 != null ? entry3 : new TIFFEntry(296, 2)));
        linkedHashMap.put(278, (Entry)new TIFFEntry(278, Integer.MAX_VALUE));
        TIFFEntry tIFFEntry = new TIFFEntry(279, -1);
        linkedHashMap.put(279, (Entry)tIFFEntry);
        TIFFEntry tIFFEntry2 = new TIFFEntry(273, -1);
        linkedHashMap.put(273, (Entry)tIFFEntry2);
        EXIFWriter eXIFWriter = new EXIFWriter();
        if (n2 == 1) {
            l = eXIFWriter.computeIFDSize(linkedHashMap.values()) + 12L;
            linkedHashMap.remove((Object)tIFFEntry);
            linkedHashMap.put(279, (Entry)new TIFFEntry(279, renderedImage.getWidth() * renderedImage.getHeight() * n));
            linkedHashMap.remove((Object)tIFFEntry2);
            linkedHashMap.put(273, (Entry)new TIFFEntry(273, l));
            eXIFWriter.write(linkedHashMap.values(), this.imageOutput);
            this.imageOutput.flush();
        } else {
            eXIFWriter.writeTIFFHeader(this.imageOutput);
            this.imageOutput.writeInt(-1);
        }
        if (n2 == 7) {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("JPEG");
            if (!iterator.hasNext()) {
                throw new IIOException("No JPEG ImageWriter found!");
            }
            ImageWriter imageWriter = iterator.next();
            try {
                imageWriter.setOutput(new SubImageOutputStream(this.imageOutput));
                imageWriter.write(renderedImage);
            }
            finally {
                imageWriter.dispose();
            }
        } else {
            this.writeImageData(this.createCompressorStream(renderedImage, imageWriteParam, linkedHashMap), renderedImage, n, nArray2, nArray);
        }
        if (n2 != 1) {
            l = this.imageOutput.getStreamPosition();
            linkedHashMap.remove((Object)tIFFEntry2);
            linkedHashMap.put(273, (Entry)new TIFFEntry(273, 8));
            linkedHashMap.remove((Object)tIFFEntry);
            linkedHashMap.put(279, (Entry)new TIFFEntry(279, l - 8L));
            long l2 = eXIFWriter.writeIFD(linkedHashMap.values(), this.imageOutput);
            this.imageOutput.writeInt(0);
            l = this.imageOutput.getStreamPosition();
            this.imageOutput.seek(4L);
            this.imageOutput.writeInt((int)l2);
            this.imageOutput.seek(l);
            this.imageOutput.flush();
        }
    }

    private DataOutput createCompressorStream(RenderedImage renderedImage, ImageWriteParam imageWriteParam, Map<Integer, Entry> map) {
        int n = (Integer)map.get(259).getValue();
        switch (n) {
            case 1: {
                return this.imageOutput;
            }
            case 32773: {
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new EncoderStream(outputStream, (Encoder)new PackBitsEncoder(), true);
                return new DataOutputStream(outputStream);
            }
            case 8: 
            case 32946: {
                int n2 = 1;
                if (imageWriteParam.getCompressionMode() == 2) {
                    n2 = 9 - Math.round(8.0f * imageWriteParam.getCompressionQuality());
                }
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new DeflaterOutputStream(outputStream, new Deflater(n2), 1024);
                outputStream = new HorizontalDifferencingStream(outputStream, renderedImage.getTileWidth(), renderedImage.getTile(0, 0).getNumBands(), renderedImage.getColorModel().getComponentSize(0), this.imageOutput.getByteOrder());
                return new DataOutputStream(outputStream);
            }
            case 5: {
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new EncoderStream(outputStream, (Encoder)new LZWEncoder((renderedImage.getTileWidth() * renderedImage.getTileHeight() * renderedImage.getTile(0, 0).getNumBands() * renderedImage.getColorModel().getComponentSize(0) + 7) / 8));
                outputStream = new HorizontalDifferencingStream(outputStream, renderedImage.getTileWidth(), renderedImage.getTile(0, 0).getNumBands(), renderedImage.getColorModel().getComponentSize(0), this.imageOutput.getByteOrder());
                return new DataOutputStream(outputStream);
            }
            case 2: 
            case 3: 
            case 4: {
                Entry entry;
                long l = 0L;
                if (n != 2) {
                    l = (Long)map.get(n == 3 ? 292 : 293).getValue();
                }
                int n3 = (Integer)((entry = map.get(266)) != null ? entry.getValue() : Integer.valueOf(1));
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new CCITTFaxEncoderStream(outputStream, renderedImage.getTileWidth(), renderedImage.getTileHeight(), n, n3, l);
                return new DataOutputStream(outputStream);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported TIFF compression: %d", n));
    }

    private int getPhotometricInterpretation(ColorModel colorModel) {
        if (colorModel.getPixelSize() == 1) {
            if (colorModel instanceof IndexColorModel) {
                if (colorModel.getRGB(0) == -1 && colorModel.getRGB(1) == -16777216) {
                    return 0;
                }
                if (colorModel.getRGB(0) != -16777216 || colorModel.getRGB(1) != -1) {
                    return 3;
                }
            }
            return 1;
        }
        if (colorModel instanceof IndexColorModel) {
            return 3;
        }
        switch (colorModel.getColorSpace().getType()) {
            case 6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 9: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Can't determine PhotometricInterpretation for color model: " + colorModel);
    }

    private short[] createColorMap(IndexColorModel indexColorModel) {
        short[] sArray = new short[(int)(3.0 * Math.pow(2.0, indexColorModel.getPixelSize()))];
        for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
            int n = indexColorModel.getRGB(i);
            sArray[i] = (short)this.upScale(n >> 16 & 0xFF);
            sArray[i + sArray.length / 3] = (short)this.upScale(n >> 8 & 0xFF);
            sArray[i + 2 * sArray.length / 3] = (short)this.upScale(n & 0xFF);
        }
        return sArray;
    }

    private int upScale(int n) {
        return 257 * n;
    }

    private short[] asShortArray(int[] nArray) {
        short[] sArray = new short[nArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)nArray[i];
        }
        return sArray;
    }

    private void writeImageData(DataOutput dataOutput, RenderedImage renderedImage, int n, int[] nArray, int[] nArray2) throws IOException {
        this.processImageStarted(0);
        int n2 = renderedImage.getMinTileY();
        int n3 = n2 + renderedImage.getNumYTiles();
        int n4 = renderedImage.getMinTileX();
        int n5 = n4 + renderedImage.getNumXTiles();
        int n6 = renderedImage.getTileHeight();
        int n7 = renderedImage.getTileWidth();
        int n8 = renderedImage.getSampleModel().getSampleSize(0);
        ByteBuffer byteBuffer = n8 == 1 ? ByteBuffer.allocate((n7 + 7) / 8) : ByteBuffer.allocate(n7 * renderedImage.getSampleModel().getNumBands() * n8 / 8);
        for (int i = n2; i < n3; ++i) {
            block6: for (int j = n4; j < n5; ++j) {
                Raster raster = renderedImage.getTile(j, i);
                DataBuffer dataBuffer = raster.getDataBuffer();
                int n9 = raster.getNumBands();
                switch (dataBuffer.getDataType()) {
                    case 0: {
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = 0; n15 < dataBuffer.getNumBanks(); ++n15) {
                            for (n14 = 0; n14 < n6; ++n14) {
                                n13 = n8 == 1 ? (n7 + 7) / 8 : n7;
                                int n16 = n14 * n13 * n9;
                                for (n12 = 0; n12 < n13; ++n12) {
                                    n11 = n16 + n12 * n9;
                                    for (n10 = 0; n10 < n9; ++n10) {
                                        byteBuffer.put((byte)(dataBuffer.getElem(n15, n11 + nArray[n10]) & 0xFF));
                                    }
                                }
                                this.flushBuffer(byteBuffer, dataOutput);
                                if (!(dataOutput instanceof DataOutputStream)) continue;
                                DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                                dataOutputStream.flush();
                            }
                        }
                        continue block6;
                    }
                    case 1: 
                    case 2: {
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        if (n == 1) {
                            for (n15 = 0; n15 < dataBuffer.getNumBanks(); ++n15) {
                                for (n14 = 0; n14 < n6; ++n14) {
                                    n13 = n14 * n7;
                                    for (int k = 0; k < n7; ++k) {
                                        n12 = n13 + k;
                                        byteBuffer.putShort((short)(dataBuffer.getElem(n15, n12) & 0xFFFF));
                                    }
                                    this.flushBuffer(byteBuffer, dataOutput);
                                    if (!(dataOutput instanceof DataOutputStream)) continue;
                                    DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                                    dataOutputStream.flush();
                                }
                            }
                            continue block6;
                        }
                        throw new IllegalArgumentException("Not implemented for data type: " + dataBuffer.getDataType());
                    }
                    case 3: {
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = 0; n15 < dataBuffer.getNumBanks(); ++n15) {
                            for (n14 = 0; n14 < n6; ++n14) {
                                n13 = n14 * n7;
                                for (int k = 0; k < n7; ++k) {
                                    n12 = n13 + k;
                                    n11 = dataBuffer.getElem(n15, n12);
                                    for (n10 = 0; n10 < n9; ++n10) {
                                        byteBuffer.put((byte)(n11 >> nArray2[n10] & 0xFF));
                                    }
                                }
                                this.flushBuffer(byteBuffer, dataOutput);
                                if (!(dataOutput instanceof DataOutputStream)) continue;
                                DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                                dataOutputStream.flush();
                            }
                        }
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Not implemented for data type: " + dataBuffer.getDataType());
                    }
                }
            }
            if (dataOutput instanceof DataOutputStream) {
                DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                dataOutputStream.flush();
            }
            this.processImageProgress(100.0f * (float)i / (float)n3);
        }
        if (dataOutput instanceof DataOutputStream) {
            DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
            dataOutputStream.close();
        }
        this.processImageComplete();
    }

    private void flushBuffer(ByteBuffer byteBuffer, DataOutput dataOutput) throws IOException {
        byteBuffer.flip();
        dataOutput.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
        byteBuffer.clear();
    }

    public TIFFImageMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return this.initMeta(null, imageTypeSpecifier, imageWriteParam);
    }

    public TIFFImageMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        Directory directory;
        Validate.notNull((Object)iIOMetadata, (String)"inData");
        Validate.notNull((Object)imageTypeSpecifier, (String)"imageType");
        if (iIOMetadata instanceof TIFFImageMetadata) {
            directory = ((TIFFImageMetadata)((Object)iIOMetadata)).getIFD();
        } else {
            TIFFImageMetadata tIFFImageMetadata;
            block6: {
                tIFFImageMetadata = new TIFFImageMetadata(Collections.emptySet());
                try {
                    if (Arrays.asList(iIOMetadata.getMetadataFormatNames()).contains("com_sun_media_imageio_plugins_tiff_image_1.0")) {
                        tIFFImageMetadata.setFromTree("com_sun_media_imageio_plugins_tiff_image_1.0", iIOMetadata.getAsTree("com_sun_media_imageio_plugins_tiff_image_1.0"));
                        break block6;
                    }
                    if (iIOMetadata.isStandardMetadataFormatSupported()) {
                        tIFFImageMetadata.setFromTree("javax_imageio_1.0", iIOMetadata.getAsTree("javax_imageio_1.0"));
                        break block6;
                    }
                    return null;
                }
                catch (IIOInvalidTreeException iIOInvalidTreeException) {
                    // empty catch block
                }
            }
            directory = tIFFImageMetadata.getIFD();
        }
        return this.initMeta(directory, imageTypeSpecifier, imageWriteParam);
    }

    private TIFFImageMetadata initMeta(Directory directory, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        Validate.notNull((Object)imageTypeSpecifier, (String)"imageType");
        LinkedHashMap<Integer, Object> linkedHashMap = new LinkedHashMap<Integer, Object>(directory != null ? directory.size() + 10 : 20);
        if (directory != null) {
            for (Entry entry : directory) {
                linkedHashMap.put((Integer)entry.getIdentifier(), entry);
            }
        }
        linkedHashMap.put(262, (Object)new TIFFEntry(262, 3, this.getPhotometricInterpretation(imageTypeSpecifier.getColorModel())));
        return new TIFFImageMetadata(linkedHashMap.values());
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return super.getDefaultStreamMetadata(imageWriteParam);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return super.convertStreamMetadata(iIOMetadata, imageWriteParam);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new TIFFImageWriteParam();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n;
        int n2 = 0;
        int n3 = stringArray.length > n2 + 1 ? Integer.parseInt(stringArray[n2++]) : -1;
        int n4 = n = stringArray.length > n2 + 1 ? Integer.parseInt(stringArray[n2++]) : 0;
        if (stringArray.length <= n2) {
            System.err.println("No file specified");
            System.exit(1);
        }
        File file = new File(stringArray[n2++]);
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);){
            object5 = ImageIO.getImageReaders(imageInputStream);
            if (!object5.hasNext()) {
                System.err.println("No reader for: " + file);
                System.exit(1);
            }
            object4 = object5.next();
            ((ImageReader)object4).setInput(imageInputStream);
            object3 = ((ImageReader)object4).getDefaultReadParam();
            ((ImageReadParam)object3).setDestinationType(((ImageReader)object4).getRawImageType(0));
            if (((IIOParam)object3).getDestinationType() == null) {
                object2 = ((ImageReader)object4).getImageTypes(0);
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((ImageTypeSpecifier)object).getColorModel().getColorSpace().getType() != 9) continue;
                    ((ImageReadParam)object3).setDestinationType((ImageTypeSpecifier)object);
                }
            }
            System.err.println("param.getDestinationType(): " + ((IIOParam)object3).getDestinationType());
            bufferedImage = ((ImageReader)object4).read(0, (ImageReadParam)object3);
        }
        System.err.println("original: " + bufferedImage);
        if (n3 <= 0 || n3 == bufferedImage.getType()) {
            object5 = bufferedImage;
        } else if (n3 == 13) {
            object5 = ImageUtil.createIndexed((Image)bufferedImage, (int)256, null, (int)259);
        } else {
            object5 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n3);
            object4 = ((BufferedImage)object5).createGraphics();
            try {
                ((Graphics)object4).drawImage(bufferedImage, 0, 0, null);
            }
            finally {
                ((Graphics)object4).dispose();
            }
        }
        bufferedImage = null;
        object4 = File.createTempFile(file.getName().replace('.', '-'), ".tif");
        System.err.println("output: " + object4);
        object3 = new TIFFImageWriter(null);
        object2 = ImageIO.createImageOutputStream(object4);
        try {
            ((TIFFImageWriter)((Object)object3)).setOutput(object2);
            object = ((TIFFImageWriter)((Object)object3)).getDefaultWriteParam();
            ((ImageWriteParam)object).setCompressionMode(2);
            ((ImageWriteParam)object).setCompressionType(((ImageWriteParam)object).getCompressionTypes()[n]);
            System.err.println("compression: " + ((ImageWriteParam)object).getLocalizedCompressionTypeName());
            long l = System.currentTimeMillis();
            ((TIFFImageWriter)((Object)object3)).write(null, new IIOImage((RenderedImage)object5, null, null), (ImageWriteParam)object);
            System.err.println("Write time: " + (System.currentTimeMillis() - l) + " ms");
        }
        finally {
            object2.close();
        }
        System.err.println("output.length: " + ((File)object4).length());
        object5 = null;
        object = ImageIO.read((File)object4);
        System.err.println("read: " + object);
        TIFFImageReader.showIt((BufferedImage)object, ((File)object4).getName());
    }

    static final class TIFFEntry
    extends AbstractEntry {
        private final short type;

        private static short guessType(Object object) {
            Object object2 = Validate.notNull((Object)object);
            boolean bl = object2.getClass().isArray();
            if (bl) {
                object2 = Array.get(object2, 0);
            }
            if (object2 instanceof Byte) {
                return 1;
            }
            if (object2 instanceof Short) {
                if (!bl && (Short)object2 < 127) {
                    return 1;
                }
                return 3;
            }
            if (object2 instanceof Integer) {
                if (!bl && (Integer)object2 < Short.MAX_VALUE) {
                    return 3;
                }
                return 4;
            }
            if (object2 instanceof Long && !bl && (Long)object2 < Integer.MAX_VALUE) {
                return 4;
            }
            if (object2 instanceof Rational) {
                return 5;
            }
            if (object2 instanceof String) {
                return 2;
            }
            throw new UnsupportedOperationException(String.format("Method guessType not implemented for value of type %s", object2.getClass()));
        }

        TIFFEntry(int n, Object object) {
            this(n, TIFFEntry.guessType(object), object);
        }

        TIFFEntry(int n, short s, Object object) {
            super((Object)n, object);
            this.type = s;
        }

        public String getTypeName() {
            return TIFF.TYPE_NAMES[this.type];
        }
    }
}

