/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.EmptyNamespaceContext;
import org.codehaus.stax2.ri.evt.BaseEventImpl;
import org.codehaus.stax2.ri.evt.MergedNsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartElementEventImpl
extends BaseEventImpl
implements StartElement {
    protected final QName _name;
    protected final ArrayList<Attribute> _attrs;
    protected final ArrayList<Namespace> _nsDecls;
    protected NamespaceContext _parentNsCtxt;
    NamespaceContext _actualNsCtxt = null;

    protected StartElementEventImpl(Location location, QName qName, ArrayList<Attribute> arrayList, ArrayList<Namespace> arrayList2, NamespaceContext namespaceContext) {
        super(location);
        this._name = qName;
        this._attrs = arrayList;
        this._nsDecls = arrayList2;
        this._parentNsCtxt = namespaceContext == null ? EmptyNamespaceContext.getInstance() : namespaceContext;
    }

    public static StartElementEventImpl construct(Location location, QName qName, Iterator<?> iterator, Iterator<?> iterator2, NamespaceContext namespaceContext) {
        ArrayList<Namespace> arrayList;
        ArrayList<Attribute> arrayList2;
        if (iterator == null || !iterator.hasNext()) {
            arrayList2 = null;
        } else {
            arrayList2 = new ArrayList<Attribute>();
            do {
                arrayList2.add((Attribute)iterator.next());
            } while (iterator.hasNext());
        }
        if (iterator2 == null || !iterator2.hasNext()) {
            arrayList = null;
        } else {
            arrayList = new ArrayList<Namespace>();
            do {
                arrayList.add((Namespace)iterator2.next());
            } while (iterator2.hasNext());
        }
        return new StartElementEventImpl(location, qName, arrayList2, arrayList, namespaceContext);
    }

    @Override
    public StartElement asStartElement() {
        return this;
    }

    @Override
    public int getEventType() {
        return 1;
    }

    @Override
    public boolean isStartElement() {
        return true;
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            int n;
            int n2;
            writer.write(60);
            String string = this._name.getPrefix();
            if (string != null && string.length() > 0) {
                writer.write(string);
                writer.write(58);
            }
            writer.write(this._name.getLocalPart());
            if (this._nsDecls != null) {
                n2 = this._nsDecls.size();
                for (n = 0; n < n2; ++n) {
                    writer.write(32);
                    this._nsDecls.get(n).writeAsEncodedUnicode(writer);
                }
            }
            if (this._attrs != null) {
                n2 = this._attrs.size();
                for (n = 0; n < n2; ++n) {
                    Attribute attribute = this._attrs.get(n);
                    if (!attribute.isSpecified()) continue;
                    writer.write(32);
                    attribute.writeAsEncodedUnicode(writer);
                }
            }
            writer.write(62);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter2 xMLStreamWriter2) throws XMLStreamException {
        Object object;
        Attribute attribute;
        int n;
        int n2;
        QName qName = this._name;
        xMLStreamWriter2.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
        if (this._nsDecls != null) {
            n2 = this._nsDecls.size();
            for (n = 0; n < n2; ++n) {
                attribute = this._nsDecls.get(n);
                object = attribute.getPrefix();
                String string = attribute.getNamespaceURI();
                if (object == null || ((String)object).length() == 0) {
                    xMLStreamWriter2.writeDefaultNamespace(string);
                    continue;
                }
                xMLStreamWriter2.writeNamespace((String)object, string);
            }
        }
        if (this._attrs != null) {
            n2 = this._attrs.size();
            for (n = 0; n < n2; ++n) {
                attribute = this._attrs.get(n);
                if (!attribute.isSpecified()) continue;
                object = attribute.getName();
                xMLStreamWriter2.writeAttribute(((QName)object).getPrefix(), ((QName)object).getNamespaceURI(), ((QName)object).getLocalPart(), attribute.getValue());
            }
        }
    }

    @Override
    public final QName getName() {
        return this._name;
    }

    @Override
    public Iterator<Namespace> getNamespaces() {
        if (this._nsDecls == null) {
            return EmptyIterator.getInstance();
        }
        return this._nsDecls.iterator();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (this._actualNsCtxt == null) {
            this._actualNsCtxt = this._nsDecls == null ? this._parentNsCtxt : MergedNsContext.construct(this._parentNsCtxt, this._nsDecls);
        }
        return this._actualNsCtxt;
    }

    @Override
    public String getNamespaceURI(String string) {
        if (this._nsDecls != null) {
            if (string == null) {
                string = "";
            }
            int n = this._nsDecls.size();
            for (int i = 0; i < n; ++i) {
                Namespace namespace = this._nsDecls.get(i);
                String string2 = namespace.getPrefix();
                if (string2 == null) {
                    string2 = "";
                }
                if (!string.equals(string2)) continue;
                return namespace.getNamespaceURI();
            }
        }
        return null;
    }

    @Override
    public Attribute getAttributeByName(QName qName) {
        if (this._attrs == null) {
            return null;
        }
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        int n = this._attrs.size();
        boolean bl = string2 == null || string2.length() == 0;
        for (int i = 0; i < n; ++i) {
            Attribute attribute = this._attrs.get(i);
            QName qName2 = attribute.getName();
            if (!qName2.getLocalPart().equals(string)) continue;
            String string3 = qName2.getNamespaceURI();
            if (!(bl ? string3 == null || string3.length() == 0 : string2.equals(string3))) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public Iterator<Attribute> getAttributes() {
        if (this._attrs == null) {
            return EmptyIterator.getInstance();
        }
        return this._attrs.iterator();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof StartElement)) {
            return false;
        }
        StartElement startElement = (StartElement)object;
        if (this._name.equals(startElement.getName()) && StartElementEventImpl.iteratedEquals(this.getNamespaces(), startElement.getNamespaces())) {
            return StartElementEventImpl.iteratedEquals(this.getAttributes(), startElement.getAttributes());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = this._name.hashCode();
        n = StartElementEventImpl.addHash(this.getNamespaces(), n);
        n = StartElementEventImpl.addHash(this.getAttributes(), n);
        return n;
    }
}

