/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.acearth.util;

import com.ctreber.acearth.util.Coordinate;
import com.ctreber.acearth.util.Toolkit;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SunPositionCalculator {
    private static final long EPOCH_START = 631065600000L;
    private static final double RADS_PER_DAY = 0.017202791632524146;
    private static final double EPSILON_G = Toolkit.degsToRads(279.403303);
    private static final double OMEGA_BAR_G = Toolkit.degsToRads(282.768422);
    private static final double ECCENTRICITY = 0.016713;
    private static final double MOON_MEAN_LONGITUDE = Toolkit.degsToRads(318.351648);
    private static final double MOON_MEAN_LONGITUDE_PERIGEE = Toolkit.degsToRads(36.34041);
    private static final double MOON_MEAN_LONGITUDE_NODE = Toolkit.degsToRads(318.510107);
    private static final double MOON_INCLINATION = Toolkit.degsToRads(5.145396);
    private static final double SIDERAL_MONTH = 27.3217;

    private static double getMeanSunLongitude(double d) {
        double d2;
        double d3 = 0.017202791632524146 * d;
        if ((d3 = Toolkit.fmod(d3, 0.0, Math.PI * 2)) < 0.0) {
            d3 += Math.PI * 2;
        }
        if ((d2 = d3 + EPSILON_G - OMEGA_BAR_G) < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    private static double getSunEclipticLongitude(long l) {
        double d = SunPositionCalculator.daysSinceEpoch(l);
        double d2 = SunPositionCalculator.getMeanSunLongitude(d);
        double d3 = SunPositionCalculator.doKepler(d2);
        double d4 = 2.0 * Math.atan(Math.sqrt(1.033994144130859) * Math.tan(d3 / 2.0));
        return d4 + OMEGA_BAR_G;
    }

    static double daysSinceEpoch(long l) {
        return (double)(l - 631065600000L) / 24.0 / 3600.0 / 1000.0;
    }

    private static double doKepler(double d) {
        double d2;
        double d3 = d;
        while (!(Math.abs(d2 = d3 - 0.016713 * Math.sin(d3) - d) <= 1.0E-10)) {
            d3 -= d2 / (1.0 - 0.016713 * Math.cos(d3));
        }
        return d3;
    }

    private static double getJulianDate(int n, int n2, int n3) {
        if (n2 == 1 || n2 == 2) {
            --n;
            n2 += 12;
        }
        int n4 = n / 100;
        int n5 = 2 - n4 + n4 / 4;
        int n6 = (int)(365.25 * (double)n);
        int n7 = (int)(30.6001 * (double)(n2 + 1));
        return (double)(n5 + n6 + n7 + n3) + 1720994.5;
    }

    private static double getGST(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(new Date(l));
        double d = SunPositionCalculator.getJulianDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        double d2 = (d - 2451545.0) / 36525.0;
        double d3 = ((d2 + 2.5862E-5) * d2 + 2400.051336) * d2 + 6.697374558;
        d3 = Toolkit.fmod(d3, 0.0, 24.0);
        if (d3 < 0.0) {
            d3 += 24.0;
        }
        double d4 = (double)calendar.get(11) + ((double)calendar.get(12) + (double)calendar.get(13) / 60.0) / 60.0;
        d3 += d4 * 1.002737909;
        if ((d3 = Toolkit.fmod(d3, 0.0, 24.0)) < 0.0) {
            d3 += 24.0;
        }
        return d3;
    }

    public static Coordinate getSunPositionOnEarth(long l) {
        Coordinate coordinate = new Coordinate(0.0, SunPositionCalculator.getSunEclipticLongitude(l));
        Coordinate coordinate2 = coordinate.eclipticToEquatorial();
        double d = Toolkit.limitRads(coordinate2.getRA() - 0.2617993877991494 * SunPositionCalculator.getGST(l));
        return new Coordinate(Toolkit.radsToDegs(coordinate2.getDE()), Toolkit.radsToDegs(d));
    }

    public static Coordinate getMoonPositionOnEarth(long l) {
        double d = SunPositionCalculator.daysSinceEpoch(l);
        double d2 = SunPositionCalculator.getSunEclipticLongitude(l);
        double d3 = SunPositionCalculator.getMeanSunLongitude(d);
        double d4 = Toolkit.limitRads(Toolkit.fmod(d / 27.3217, 0.0, 1.0) * (Math.PI * 2) + MOON_MEAN_LONGITUDE);
        double d5 = Toolkit.limitRads(d4 - Toolkit.degsToRads(0.1114041 * d) - MOON_MEAN_LONGITUDE_PERIGEE);
        double d6 = Toolkit.limitRads(MOON_MEAN_LONGITUDE_NODE - Toolkit.degsToRads(0.0529539 * d));
        double d7 = Toolkit.degsToRads(1.2739) * Math.sin(2.0 * (d4 - d2) - d5);
        double d8 = Toolkit.degsToRads(0.1858) * Math.sin(d3);
        double d9 = Toolkit.degsToRads(6.2886) * Math.sin(d5 += d7 - d8 - Toolkit.degsToRads(0.37) * Math.sin(d3));
        d4 += d7 + d9 - d8 + Toolkit.degsToRads(0.214) * Math.sin(2.0 * d5);
        d4 += Toolkit.degsToRads(0.6583) * Math.sin(2.0 * (d4 - d2));
        d2 = Toolkit.limitRads(Math.abs(Math.cos(d4 -= (d6 -= Toolkit.degsToRads(0.16) * Math.sin(d3)))) < 1.0E-12 ? d6 + Math.sin(d4) * Math.cos(MOON_INCLINATION) * Math.PI / 2.0 : d6 + Math.atan2(Math.sin(d4) * Math.cos(MOON_INCLINATION), Math.cos(d4)));
        double d10 = Math.asin(Math.sin(d4) * Math.sin(MOON_INCLINATION));
        Coordinate coordinate = new Coordinate(d10, d2).eclipticToEquatorial();
        double d11 = Toolkit.limitRads(coordinate.getRA() - 0.2617993877991494 * SunPositionCalculator.getGST(l));
        return new Coordinate(Toolkit.radsToDegs(coordinate.getDE()), Toolkit.radsToDegs(d11));
    }
}

