/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue.client;

import com.hazelcast.collection.impl.queue.client.QueueRequest;
import com.hazelcast.collection.impl.queue.operations.OfferOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class OfferRequest
extends QueueRequest {
    private Data data;

    public OfferRequest() {
    }

    public OfferRequest(String name, Data data) {
        super(name);
        this.data = data;
    }

    public OfferRequest(String name, long timeoutMillis, Data data) {
        super(name, timeoutMillis);
        this.data = data;
    }

    @Override
    protected Operation prepareOperation() {
        return new OfferOperation(this.name, this.timeoutMillis, this.data);
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.data);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.data = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "add");
    }

    @Override
    public String getMethodName() {
        if (this.timeoutMillis == -1L) {
            return "put";
        }
        return "offer";
    }

    @Override
    public Object[] getParameters() {
        if (this.timeoutMillis > 0L) {
            return new Object[]{this.data, this.timeoutMillis, TimeUnit.MILLISECONDS};
        }
        return new Object[]{this.data};
    }
}

