/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.datastore;

import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.datareader.DataReader;
import net.sf.uadetector.datastore.DataStore;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.util.UrlUtil;

public abstract class AbstractDataStore
implements DataStore {
    private final Charset charset;
    private final Data data;
    private final URL dataUrl;
    private final DataReader reader;
    private final URL versionUrl;

    private static Data checkData(Data data) {
        if (Data.EMPTY.equals(data)) {
            throw new IllegalStateException("Argument 'data' must not be empty.");
        }
        return data;
    }

    protected static final Data readData(@Nonnull DataReader reader, @Nonnull URL url, @Nonnull Charset charset) {
        Check.notNull((Object)reader, (String)"reader");
        Check.notNull((Object)url, (String)"url");
        Check.notNull((Object)charset, (String)"charset");
        return reader.read(url, charset);
    }

    protected AbstractDataStore(@Nonnull Data data, @Nonnull DataReader reader, @Nonnull URL dataUrl, @Nonnull URL versionUrl, @Nonnull Charset charset) {
        Check.notNull((Object)data, (String)"data");
        Check.notNull((Object)reader, (String)"reader");
        Check.notNull((Object)charset, (String)"charset");
        Check.notNull((Object)dataUrl, (String)"dataUrl");
        Check.notNull((Object)versionUrl, (String)"versionUrl");
        this.data = AbstractDataStore.checkData(data);
        this.reader = reader;
        this.dataUrl = dataUrl;
        this.versionUrl = versionUrl;
        this.charset = charset;
    }

    protected AbstractDataStore(DataReader reader, String dataUrl, String versionUrl, Charset charset) {
        this(reader, UrlUtil.build(dataUrl), UrlUtil.build(versionUrl), charset);
    }

    protected AbstractDataStore(DataReader reader, URL dataUrl, URL versionUrl, Charset charset) {
        this(AbstractDataStore.checkData(AbstractDataStore.readData(reader, dataUrl, charset)), reader, dataUrl, versionUrl, charset);
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Data getData() {
        return this.data;
    }

    @Override
    public DataReader getDataReader() {
        return this.reader;
    }

    @Override
    public URL getDataUrl() {
        return this.dataUrl;
    }

    @Override
    public URL getVersionUrl() {
        return this.versionUrl;
    }
}

