/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import de.l3s.boilerpipe.BoilerpipeExtractor;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.extractors.DefaultExtractor;
import de.l3s.boilerpipe.sax.BoilerpipeHTMLContentHandler;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BoilerpipeContentHandler
extends BoilerpipeHTMLContentHandler {
    private static final char[] NL = new char[]{'\n'};
    private ContentHandler delegate;
    private BoilerpipeExtractor extractor;
    private boolean includeMarkup;
    private boolean inHeader;
    private boolean inFooter;
    private int headerCharOffset;
    private List<RecordedElement> elements;
    private TextDocument td = null;

    public BoilerpipeContentHandler(ContentHandler delegate) {
        this(delegate, DefaultExtractor.INSTANCE);
    }

    public BoilerpipeContentHandler(Writer writer) {
        this(new WriteOutContentHandler(writer));
    }

    public BoilerpipeContentHandler(ContentHandler delegate, BoilerpipeExtractor extractor) {
        this.delegate = delegate;
        this.extractor = extractor;
    }

    public void setIncludeMarkup(boolean includeMarkup) {
        this.includeMarkup = includeMarkup;
    }

    public boolean isIncludeMarkup() {
        return this.includeMarkup;
    }

    public TextDocument getTextDocument() {
        return this.td;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.delegate.startDocument();
        this.inHeader = true;
        this.inFooter = false;
        this.headerCharOffset = 0;
        if (this.includeMarkup) {
            this.elements = new ArrayList<RecordedElement>();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.delegate.startPrefixMapping(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qName, atts);
        if (this.inHeader) {
            this.delegate.startElement(uri, localName, qName, atts);
        } else if (!this.inFooter) {
            if (this.includeMarkup) {
                this.elements.add(new RecordedElement(uri, localName, qName, atts));
            } else {
                this.delegate.startElement(uri, localName, qName, atts);
            }
        }
    }

    @Override
    public void characters(char[] chars, int offset, int length) throws SAXException {
        super.characters(chars, offset, length);
        if (this.inHeader) {
            this.delegate.characters(chars, offset, length);
            ++this.headerCharOffset;
        } else if (!this.inFooter && this.includeMarkup) {
            RecordedElement element = this.elements.get(this.elements.size() - 1);
            char[] characters = new char[length];
            System.arraycopy(chars, offset, characters, 0, length);
            element.getCharacters().add(characters);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (this.inHeader) {
            this.delegate.endElement(uri, localName, qName);
            this.inHeader = !localName.equals("head");
        } else if (!this.inFooter) {
            if (localName.equals("body")) {
                this.inFooter = true;
            } else if (this.includeMarkup) {
                this.elements.add(new RecordedElement(uri, localName, qName));
                this.elements.add(new RecordedElement());
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.td = this.toTextDocument();
        try {
            this.extractor.process(this.td);
        }
        catch (BoilerpipeProcessingException e) {
            throw new SAXException(e);
        }
        AttributesImpl emptyAttrs = new AttributesImpl();
        if (this.includeMarkup) {
            BitSet validCharacterRuns = new BitSet();
            for (TextBlock block : this.td.getTextBlocks()) {
                BitSet bs;
                if (!block.isContent() || (bs = block.getContainedTextElements()) == null) continue;
                validCharacterRuns.or(bs);
            }
            int curCharsIndex = this.headerCharOffset;
            block8: for (RecordedElement element : this.elements) {
                switch (element.getElementType()) {
                    case START: {
                        this.delegate.startElement(element.getUri(), element.getLocalName(), element.getQName(), element.getAttrs());
                    }
                    case CONTINUE: {
                        for (char[] chars : element.getCharacters()) {
                            if (!validCharacterRuns.get(++curCharsIndex)) continue;
                            this.delegate.characters(chars, 0, chars.length);
                        }
                        continue block8;
                    }
                    case END: {
                        this.delegate.endElement(element.getUri(), element.getLocalName(), element.getQName());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled element type: " + (Object)((Object)element.getElementType()));
                    }
                }
            }
        } else {
            for (TextBlock block : this.td.getTextBlocks()) {
                if (!block.isContent()) continue;
                this.delegate.startElement("http://www.w3.org/1999/xhtml", "p", "p", emptyAttrs);
                char[] chars = block.getText().toCharArray();
                this.delegate.characters(chars, 0, chars.length);
                this.delegate.endElement("http://www.w3.org/1999/xhtml", "p", "p");
                this.delegate.ignorableWhitespace(NL, 0, NL.length);
            }
        }
        this.delegate.endElement("http://www.w3.org/1999/xhtml", "body", "body");
        this.delegate.endElement("http://www.w3.org/1999/xhtml", "html", "html");
        this.delegate.endPrefixMapping("");
        this.delegate.endDocument();
    }

    private static class RecordedElement {
        private String uri;
        private String localName;
        private String qName;
        private Attributes attrs;
        private List<char[]> characters;
        private ElementType elementType;

        public RecordedElement(String uri, String localName, String qName, Attributes attrs) {
            this(uri, localName, qName, attrs, ElementType.START);
        }

        public RecordedElement(String uri, String localName, String qName) {
            this(uri, localName, qName, null, ElementType.END);
        }

        public RecordedElement() {
            this(null, null, null, null, ElementType.CONTINUE);
        }

        protected RecordedElement(String uri, String localName, String qName, Attributes attrs, ElementType elementType) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.attrs = attrs;
            this.elementType = elementType;
            this.characters = new ArrayList<char[]>();
        }

        public String toString() {
            return String.format("<%s> of type %s", new Object[]{this.localName, this.elementType});
        }

        public String getUri() {
            return this.uri;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getQName() {
            return this.qName;
        }

        public Attributes getAttrs() {
            return this.attrs;
        }

        public List<char[]> getCharacters() {
            return this.characters;
        }

        public ElementType getElementType() {
            return this.elementType;
        }

        public static enum ElementType {
            START,
            END,
            CONTINUE;

        }
    }
}

