/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.magicwerk.brownies.collections.BigList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.helper.NaturalComparator;
import org.magicwerk.brownies.collections.primitive.ByteBigList;

public class ByteObjBigList
extends IList<Byte> {
    ByteBigList list;

    static Byte[] toWrapper(byte[] elems) {
        Byte[] e = new Byte[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static byte[] toPrimitive(Byte[] elems) {
        byte[] e = new byte[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static byte[] toPrimitive(BigList<? extends Byte> list2) {
        byte[] e = new byte[list2.size()];
        for (int i = 0; i < e.length; ++i) {
            e[i] = (Byte)list2.get(i);
        }
        return e;
    }

    static byte[] toPrimitive(Collection<? extends Byte> list) {
        byte[] e = new byte[list.size()];
        Iterator<? extends Byte> iter = list.iterator();
        for (int i = 0; i < e.length; ++i) {
            e[i] = iter.next();
        }
        return e;
    }

    public static ByteObjBigList create() {
        return new ByteObjBigList();
    }

    public static ByteObjBigList create(Byte ... elems) {
        ByteObjBigList list = new ByteObjBigList();
        list.init(elems);
        return list;
    }

    public static ByteObjBigList create(Collection<? extends Byte> elems) {
        return new ByteObjBigList(elems);
    }

    public ByteObjBigList() {
        this.init();
    }

    public void init() {
        this.list = new ByteBigList();
    }

    public ByteObjBigList(int capacity) {
        this.list = new ByteBigList(capacity);
    }

    public void init(Byte ... elems) {
        this.list = ByteBigList.create(ByteObjBigList.toPrimitive(elems));
    }

    public ByteObjBigList(Collection<? extends Byte> elems) {
        this.init(elems);
    }

    public void init(Collection<? extends Byte> elems) {
        this.list = ByteBigList.create(ByteObjBigList.toPrimitive(elems));
    }

    @Override
    protected void doClone(IList<Byte> that) {
        this.list = (ByteBigList)((ByteObjBigList)that).list.clone();
    }

    @Override
    protected void doAssign(IList<Byte> that) {
        ByteObjBigList list = (ByteObjBigList)that;
        this.list = list.list;
    }

    public ByteObjBigList copy() {
        return (ByteObjBigList)this.clone();
    }

    @Override
    public Byte getDefaultElem() {
        return this.list.getDefaultElem();
    }

    @Override
    public IList<Byte> doCreate(int capacity) {
        return new ByteObjBigList();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int capacity() {
        return this.list.capacity();
    }

    @Override
    public Byte get(int index) {
        return this.list.get(index);
    }

    @Override
    protected Byte doGet(int index) {
        return this.list.doGet(index);
    }

    @Override
    protected void doGetAll(Object[] elems, int index, int len) {
        this.list.doGetAll(ByteObjBigList.toPrimitive((Byte[])elems), index, len);
    }

    @Override
    protected boolean doAdd(int index, Byte elem) {
        return this.list.doAdd(index, elem);
    }

    @Override
    protected Byte doSet(int index, Byte elem) {
        return this.list.doSet(index, elem);
    }

    @Override
    protected Byte doRemove(int index) {
        return this.list.doRemove(index);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        this.list.doRemoveAll(index, len);
    }

    @Override
    protected Byte doReSet(int index, Byte elem) {
        return this.list.doReSet(index, elem);
    }

    @Override
    public void move(int srcIndex, int dstIndex, int len) {
        this.list.move(srcIndex, dstIndex, len);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        this.list.doEnsureCapacity(minCapacity);
    }

    @Override
    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.list.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null || elem.getClass() != Byte.class) {
            return -1;
        }
        return this.list.indexOf((Byte)elem);
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null || elem.getClass() != Byte.class) {
            return -1;
        }
        return this.list.lastIndexOf((Byte)elem);
    }

    @Override
    public boolean remove(Object elem) {
        if (elem == null || elem.getClass() != Byte.class) {
            return false;
        }
        int index = this.list.indexOf((Byte)elem);
        if (index == -1) {
            return false;
        }
        this.list.remove(index);
        return true;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem == null || elem.getClass() != Byte.class) {
            return false;
        }
        return this.list.contains((Byte)elem);
    }

    @Override
    public boolean containsAny(Collection<?> coll) {
        return this.list.containsAny(coll);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean removeAll(IList<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public boolean retainAll(IList<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(0, this.size());
    }

    @Override
    public Object[] toArray(int index, int len) {
        Object[] elems = new Object[len];
        for (int i = 0; i < len; ++i) {
            elems[i] = this.list.get(i);
        }
        return elems;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.list.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        for (int i = 0; i < size; ++i) {
            array[i] = this.list.get(i);
        }
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    @Override
    public boolean addAll(Collection<? extends Byte> coll) {
        return this.list.addAll(coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Byte> coll) {
        return this.list.addAll(index, coll);
    }

    public boolean addArray(Byte ... elems) {
        byte[] e = ByteObjBigList.toPrimitive(elems);
        return this.list.addArray(e);
    }

    public boolean addArray(int index, Byte ... elems) {
        byte[] e = ByteObjBigList.toPrimitive(elems);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean addAll(IList<? extends Byte> list2) {
        byte[] e = ByteObjBigList.toPrimitive(list2);
        return this.list.addArray(e);
    }

    @Override
    public boolean addAll(int index, IList<? extends Byte> list2) {
        byte[] e = ByteObjBigList.toPrimitive(list2);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean removeFirstOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Byte.class) {
            return false;
        }
        return this.list.removeFirstOccurrence((Byte)elem);
    }

    @Override
    public boolean removeLastOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Byte.class) {
            return false;
        }
        return this.list.removeLastOccurrence((Byte)elem);
    }

    @Override
    public BigList<Byte> getAll(int index, int len) {
        byte[] elems = this.list.getArray(index, len);
        return BigList.create(ByteObjBigList.toWrapper(elems));
    }

    public Byte[] getArray(int index, int len) {
        byte[] elems = this.list.getArray(index, len);
        return ByteObjBigList.toWrapper(elems);
    }

    @Override
    public void setAll(int index, IList<? extends Byte> list2) {
        byte[] e = ByteObjBigList.toPrimitive(list2);
        this.list.setArray(index, e);
    }

    @Override
    public void setAll(int index, Collection<? extends Byte> coll) {
        byte[] e = ByteObjBigList.toPrimitive(coll);
        this.list.setArray(index, e);
    }

    public void setArray(int index, Byte ... elems) {
        byte[] e = ByteObjBigList.toPrimitive(elems);
        this.list.setArray(index, e);
    }

    @Override
    public void sort(int index, int len, Comparator comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        this.list.sort(index, len);
    }

    @Override
    public <K> int binarySearch(int index, int len, K key, Comparator<? super K> comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        return this.list.binarySearch(index, len, (Byte)key);
    }

    public ByteObjBigList unmodifiableList() {
        return new ImmutableByteObjBigList(this);
    }

    protected static class ImmutableByteObjBigList
    extends ByteObjBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableByteObjBigList(ByteObjBigList that) {
            super(that);
        }

        @Override
        protected boolean doAdd(int index, Byte elem) {
            this.error();
            return false;
        }

        @Override
        protected Byte doSet(int index, Byte elem) {
            this.error();
            return null;
        }

        @Override
        protected Byte doReSet(int index, Byte elem) {
            this.error();
            return null;
        }

        @Override
        protected Byte doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }
}

