/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.spring;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class MultiTenantSpringLiquibase
implements InitializingBean,
ResourceLoaderAware {
    private Logger log = LogFactory.getLogger(MultiTenantSpringLiquibase.class.getName());
    private String jndiBase;
    private final List<DataSource> dataSources = new ArrayList<DataSource>();
    private ResourceLoader resourceLoader;
    private String changeLog;
    private String contexts;
    private Map<String, String> parameters;
    private String defaultSchema;
    private boolean dropFirst = false;
    private boolean shouldRun = true;
    private File rollbackFile;

    public void afterPropertiesSet() throws Exception {
        this.resolveDataSources();
        this.runOnAllDataSources();
    }

    private void resolveDataSources() throws NamingException {
        InitialContext context = new InitialContext();
        int lastIndexOf = this.jndiBase.lastIndexOf("/");
        String jndiRoot = this.jndiBase.substring(0, lastIndexOf);
        String jndiParent = this.jndiBase.substring(lastIndexOf + 1);
        Context base = (Context)context.lookup(jndiRoot);
        NamingEnumeration<NameClassPair> list = base.list(jndiParent);
        while (list.hasMoreElements()) {
            NameClassPair entry = (NameClassPair)list.nextElement();
            String name = entry.getName();
            String jndiUrl = entry.isRelative() ? this.jndiBase + "/" + name : name;
            Object lookup = context.lookup(jndiUrl);
            if (lookup instanceof DataSource) {
                this.dataSources.add((DataSource)lookup);
                this.log.debug("Added a data source at " + jndiUrl);
                continue;
            }
            this.log.info("Skipping a resource " + jndiUrl + " not compatible with DataSource.");
        }
    }

    private void runOnAllDataSources() throws LiquibaseException {
        for (DataSource dataSource : this.dataSources) {
            this.log.info("Initializing Liquibase for data source " + dataSource);
            SpringLiquibase liquibase = new SpringLiquibase();
            liquibase.setChangeLog(this.changeLog);
            liquibase.setChangeLogParameters(this.parameters);
            liquibase.setContexts(this.contexts);
            liquibase.setDefaultSchema(this.defaultSchema);
            liquibase.setDropFirst(this.dropFirst);
            liquibase.setShouldRun(this.shouldRun);
            liquibase.setRollbackFile(this.rollbackFile);
            liquibase.setResourceLoader(this.resourceLoader);
            liquibase.setDataSource(dataSource);
            liquibase.afterPropertiesSet();
            this.log.info("Liquibase ran for data source " + dataSource);
        }
    }

    public String getJndiBase() {
        return this.jndiBase;
    }

    public void setJndiBase(String jndiBase) {
        this.jndiBase = jndiBase;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String changeLog) {
        this.changeLog = changeLog;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    public boolean isShouldRun() {
        return this.shouldRun;
    }

    public void setShouldRun(boolean shouldRun) {
        this.shouldRun = shouldRun;
    }

    public File getRollbackFile() {
        return this.rollbackFile;
    }

    public void setRollbackFile(File rollbackFile) {
        this.rollbackFile = rollbackFile;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

