/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.jvm;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;

public class HsqlConnection
extends JdbcConnection {
    public HsqlConnection(Connection connection) {
        super(connection);
    }

    @Override
    public void commit() throws DatabaseException {
        super.commit();
        Statement st = null;
        try {
            st = this.createStatement();
            st.execute("CHECKPOINT");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void rollback() throws DatabaseException {
        super.rollback();
        Statement st = null;
        try {
            st = this.createStatement();
            st.execute("CHECKPOINT");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

