/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;

public class UpdateVisitor
implements ChangeSetVisitor {
    private Database database;
    private Logger log = LogFactory.getLogger();
    private ChangeExecListener execListener;

    public UpdateVisitor(Database database) {
        this.database = database;
    }

    public UpdateVisitor(Database database, ChangeExecListener execListener) {
        this(database);
        this.execListener = execListener;
    }

    @Override
    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    @Override
    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) throws LiquibaseException {
        ChangeSet.RunStatus runStatus = this.database.getRunStatus(changeSet);
        this.log.debug("Running Changeset:" + changeSet);
        this.fireWillRun(changeSet, databaseChangeLog, database, runStatus);
        ChangeSet.ExecType execType = changeSet.execute(databaseChangeLog, this.database);
        if (!runStatus.equals((Object)ChangeSet.RunStatus.NOT_RAN)) {
            execType = ChangeSet.ExecType.RERAN;
        }
        this.fireRan(changeSet, databaseChangeLog, database, execType);
        this.database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        this.database.markChangeSetExecStatus(changeSet, execType);
        this.database.commit();
    }

    private void fireWillRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database2, ChangeSet.RunStatus runStatus) {
        if (this.execListener != null) {
            this.execListener.willRun(changeSet, databaseChangeLog, this.database, runStatus);
        }
    }

    private void fireRan(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database2, ChangeSet.ExecType execType) {
        if (this.execListener != null) {
            this.execListener.ran(changeSet, databaseChangeLog, this.database, execType);
        }
    }
}

