/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class X509Util {
    private static Log log = LogFactory.getLog(X509Util.class);

    private X509Util() {
    }

    public static boolean isContent(Node encBodyData) {
        String typeStr;
        if (encBodyData != null && (typeStr = ((Element)encBodyData).getAttributeNS(null, "Type")) != null) {
            return typeStr.equals("http://www.w3.org/2001/04/xmlenc#Content");
        }
        return true;
    }

    public static String getEncAlgo(Node encBodyData) throws WSSecurityException {
        Element tmpE = WSSecurityUtil.getDirectChildElement(encBodyData, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        String symEncAlgo = null;
        if (tmpE != null && ((symEncAlgo = tmpE.getAttributeNS(null, "Algorithm")) == null || "".equals(symEncAlgo))) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sym Enc Algo: " + symEncAlgo));
        }
        return symEncAlgo;
    }

    protected static SecretKey getSharedKey(Element keyInfoElem, String algorithm, CallbackHandler cb) throws WSSecurityException {
        String keyName = null;
        Element keyNmElem = WSSecurityUtil.getDirectChildElement(keyInfoElem, "KeyName", "http://www.w3.org/2000/09/xmldsig#");
        if (keyNmElem != null) {
            StringBuilder builder = new StringBuilder();
            for (Node node = keyNmElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (3 != node.getNodeType()) continue;
                builder.append(((Text)node).getData());
            }
            keyName = builder.toString();
        }
        if (keyName == null || keyName.length() <= 0) {
            log.debug((Object)"No Key Name available");
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(keyName, 9);
        try {
            cb.handle(new Callback[]{pwCb});
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName}, e);
        }
        byte[] decryptedData = pwCb.getKey();
        if (decryptedData == null) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName});
        }
        return WSSecurityUtil.prepareSecretKey(algorithm, decryptedData);
    }
}

