/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.build.utils.Tools;
import com.openexchange.osgi.data.AbstractModule;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class DependenciesSorter {
    public List<AbstractModule> sortDependencies(List<AbstractModule> classPathModules, List<AbstractModule> appModules) throws Exception {
        LinkedList<AbstractModule> sorted = new LinkedList<AbstractModule>(classPathModules);
        LinkedList<AbstractModule> first = new LinkedList<AbstractModule>();
        for (final AbstractModule module : appModules) {
            String[] bundles;
            File jarsDir;
            if (!module.getDependencies(false).isEmpty() || !(jarsDir = new File(module.getFile(), "jars")).exists() || !jarsDir.isDirectory() || null == (bundles = jarsDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") && !name.startsWith(module.getName());
                }
            })) || 0 == bundles.length) continue;
            first.add(module);
        }
        sorted.addAll(first);
        LinkedList<AbstractModule> toSort = new LinkedList<AbstractModule>(appModules);
        toSort.removeAll(first);
        Stack<AbstractModule> moduleStack = new Stack<AbstractModule>();
        for (AbstractModule module : toSort) {
            this.visit(moduleStack, module, sorted);
        }
        return sorted;
    }

    private void visit(Stack<AbstractModule> moduleStack, AbstractModule module, List<AbstractModule> sorted) throws Exception {
        if (moduleStack.contains(module)) {
            throw new Exception("Cyclic dependency detected between modules: " + Tools.join(moduleStack, (String)",") + module.getName());
        }
        moduleStack.push(module);
        if (!sorted.contains(module)) {
            Iterator<AbstractModule> dependentIt = module.getDependencies(false).iterator();
            while (dependentIt.hasNext()) {
                this.visit(moduleStack, dependentIt.next(), sorted);
            }
            sorted.add(module);
        }
        moduleStack.pop();
    }
}

