/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

import java.math.BigInteger;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;

public class Column
extends AbstractDatabaseObject {
    private String name;

    public Relation getRelation() {
        return this.getAttribute("relation", Relation.class);
    }

    @Override
    public DatabaseObject[] getContainingObjects() {
        return new DatabaseObject[]{this.getRelation()};
    }

    public Column setRelation(Relation relation) {
        this.setAttribute("relation", relation);
        return this;
    }

    @Override
    public Schema getSchema() {
        Relation relation = this.getRelation();
        if (relation == null) {
            return null;
        }
        return relation.getSchema();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Column setName(String name) {
        this.name = name;
        this.setAttribute("name", name);
        return this;
    }

    public Boolean isNullable() {
        return this.getAttribute("nullable", Boolean.class);
    }

    public Column setNullable(Boolean nullable) {
        this.setAttribute("nullable", nullable);
        return this;
    }

    public DataType getType() {
        return this.getAttribute("type", DataType.class);
    }

    public Column setType(DataType type) {
        this.setAttribute("type", type);
        return this;
    }

    public Object getDefaultValue() {
        return this.getAttribute("defaultValue", Object.class);
    }

    public Column setDefaultValue(Object defaultValue) {
        this.setAttribute("defaultValue", defaultValue);
        return this;
    }

    public boolean isAutoIncrement() {
        return this.getAutoIncrementInformation() != null;
    }

    public AutoIncrementInformation getAutoIncrementInformation() {
        return this.getAttribute("autoIncrementInformation", AutoIncrementInformation.class);
    }

    public void setAutoIncrementInformation(AutoIncrementInformation autoIncrementInformation) {
        this.setAttribute("autoIncrementInformation", autoIncrementInformation);
    }

    public String toString() {
        String tableOrViewName = this.getRelation().getName();
        return tableOrViewName + "." + this.getName();
    }

    @Override
    public int compareTo(Object other) {
        Column o = (Column)other;
        try {
            int returnValue = 0;
            if (this.getRelation() != null && o.getRelation() == null) {
                return 1;
            }
            if (this.getRelation() == null && o.getRelation() != null) {
                return -1;
            }
            returnValue = this.getRelation().compareTo(o.getRelation());
            if (returnValue == 0) {
                returnValue = this.getName().compareTo(o.getName());
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        try {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            return this.getName().equalsIgnoreCase(column.getName()) && !(this.getRelation() == null ? column.getRelation() != null : !this.getRelation().equals(column.getRelation()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        try {
            int result = this.getRelation() != null ? this.getRelation().hashCode() : 0;
            result = 31 * result + this.getName().toUpperCase().hashCode();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isDataTypeDifferent(Column otherColumn) {
        if (!this.isCertainDataType() || !otherColumn.isCertainDataType()) {
            return false;
        }
        return !this.getType().equals(otherColumn.getType());
    }

    public boolean isNullabilityDifferent(Column otherColumn) {
        if (this.isNullable() == null && otherColumn.isNullable() == null) {
            return false;
        }
        if (this.isNullable() == null && otherColumn.isNullable() != null) {
            return true;
        }
        if (this.isNullable() != null && otherColumn.isNullable() == null) {
            return true;
        }
        return !this.isNullable().equals(otherColumn.isNullable());
    }

    public boolean isDifferent(Column otherColumn) {
        return this.isDataTypeDifferent(otherColumn) || this.isNullabilityDifferent(otherColumn);
    }

    public boolean isCertainDataType() {
        return this.getAttribute("certainDataType", Boolean.class);
    }

    public Column setCertainDataType(boolean certainDataType) {
        this.setAttribute("certainDataType", certainDataType);
        return this;
    }

    public String getRemarks() {
        return this.getAttribute("remarks", String.class);
    }

    public Column setRemarks(String remarks) {
        this.setAttribute("remarks", remarks);
        return this;
    }

    public static class AutoIncrementInformation {
        private BigInteger startWith;
        private BigInteger incrementBy;

        public AutoIncrementInformation() {
            this(1, 1);
        }

        public AutoIncrementInformation(Number startWith, Number incrementBy) {
            this.startWith = BigInteger.valueOf(startWith.longValue());
            this.incrementBy = BigInteger.valueOf(incrementBy.longValue());
        }

        public BigInteger getStartWith() {
            return this.startWith;
        }

        public BigInteger getIncrementBy() {
            return this.incrementBy;
        }

        public String toString() {
            return "AUTO INCREMENT START WITH " + this.startWith + " INCREMENT BY " + this.incrementBy;
        }
    }
}

