/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.PrimaryKeyConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import liquibase.statement.core.SetColumnRemarksStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.StringUtils;

@DatabaseChange(name="addColumn", description="Adds a new column to an existing table", priority=1, appliesTo={"table"})
public class AddColumnChange
extends AbstractChange
implements ChangeWithColumns<ColumnConfig> {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    @DatabaseChangeProperty(mustEqualExisting="relation.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="relation.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table", description="Name of the table to add the column to")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    @DatabaseChangeProperty(description="Column constraint and foreign key information. Setting the \"defaultValue\" attribute will specify a default value for the column. Setting the \"value\" attribute will set all rows existing to the specified value without modifying the column default.", requiredForDatabase={"all"})
    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(List<ColumnConfig> columns) {
        this.columns = columns;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public void removeColumn(ColumnConfig column) {
        this.columns.remove(column);
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        ArrayList<AbstractSqlStatement> sql = new ArrayList<AbstractSqlStatement>();
        if (this.getColumns().size() == 0) {
            return new SqlStatement[]{new AddColumnStatement(this.catalogName, this.schemaName, this.tableName, null, null, null, new ColumnConstraint[0])};
        }
        for (ColumnConfig column : this.getColumns()) {
            HashSet<ColumnConstraint> constraints = new HashSet<ColumnConstraint>();
            ConstraintsConfig constraintsConfig = column.getConstraints();
            if (constraintsConfig != null) {
                if (constraintsConfig.isNullable() != null && !constraintsConfig.isNullable().booleanValue()) {
                    constraints.add(new NotNullConstraint());
                }
                if (constraintsConfig.isUnique() != null && constraintsConfig.isUnique().booleanValue()) {
                    constraints.add(new UniqueConstraint());
                }
                if (constraintsConfig.isPrimaryKey() != null && constraintsConfig.isPrimaryKey().booleanValue()) {
                    constraints.add(new PrimaryKeyConstraint(constraintsConfig.getPrimaryKeyName()));
                }
                if (constraintsConfig.getReferences() != null || constraintsConfig.getReferencedColumnNames() != null && constraintsConfig.getReferencedTableName() != null) {
                    constraints.add(new ForeignKeyConstraint(constraintsConfig.getForeignKeyName(), constraintsConfig.getReferences(), constraintsConfig.getReferencedTableName(), constraintsConfig.getReferencedColumnNames()));
                }
            }
            if (column.isAutoIncrement() != null && column.isAutoIncrement().booleanValue()) {
                constraints.add(new AutoIncrementConstraint(column.getName(), column.getStartWith(), column.getIncrementBy()));
            }
            AddColumnStatement addColumnStatement = new AddColumnStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), column.getName(), column.getType(), column.getDefaultValueObject(), constraints.toArray(new ColumnConstraint[constraints.size()]));
            sql.add(addColumnStatement);
            if (database instanceof DB2Database) {
                sql.add(new ReorganizeTableStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName()));
            }
            if (column.getValueObject() == null) continue;
            UpdateStatement updateStatement = new UpdateStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
            updateStatement.addNewColumnValue(column.getName(), column.getValueObject());
            sql.add(updateStatement);
        }
        for (ColumnConfig column : this.getColumns()) {
            String columnRemarks = StringUtils.trimToNull(column.getRemarks());
            if (columnRemarks == null) continue;
            SetColumnRemarksStatement remarksStatement = new SetColumnRemarksStatement(this.catalogName, this.schemaName, this.tableName, column.getName(), columnRemarks);
            if (!SqlGeneratorFactory.getInstance().supports(remarksStatement, database)) continue;
            sql.add(remarksStatement);
        }
        return sql.toArray(new SqlStatement[sql.size()]);
    }

    @Override
    protected Change[] createInverses() {
        ArrayList<AbstractChange> inverses = new ArrayList<AbstractChange>();
        for (ColumnConfig aColumn : this.columns) {
            if (aColumn.hasDefaultValue()) {
                DropDefaultValueChange dropChange = new DropDefaultValueChange();
                dropChange.setTableName(this.getTableName());
                dropChange.setColumnName(aColumn.getName());
                dropChange.setSchemaName(this.getSchemaName());
                inverses.add(dropChange);
            }
            DropColumnChange inverse = new DropColumnChange();
            inverse.setSchemaName(this.getSchemaName());
            inverse.setColumnName(aColumn.getName());
            inverse.setTableName(this.getTableName());
            inverses.add(inverse);
        }
        return inverses.toArray(new Change[inverses.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        ArrayList<String> names = new ArrayList<String>(this.columns.size());
        for (ColumnConfig col : this.columns) {
            names.add(col.getName() + "(" + col.getType() + ")");
        }
        return "Columns " + StringUtils.join(names, ",") + " added to " + this.tableName;
    }
}

