/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.MessageHashKey;
import org.fedorahosted.tennera.jgettext.MessageProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Catalog
implements Iterable<Message> {
    private boolean template;
    private final LinkedHashMap<MessageHashKey, Message> messageMap = new LinkedHashMap();

    public Catalog(boolean template) {
        this.template = template;
    }

    public Catalog() {
        this(false);
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void addMessage(Message message) {
        this.messageMap.put(new MessageHashKey(message), message);
    }

    public Message locateHeader() {
        for (Message message : this.messageMap.values()) {
            if (!message.isHeader()) continue;
            return message;
        }
        return null;
    }

    public Message locateMessage(String msgctxt, String msgid) {
        return this.locateMessage(new MessageHashKey(msgctxt, msgid));
    }

    public Message locateMessage(MessageHashKey key) {
        return this.messageMap.get(key);
    }

    public boolean containsMessage(String msgctxt, String msgid) {
        return this.containsMessage(new MessageHashKey(msgctxt, msgid));
    }

    public boolean containsMessage(MessageHashKey key) {
        return this.messageMap.containsKey(key);
    }

    public boolean isEmpty() {
        return this.messageMap.isEmpty();
    }

    public int size() {
        return this.messageMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Catalog(");
        for (Map.Entry<MessageHashKey, Message> entry : this.messageMap.entrySet()) {
            sb.append(entry.getValue());
            sb.append('\n');
        }
        sb.append(",template=");
        sb.append(this.template);
        sb.append(")");
        return sb.toString();
    }

    public void processMessages(MessageProcessor processor) {
        for (Message message : this.messageMap.values()) {
            processor.processMessage(message);
        }
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messageMap.values().iterator();
    }
}

