/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.util.Collection;
import org.javasimon.AbstractSimon;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.utils.SimonUtils;

final class CounterImpl
extends AbstractSimon
implements Counter {
    private long counter;
    private long incrementSum;
    private long decrementSum;
    private long max = Long.MIN_VALUE;
    private long maxTimestamp;
    private long min = Long.MAX_VALUE;
    private long minTimestamp;

    CounterImpl(String name, Manager manager) {
        super(name, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counter set(long val) {
        CounterSample sample;
        if (!this.enabled) {
            return this;
        }
        long now = this.manager.milliTime();
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            this.setPrivate(val, now);
            this.updateIncrementalSimonsSet(val, now);
            sample = this.sampleIfCallbacksNotEmpty();
        }
        this.manager.callback().onCounterSet(this, val, sample);
        return this;
    }

    private void setPrivate(long val, long now) {
        this.updateUsages(now);
        this.counter = val;
        this.updateMax();
        this.updateMin();
    }

    private void updateIncrementalSimonsSet(long val, long now) {
        Collection<Simon> simons = this.incrementalSimons();
        if (simons != null) {
            for (Simon simon : simons) {
                ((CounterImpl)simon).setPrivate(val, now);
            }
        }
    }

    private void updateMin() {
        if (this.counter <= this.min) {
            this.min = this.counter;
            this.minTimestamp = this.getLastUsage();
        }
    }

    private void updateMax() {
        if (this.counter >= this.max) {
            this.max = this.counter;
            this.maxTimestamp = this.getLastUsage();
        }
    }

    @Override
    public Counter increase() {
        return this.increase(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counter increase(long inc) {
        CounterSample sample;
        if (!this.enabled) {
            return this;
        }
        long now = this.manager.milliTime();
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            this.increasePrivate(inc, now);
            this.updateIncrementalSimonsIncrease(inc, now);
            sample = this.sampleIfCallbacksNotEmpty();
        }
        this.manager.callback().onCounterIncrease(this, inc, sample);
        return this;
    }

    private void increasePrivate(long inc, long now) {
        this.updateUsages(now);
        this.incrementSum += inc;
        this.counter += inc;
        if (inc > 0L) {
            this.updateMax();
        } else {
            this.updateMin();
        }
    }

    private void updateIncrementalSimonsIncrease(long inc, long now) {
        Collection<Simon> simons = this.incrementalSimons();
        if (simons != null) {
            for (Simon simon : simons) {
                ((CounterImpl)simon).increasePrivate(inc, now);
            }
        }
    }

    @Override
    public Counter decrease() {
        return this.decrease(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Counter decrease(long dec) {
        CounterSample sample;
        if (!this.enabled) {
            return this;
        }
        long now = this.manager.milliTime();
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            this.decreasePrivate(dec, now);
            sample = this.sampleIfCallbacksNotEmpty();
            this.updateIncrementalSimonsDecrease(dec, now);
        }
        this.manager.callback().onCounterDecrease(this, dec, sample);
        return this;
    }

    private void decreasePrivate(long dec, long now) {
        this.updateUsages(now);
        this.decrementSum += dec;
        this.counter -= dec;
        if (dec > 0L) {
            this.updateMin();
        } else {
            this.updateMax();
        }
    }

    private void updateIncrementalSimonsDecrease(long dec, long now) {
        Collection<Simon> simons = this.incrementalSimons();
        if (simons != null) {
            for (Simon simon : simons) {
                ((CounterImpl)simon).decreasePrivate(dec, now);
            }
        }
    }

    private CounterSample sampleIfCallbacksNotEmpty() {
        if (!this.manager.callback().callbacks().isEmpty()) {
            return this.sample();
        }
        return null;
    }

    @Override
    public synchronized long getCounter() {
        return this.counter;
    }

    @Override
    public synchronized long getMin() {
        return this.min;
    }

    @Override
    public synchronized long getMinTimestamp() {
        return this.minTimestamp;
    }

    @Override
    public synchronized long getMax() {
        return this.max;
    }

    @Override
    public synchronized long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    @Override
    public synchronized long getIncrementSum() {
        return this.incrementSum;
    }

    @Override
    public synchronized long getDecrementSum() {
        return this.decrementSum;
    }

    @Override
    @Deprecated
    void concreteReset() {
        this.counter = 0L;
        this.max = Long.MIN_VALUE;
        this.maxTimestamp = 0L;
        this.min = Long.MAX_VALUE;
        this.minTimestamp = 0L;
        this.incrementSum = 0L;
        this.decrementSum = 0L;
    }

    @Override
    @Deprecated
    public synchronized CounterSample sampleAndReset() {
        CounterSample sample = this.sample();
        this.reset();
        return sample;
    }

    @Override
    public synchronized CounterSample sample() {
        CounterSample sample = new CounterSample();
        sample.setCounter(this.counter);
        sample.setMin(this.min);
        sample.setMax(this.max);
        sample.setMinTimestamp(this.minTimestamp);
        sample.setMaxTimestamp(this.maxTimestamp);
        sample.setIncrementSum(this.incrementSum);
        sample.setDecrementSum(this.decrementSum);
        this.sampleCommon(sample);
        return sample;
    }

    @Override
    public CounterSample sampleIncrement(Object key) {
        return (CounterSample)this.sampleIncrementHelper(key, new CounterImpl(null, this.manager));
    }

    @Override
    public synchronized String toString() {
        return "Simon Counter: counter=" + this.counter + ", max=" + SimonUtils.presentMinMaxCount(this.max) + ", min=" + SimonUtils.presentMinMaxCount(this.min) + super.toString();
    }
}

