/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.xml;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.StreamReader;
import ezvcard.io.StreamWriter;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardNamespaceContext;
import ezvcard.io.xml.XCardQNames;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.VCardProperty;
import ezvcard.property.Xml;
import ezvcard.util.IOUtils;
import ezvcard.util.ListMultimap;
import ezvcard.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCardDocument {
    private final VCardVersion version4 = VCardVersion.V4_0;
    private final Document document;
    private Element root;

    public XCardDocument() {
        this(XCardDocument.createXCardsRoot());
    }

    private static Document createXCardsRoot() {
        Document document = XmlUtils.createDocument();
        Element root = document.createElementNS(XCardQNames.VCARDS.getNamespaceURI(), XCardQNames.VCARDS.getLocalPart());
        document.appendChild(root);
        return document;
    }

    public XCardDocument(String xml) throws SAXException {
        this(XmlUtils.toDocument(xml));
    }

    public XCardDocument(InputStream in) throws SAXException, IOException {
        this(XmlUtils.toDocument(in));
    }

    public XCardDocument(File file) throws SAXException, IOException {
        this(XCardDocument.readFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document readFile(File file) throws SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Document document = XmlUtils.toDocument(in);
            return document;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public XCardDocument(Reader reader) throws SAXException, IOException {
        this(XmlUtils.toDocument(reader));
    }

    public XCardDocument(Document document) {
        this.document = document;
        XCardNamespaceContext nsContext = new XCardNamespaceContext(this.version4, "v");
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsContext);
        try {
            this.root = (Element)xpath.evaluate("//" + nsContext.getPrefix() + ":" + XCardQNames.VCARDS.getLocalPart(), document, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public StreamReader reader() {
        return new XCardDocumentStreamReader();
    }

    public XCardDocumentStreamWriter writer() {
        return new XCardDocumentStreamWriter();
    }

    public Document getDocument() {
        return this.document;
    }

    public List<VCard> getVCards() {
        try {
            return this.reader().readAll();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(VCard vcard) {
        this.writer().write(vcard);
    }

    public String write() {
        return this.write(-1);
    }

    public String write(int indent) {
        StringWriter sw = new StringWriter();
        try {
            this.write(sw, indent);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return sw.toString();
    }

    public void write(OutputStream out) throws TransformerException {
        this.write(out, -1);
    }

    public void write(OutputStream out, int indent) throws TransformerException {
        this.write(IOUtils.utf8Writer(out), indent);
    }

    public void write(File file) throws TransformerException, IOException {
        this.write(file, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, int indent) throws TransformerException, IOException {
        Writer writer = IOUtils.utf8Writer(file);
        try {
            this.write(writer, indent);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    public void write(Writer writer) throws TransformerException {
        this.write(writer, -1);
    }

    public void write(Writer writer, int indent) throws TransformerException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (indent >= 0) {
            properties.put("indent", "yes");
            properties.put("{http://xml.apache.org/xslt}indent-amount", indent + "");
        }
        XmlUtils.toWriter(this.document, writer, properties);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class XCardDocumentStreamWriter
    extends StreamWriter {
        private final Map<String, VCardDataType> parameterDataTypes = new HashMap<String, VCardDataType>();

        public XCardDocumentStreamWriter() {
            this.registerParameterDataType("ALTID", VCardDataType.TEXT);
            this.registerParameterDataType("CALSCALE", VCardDataType.TEXT);
            this.registerParameterDataType("GEO", VCardDataType.URI);
            this.registerParameterDataType("LABEL", VCardDataType.TEXT);
            this.registerParameterDataType("LANGUAGE", VCardDataType.LANGUAGE_TAG);
            this.registerParameterDataType("MEDIATYPE", VCardDataType.TEXT);
            this.registerParameterDataType("PID", VCardDataType.TEXT);
            this.registerParameterDataType("PREF", VCardDataType.INTEGER);
            this.registerParameterDataType("SORT-AS", VCardDataType.TEXT);
            this.registerParameterDataType("TYPE", VCardDataType.TEXT);
            this.registerParameterDataType("TZ", VCardDataType.URI);
        }

        @Override
        public void write(VCard vcard) {
            try {
                super.write(vcard);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        protected void _write(VCard vcard, List<VCardProperty> properties) throws IOException {
            ListMultimap<String, VCardProperty> propertiesByGroup = new ListMultimap<String, VCardProperty>();
            for (VCardProperty property : properties) {
                propertiesByGroup.put(property.getGroup(), property);
            }
            Element vcardElement = this.createElement(XCardQNames.VCARD);
            for (Map.Entry entry : propertiesByGroup) {
                Element parent;
                String groupName = (String)entry.getKey();
                if (groupName != null) {
                    Element groupElement = this.createElement(XCardQNames.GROUP);
                    groupElement.setAttribute("name", groupName);
                    vcardElement.appendChild(groupElement);
                    parent = groupElement;
                } else {
                    parent = vcardElement;
                }
                for (VCardProperty property : entry.getValue()) {
                    try {
                        Element propertyElement = this.marshalProperty(property, vcard);
                        parent.appendChild(propertyElement);
                    }
                    catch (SkipMeException e) {
                    }
                    catch (EmbeddedVCardException e) {}
                }
            }
            if (XCardDocument.this.root == null) {
                XCardDocument.this.root = this.createElement(XCardQNames.VCARDS);
                Element documentRoot = XmlUtils.getRootElement(XCardDocument.this.document);
                if (documentRoot == null) {
                    XCardDocument.this.document.appendChild(XCardDocument.this.root);
                } else {
                    documentRoot.appendChild(XCardDocument.this.root);
                }
            }
            XCardDocument.this.root.appendChild(vcardElement);
        }

        @Override
        protected VCardVersion getTargetVersion() {
            return VCardVersion.V4_0;
        }

        public void registerParameterDataType(String parameterName, VCardDataType dataType) {
            parameterName = parameterName.toLowerCase();
            if (dataType == null) {
                this.parameterDataTypes.remove(parameterName);
            } else {
                this.parameterDataTypes.put(parameterName, dataType);
            }
        }

        @Override
        public void close() {
        }

        private Element marshalProperty(VCardProperty type, VCard vcard) {
            VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(type);
            VCardParameters parameters = scribe.prepareParameters(type, XCardDocument.this.version4, vcard);
            QName qname = scribe.getQName();
            Element propertyElement = this.createElement(qname);
            if (!parameters.isEmpty()) {
                Element parametersElement = this.marshalParameters(parameters);
                propertyElement.appendChild(parametersElement);
            }
            scribe.writeXml(type, propertyElement);
            return propertyElement;
        }

        private Element marshalParameters(VCardParameters parameters) {
            Element parametersElement = this.createElement(XCardQNames.PARAMETERS);
            for (Map.Entry parameter : parameters) {
                String parameterName = ((String)parameter.getKey()).toLowerCase();
                Element parameterElement = this.createElement(parameterName);
                for (String parameterValue : parameter.getValue()) {
                    VCardDataType dataType = this.parameterDataTypes.get(parameterName);
                    String dataTypeElementName = dataType == null ? "unknown" : dataType.getName().toLowerCase();
                    Element dataTypeElement = this.createElement(dataTypeElementName);
                    dataTypeElement.setTextContent(parameterValue);
                    parameterElement.appendChild(dataTypeElement);
                }
                parametersElement.appendChild(parameterElement);
            }
            return parametersElement;
        }

        private Element createElement(String name) {
            return this.createElement(name, XCardDocument.this.version4.getXmlNamespace());
        }

        private Element createElement(String name, String ns) {
            return XCardDocument.this.document.createElementNS(ns, name);
        }

        private Element createElement(QName qname) {
            return this.createElement(qname.getLocalPart(), qname.getNamespaceURI());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XCardDocumentStreamReader
    extends StreamReader {
        private final Iterator<Element> vcardElements;
        private VCard vcard;

        private XCardDocumentStreamReader() {
            List list = XCardDocument.this.root == null ? Collections.emptyList() : this.getChildElements(XCardDocument.this.root, XCardQNames.VCARD);
            this.vcardElements = list.iterator();
        }

        @Override
        public VCard readNext() {
            try {
                return super.readNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected VCard _readNext() throws IOException {
            if (!this.vcardElements.hasNext()) {
                return null;
            }
            this.vcard = new VCard();
            this.vcard.setVersion(XCardDocument.this.version4);
            this.parseVCardElement(this.vcardElements.next());
            return this.vcard;
        }

        @Override
        public void close() {
        }

        private void parseVCardElement(Element vcardElement) {
            List<Element> children = XmlUtils.toElementList(vcardElement.getChildNodes());
            for (Element child : children) {
                if (XCardQNames.GROUP.getNamespaceURI().equals(child.getNamespaceURI()) && XCardQNames.GROUP.getLocalPart().equals(child.getLocalName())) {
                    String group = child.getAttribute("name");
                    if (group.length() == 0) {
                        group = null;
                    }
                    List<Element> grandChildren = XmlUtils.toElementList(child.getChildNodes());
                    for (Element grandChild : grandChildren) {
                        this.parseAndAddElement(grandChild, group);
                    }
                    continue;
                }
                this.parseAndAddElement(child, null);
            }
        }

        private void parseAndAddElement(Element element, String group) {
            VCardProperty property;
            VCardParameters parameters = this.parseParameters(element);
            String propertyName = element.getLocalName();
            String ns = element.getNamespaceURI();
            QName qname = new QName(ns, propertyName);
            VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(qname);
            try {
                VCardPropertyScribe.Result<? extends VCardProperty> result = scribe.parseXml(element, parameters);
                property = result.getProperty();
                property.setGroup(group);
                for (String warning : result.getWarnings()) {
                    this.warnings.add(null, propertyName, warning);
                }
            }
            catch (SkipMeException e) {
                this.warnings.add(null, propertyName, 22, e.getMessage());
                return;
            }
            catch (CannotParseException e) {
                String xml = XmlUtils.toString(element);
                this.warnings.add(null, propertyName, 33, xml, e.getMessage());
                scribe = this.index.getPropertyScribe(Xml.class);
                VCardPropertyScribe.Result<? extends VCardProperty> result = scribe.parseXml(element, parameters);
                property = result.getProperty();
                property.setGroup(group);
            }
            catch (EmbeddedVCardException e) {
                this.warnings.add(null, propertyName, 34, new Object[0]);
                return;
            }
            this.vcard.addProperty(property);
        }

        private VCardParameters parseParameters(Element element) {
            VCardParameters parameters = new VCardParameters();
            List<Element> roots = XmlUtils.toElementList(element.getElementsByTagNameNS(XCardQNames.PARAMETERS.getNamespaceURI(), XCardQNames.PARAMETERS.getLocalPart()));
            for (Element root : roots) {
                List<Element> parameterElements = XmlUtils.toElementList(root.getChildNodes());
                for (Element parameterElement : parameterElements) {
                    String name = parameterElement.getLocalName().toUpperCase();
                    List<Element> valueElements = XmlUtils.toElementList(parameterElement.getChildNodes());
                    if (valueElements.isEmpty()) {
                        String value = parameterElement.getTextContent();
                        parameters.put(name, value);
                        continue;
                    }
                    for (Element valueElement : valueElements) {
                        String value = valueElement.getTextContent();
                        parameters.put(name, value);
                    }
                }
            }
            return parameters;
        }

        private List<Element> getChildElements(Element parent, QName qname) {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element child : XmlUtils.toElementList(parent.getChildNodes())) {
                if (!qname.getLocalPart().equals(child.getLocalName()) || !qname.getNamespaceURI().equals(child.getNamespaceURI())) continue;
                elements.add(child);
            }
            return elements;
        }
    }
}

