/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.StructuredName;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredNameScribe
extends VCardPropertyScribe<StructuredName> {
    public StructuredNameScribe() {
        super(StructuredName.class, "N");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(StructuredName property, VCardVersion version) {
        return StructuredNameScribe.structured(property.getFamily(), property.getGiven(), property.getAdditional(), property.getPrefixes(), property.getSuffixes());
    }

    @Override
    protected StructuredName _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        StructuredName property = new StructuredName();
        VCardPropertyScribe.StructuredIterator it = StructuredNameScribe.structured(value);
        property.setFamily(it.nextString());
        property.setGiven(it.nextString());
        property.getAdditional().addAll(it.nextComponent());
        property.getPrefixes().addAll(it.nextComponent());
        property.getSuffixes().addAll(it.nextComponent());
        return property;
    }

    @Override
    protected void _writeXml(StructuredName property, XCardElement parent) {
        parent.append("surname", property.getFamily());
        parent.append("given", property.getGiven());
        parent.append("additional", property.getAdditional());
        parent.append("prefix", property.getPrefixes());
        parent.append("suffix", property.getSuffixes());
    }

    @Override
    protected StructuredName _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        StructuredName property = new StructuredName();
        property.setFamily(this.s(element.first("surname")));
        property.setGiven(this.s(element.first("given")));
        property.getAdditional().addAll(element.all("additional"));
        property.getPrefixes().addAll(element.all("prefix"));
        property.getSuffixes().addAll(element.all("suffix"));
        return property;
    }

    private String s(String value) {
        return value == null || value.length() == 0 ? null : value;
    }

    @Override
    protected StructuredName _parseHtml(HCardElement element, List<String> warnings) {
        StructuredName property = new StructuredName();
        property.setFamily(this.s(element.firstValue("family-name")));
        property.setGiven(this.s(element.firstValue("given-name")));
        property.getAdditional().addAll(element.allValues("additional-name"));
        property.getPrefixes().addAll(element.allValues("honorific-prefix"));
        property.getSuffixes().addAll(element.allValues("honorific-suffix"));
        return property;
    }

    @Override
    protected JCardValue _writeJson(StructuredName property) {
        return JCardValue.structured(property.getFamily(), property.getGiven(), property.getAdditional(), property.getPrefixes(), property.getSuffixes());
    }

    @Override
    protected StructuredName _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        StructuredName property = new StructuredName();
        VCardPropertyScribe.StructuredIterator it = StructuredNameScribe.structured(value);
        property.setFamily(it.nextString());
        property.setGiven(it.nextString());
        property.getAdditional().addAll(it.nextComponent());
        property.getPrefixes().addAll(it.nextComponent());
        property.getSuffixes().addAll(it.nextComponent());
        return property;
    }
}

