/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.benchmark;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.benchmark.CountingInputStream;
import org.apache.http.benchmark.CountingOutputStream;
import org.apache.http.benchmark.Stats;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.impl.entity.EntityDeserializer;
import org.apache.http.impl.entity.EntitySerializer;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;

class BenchmarkConnection
extends DefaultHttpClientConnection {
    private final Stats stats;

    BenchmarkConnection(Stats stats) {
        this.stats = stats;
    }

    protected EntityDeserializer createEntityDeserializer() {
        return new EntityDeserializer((ContentLengthStrategy)new LaxContentLengthStrategy()){

            protected BasicHttpEntity doDeserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
                BasicHttpEntity entity = super.doDeserialize(inbuffer, message);
                InputStream instream = entity.getContent();
                entity.setContent((InputStream)new CountingInputStream(instream, BenchmarkConnection.this.stats));
                return entity;
            }
        };
    }

    protected EntitySerializer createEntitySerializer() {
        return new EntitySerializer((ContentLengthStrategy)new StrictContentLengthStrategy()){

            protected OutputStream doSerialize(SessionOutputBuffer outbuffer, HttpMessage message) throws HttpException, IOException {
                return new CountingOutputStream(super.doSerialize(outbuffer, message), BenchmarkConnection.this.stats);
            }
        };
    }
}

