/*
 * Decompiled with CFR 0.152.
 */
package javapns.feedback;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.LinkedList;
import javapns.communication.exceptions.CommunicationException;
import javapns.communication.exceptions.KeystoreException;
import javapns.devices.Device;
import javapns.devices.DeviceFactory;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.devices.implementations.basic.BasicDeviceFactory;
import javapns.feedback.AppleFeedbackServer;
import javapns.feedback.ConnectionToFeedbackServer;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedbackServiceManager {
    protected static final Logger logger = Logger.getLogger(FeedbackServiceManager.class);
    private int sslSocketTimeout = 30000;
    private static final int FEEDBACK_TUPLE_SIZE = 38;
    @Deprecated
    private DeviceFactory deviceFactory;

    @Deprecated
    public FeedbackServiceManager(DeviceFactory deviceFactory) {
        this.setDeviceFactory(deviceFactory);
    }

    public FeedbackServiceManager() {
        this.setDeviceFactory(new BasicDeviceFactory());
    }

    public LinkedList<Device> getDevices(AppleFeedbackServer server) throws KeystoreException, CommunicationException {
        ConnectionToFeedbackServer connectionHelper = new ConnectionToFeedbackServer(server);
        SSLSocket socket = connectionHelper.getSSLSocket();
        return this.getDevices(socket);
    }

    private LinkedList<Device> getDevices(SSLSocket socket) throws CommunicationException {
        LinkedList<Device> listDev = null;
        try {
            InputStream socketStream = socket.getInputStream();
            if (this.sslSocketTimeout > 0) {
                socket.setSoTimeout(this.sslSocketTimeout);
            }
            byte[] b = new byte[1024];
            ByteArrayOutputStream message = new ByteArrayOutputStream();
            int nbBytes = 0;
            while ((nbBytes = socketStream.read(b, 0, 1024)) != -1) {
                message.write(b, 0, nbBytes);
            }
            listDev = new LinkedList<Device>();
            byte[] listOfDevices = message.toByteArray();
            int nbTuples = listOfDevices.length / 38;
            logger.debug((Object)("Found: [" + nbTuples + "]"));
            for (int i = 0; i < nbTuples; ++i) {
                int offset = i * 38;
                int index = 0;
                int firstByte = 0;
                int secondByte = 0;
                int thirdByte = 0;
                int fourthByte = 0;
                long anUnsignedInt = 0L;
                firstByte = 0xFF & listOfDevices[offset];
                secondByte = 0xFF & listOfDevices[offset + 1];
                thirdByte = 0xFF & listOfDevices[offset + 2];
                fourthByte = 0xFF & listOfDevices[offset + 3];
                index += 4;
                anUnsignedInt = (long)(firstByte << 24 | secondByte << 16 | thirdByte << 8 | fourthByte) & 0xFFFFFFFFL;
                Timestamp timestamp = new Timestamp(anUnsignedInt * 1000L);
                int deviceTokenLength = listOfDevices[offset + 4] << 8 | listOfDevices[offset + 5];
                String deviceToken = "";
                int octet = 0;
                for (int j = 0; j < 32; ++j) {
                    octet = 0xFF & listOfDevices[offset + 6 + j];
                    deviceToken = deviceToken.concat(String.format("%02x", octet));
                }
                BasicDevice device = new BasicDevice();
                device.setToken(deviceToken);
                device.setLastRegister(timestamp);
                listDev.add(device);
                logger.info((Object)("FeedbackManager retrieves one device :  " + timestamp + ";" + deviceTokenLength + ";" + deviceToken + "."));
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Caught exception fetching devices from Feedback Service");
            throw new CommunicationException("Problem communicating with Feedback service", e);
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception e) {}
        }
        return listDev;
    }

    @Deprecated
    public void setDeviceFactory(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
    }

    @Deprecated
    public DeviceFactory getDeviceFactory() {
        return this.deviceFactory;
    }

    public void setSslSocketTimeout(int sslSocketTimeout) {
        this.sslSocketTimeout = sslSocketTimeout;
    }

    public int getSslSocketTimeout() {
        return this.sslSocketTimeout;
    }
}

