/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class RLEDecoder
implements Decoder {
    private final byte[] pixel;

    RLEDecoder(int n) {
        Validate.isTrue((n % 8 == 0 ? 1 : 0) != 0, (String)"Depth must be a multiple of bytes (8 bits)");
        this.pixel = new byte[n / 8];
    }

    public int decode(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        int n;
        while (byteBuffer.remaining() >= 128 * this.pixel.length && (n = inputStream.read()) >= 0) {
            int n2;
            int n3;
            int n4 = (n & 0x7F) + 1;
            if ((n & 0x80) == 0) {
                for (n3 = 0; n3 < n4 * this.pixel.length && (n2 = inputStream.read()) >= 0; ++n3) {
                    byteBuffer.put((byte)n2);
                }
                continue;
            }
            for (n3 = 0; n3 < this.pixel.length && (n2 = inputStream.read()) >= 0; ++n3) {
                this.pixel[n3] = (byte)n2;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                byteBuffer.put(this.pixel);
            }
        }
        return byteBuffer.position();
    }
}

