/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.Pattern;
import com.twelvemonkeys.imageio.plugins.pict.QuickDraw;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

final class BitMapPattern
extends Pattern {
    private final byte[] pattern;

    BitMapPattern(Paint paint) {
        this(paint, null);
    }

    public BitMapPattern(byte[] byArray) {
        this(BitMapPattern.create8x8Pattern(byArray), byArray);
    }

    private BitMapPattern(Paint paint, byte[] byArray) {
        super(paint);
        this.pattern = byArray;
    }

    public BitMapPattern(byte[] byArray, Color color, Color color2) {
        this(BitMapPattern.create8x8Pattern(byArray, color, color2));
    }

    BitMapPattern(int n) {
        this(BitMapPattern.create8x8Pattern(n));
    }

    private static Paint create8x8Pattern(int n) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < byArray.length; i += 4) {
            byArray[i] = (byte)(n >> 24 & 0xFF);
            byArray[i + 1] = (byte)(n >> 16 & 0xFF);
            byArray[i + 2] = (byte)(n >> 8 & 0xFF);
            byArray[i + 3] = (byte)(n & 0xFF);
        }
        return BitMapPattern.create8x8Pattern(byArray);
    }

    private static Paint create8x8Pattern(byte[] byArray) {
        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, 8), 8, 8, 1, new Point());
        BufferedImage bufferedImage = new BufferedImage(QuickDraw.MONOCHROME, writableRaster, false, null);
        return new TexturePaint(bufferedImage, new Rectangle(8, 8));
    }

    private static Paint create8x8Pattern(byte[] byArray, Color color, Color color2) {
        switch (BitMapPattern.isSolid(byArray)) {
            case 0: {
                return color2;
            }
            case -1: {
                return color;
            }
        }
        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, 8), 8, 8, 1, new Point());
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new int[]{color2.getRGB(), color.getRGB()}, 0, false, -1, 0);
        BufferedImage bufferedImage = new BufferedImage(indexColorModel, writableRaster, false, null);
        return new TexturePaint(bufferedImage, new Rectangle(8, 8));
    }

    private static int isSolid(byte[] byArray) {
        byte by = byArray[0];
        for (int i = 1; i < byArray.length; ++i) {
            if (by == byArray[i]) continue;
            return 1;
        }
        return by;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return super.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    @Override
    public Pattern derive(Color color, Color color2) {
        if (this.paint instanceof Color) {
            return new BitMapPattern(color);
        }
        return null;
    }
}

