/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.CompoundIteratorImpl;
import com.google.ical.iter.Conditions;
import com.google.ical.iter.Filters;
import com.google.ical.iter.Generator;
import com.google.ical.iter.Generators;
import com.google.ical.iter.InstanceGenerators;
import com.google.ical.iter.RDateIteratorImpl;
import com.google.ical.iter.RRuleIteratorImpl;
import com.google.ical.iter.RecurrenceIterable;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.ThrottledGenerator;
import com.google.ical.util.Predicate;
import com.google.ical.util.Predicates;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.Frequency;
import com.google.ical.values.IcalObject;
import com.google.ical.values.RDateList;
import com.google.ical.values.RRule;
import com.google.ical.values.TimeValue;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class RecurrenceIteratorFactory {
    private static final Logger LOGGER = Logger.getLogger(RecurrenceIteratorFactory.class.getName());
    private static final Pattern FOLD = Pattern.compile("(?:\\r\\n?|\\n)[ \t]");
    private static final Pattern NEWLINE = Pattern.compile("[\\r\\n]+");
    private static final Pattern RULE = Pattern.compile("^(?:R|EX)RULE[:;]", 2);
    private static final Pattern DATE = Pattern.compile("^(?:R|EX)DATE[:;]", 2);

    public static RecurrenceIterator createRecurrenceIterator(String rdata, DateValue dtStart, TimeZone tzid, boolean strict) throws ParseException {
        return RecurrenceIteratorFactory.createRecurrenceIterable(rdata, dtStart, tzid, strict).iterator();
    }

    public static RecurrenceIterable createRecurrenceIterable(String rdata, final DateValue dtStart, final TimeZone tzid, final boolean strict) throws ParseException {
        final IcalObject[] contentLines = RecurrenceIteratorFactory.parseContentLines(rdata, tzid, strict);
        return new RecurrenceIterable(){

            public RecurrenceIterator iterator() {
                ArrayList<RecurrenceIterator> inclusions = new ArrayList<RecurrenceIterator>();
                ArrayList<RecurrenceIterator> exclusions = new ArrayList<RecurrenceIterator>();
                inclusions.add(new RDateIteratorImpl(new DateValue[]{TimeUtils.toUtc(dtStart, tzid)}));
                for (IcalObject contentLine : contentLines) {
                    try {
                        String name = contentLine.getName();
                        if ("rrule".equalsIgnoreCase(name)) {
                            inclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator((RRule)contentLine, dtStart, tzid));
                            continue;
                        }
                        if ("rdate".equalsIgnoreCase(name)) {
                            inclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator((RDateList)contentLine));
                            continue;
                        }
                        if ("exrule".equalsIgnoreCase(name)) {
                            exclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator((RRule)contentLine, dtStart, tzid));
                            continue;
                        }
                        if (!"exdate".equalsIgnoreCase(name)) continue;
                        exclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator((RDateList)contentLine));
                    }
                    catch (IllegalArgumentException ex) {
                        if (strict) {
                            throw ex;
                        }
                        LOGGER.log(Level.SEVERE, "Dropping bad recurrence rule line: " + contentLine.toIcal(), ex);
                    }
                }
                return new CompoundIteratorImpl(inclusions, exclusions);
            }
        };
    }

    public static RecurrenceIterator createRecurrenceIterator(String rdata, DateValue dtStart, TimeZone tzid) throws ParseException {
        return RecurrenceIteratorFactory.createRecurrenceIterator(rdata, dtStart, tzid, true);
    }

    public static RecurrenceIterator createRecurrenceIterator(RDateList rdates) {
        Object[] dates = rdates.getDatesUtc();
        Arrays.sort(dates);
        int k = 0;
        for (int i = 1; i < dates.length; ++i) {
            if (dates[i].equals(dates[k])) continue;
            dates[++k] = dates[i];
        }
        if (++k < dates.length) {
            DateValue[] uniqueDates = new DateValue[k];
            System.arraycopy(dates, 0, uniqueDates, 0, k);
            dates = uniqueDates;
        }
        return new RDateIteratorImpl((DateValue[])dates);
    }

    public static RecurrenceIterator createRecurrenceIterator(RRule rrule, DateValue dtStart, TimeZone tzid) {
        Generator instanceGenerator;
        Predicate filter;
        Predicate<DateValue> condition;
        Generator dayGenerator;
        assert (null != tzid);
        assert (null != dtStart);
        Frequency freq = rrule.getFreq();
        Weekday wkst = rrule.getWkSt();
        DateValue untilUtc = rrule.getUntil();
        int count = rrule.getCount();
        int interval = rrule.getInterval();
        WeekdayNum[] byDay = rrule.getByDay().toArray(new WeekdayNum[0]);
        int[] byMonth = rrule.getByMonth();
        int[] byMonthDay = rrule.getByMonthDay();
        int[] byWeekNo = rrule.getByWeekNo();
        int[] byYearDay = rrule.getByYearDay();
        int[] bySetPos = rrule.getBySetPos();
        int[] byHour = rrule.getByHour();
        int[] byMinute = rrule.getByMinute();
        int[] bySecond = rrule.getBySecond();
        DateTimeValueImpl startTime = null;
        if (1 == (byHour.length | byMinute.length | bySecond.length) && dtStart instanceof TimeValue) {
            TimeValue tv = (TimeValue)((Object)dtStart);
            startTime = new DateTimeValueImpl(0, 0, 0, 1 == byHour.length ? byHour[0] : tv.hour(), 1 == byMinute.length ? byMinute[0] : tv.minute(), 1 == bySecond.length ? bySecond[0] : tv.second());
        }
        if (interval <= 0) {
            interval = 1;
        }
        if (null == wkst) {
            wkst = Weekday.MO;
        }
        ThrottledGenerator yearGenerator = Generators.serialYearGenerator(freq == Frequency.YEARLY ? interval : 1, dtStart);
        Generator monthGenerator = null;
        ArrayList<Predicate<DateValue>> filters = new ArrayList<Predicate<DateValue>>();
        switch (freq) {
            case DAILY: {
                dayGenerator = 0 == byMonthDay.length ? Generators.serialDayGenerator(interval, dtStart) : Generators.byMonthDayGenerator(byMonthDay, dtStart);
                if (0 == byDay.length) break;
                filters.add(Filters.byDayFilter(byDay, true, wkst));
                break;
            }
            case WEEKLY: {
                if (0 != byDay.length) {
                    dayGenerator = Generators.byDayGenerator(byDay, false, dtStart);
                    if (interval > 1) {
                        filters.add(Filters.weekIntervalFilter(interval, wkst, dtStart));
                    }
                } else {
                    dayGenerator = Generators.serialDayGenerator(interval * 7, dtStart);
                }
                if (0 == byMonthDay.length) break;
                filters.add(Filters.byMonthDayFilter(byMonthDay));
                break;
            }
            case YEARLY: {
                if (0 != byYearDay.length) {
                    dayGenerator = Generators.byYearDayGenerator(byYearDay, dtStart);
                    if (0 != byDay.length) {
                        filters.add(Filters.byDayFilter(byDay, true, wkst));
                    }
                    if (0 == byMonthDay.length) break;
                    filters.add(Filters.byMonthDayFilter(byMonthDay));
                    break;
                }
            }
            case MONTHLY: {
                if (0 != byMonthDay.length) {
                    dayGenerator = Generators.byMonthDayGenerator(byMonthDay, dtStart);
                    if (0 == byDay.length) break;
                    filters.add(Filters.byDayFilter(byDay, Frequency.YEARLY == freq, wkst));
                    break;
                }
                if (0 != byWeekNo.length && Frequency.YEARLY == freq) {
                    dayGenerator = Generators.byWeekNoGenerator(byWeekNo, wkst, dtStart);
                    if (0 == byDay.length) break;
                    filters.add(Filters.byDayFilter(byDay, true, wkst));
                    break;
                }
                if (0 != byDay.length) {
                    dayGenerator = Generators.byDayGenerator(byDay, Frequency.YEARLY == freq && 0 == byMonth.length, dtStart);
                    break;
                }
                if (Frequency.YEARLY == freq) {
                    monthGenerator = Generators.byMonthGenerator(new int[]{dtStart.month()}, dtStart);
                }
                dayGenerator = Generators.byMonthDayGenerator(new int[]{dtStart.day()}, dtStart);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't iterate more frequently than daily");
            }
        }
        if (0 != byMonth.length) {
            monthGenerator = Generators.byMonthGenerator(byMonth, dtStart);
        } else if (null == monthGenerator) {
            monthGenerator = Generators.serialMonthGenerator(freq == Frequency.MONTHLY ? interval : 1, dtStart);
        }
        boolean canShortcutAdvance = true;
        if (0 != count) {
            condition = Conditions.countCondition(count);
            canShortcutAdvance = false;
        } else if (null != untilUtc) {
            if (untilUtc instanceof TimeValue != dtStart instanceof TimeValue) {
                untilUtc = dtStart instanceof TimeValue ? TimeUtils.dayStart(untilUtc) : TimeUtils.toDateValue(untilUtc);
            }
            condition = Conditions.untilCondition(untilUtc);
        } else {
            condition = Predicates.alwaysTrue();
        }
        switch (filters.size()) {
            case 0: {
                filter = Predicates.alwaysTrue();
                break;
            }
            case 1: {
                filter = (Predicate)filters.get(0);
                break;
            }
            default: {
                filter = Predicates.and(filters.toArray(new Predicate[0]));
            }
        }
        if (0 != bySetPos.length) {
            switch (freq) {
                case WEEKLY: 
                case YEARLY: 
                case MONTHLY: {
                    instanceGenerator = InstanceGenerators.bySetPosInstanceGenerator(bySetPos, freq, wkst, filter, yearGenerator, monthGenerator, dayGenerator);
                    break;
                }
                default: {
                    instanceGenerator = InstanceGenerators.serialInstanceGenerator(filter, yearGenerator, monthGenerator, dayGenerator);
                    break;
                }
            }
        } else {
            instanceGenerator = InstanceGenerators.serialInstanceGenerator(filter, yearGenerator, monthGenerator, dayGenerator);
        }
        return new RRuleIteratorImpl(dtStart, tzid, condition, filter, instanceGenerator, yearGenerator, monthGenerator, dayGenerator, canShortcutAdvance, startTime);
    }

    public static RecurrenceIterator join(RecurrenceIterator a, RecurrenceIterator ... b) {
        ArrayList<RecurrenceIterator> incl = new ArrayList<RecurrenceIterator>();
        incl.add(a);
        incl.addAll(Arrays.asList(b));
        return new CompoundIteratorImpl(incl, Collections.<RecurrenceIterator>emptyList());
    }

    public static RecurrenceIterator except(RecurrenceIterator included, RecurrenceIterator excluded) {
        return new CompoundIteratorImpl(Collections.singleton(included), Collections.singleton(excluded));
    }

    private static IcalObject[] parseContentLines(String rdata, TimeZone tzid, boolean strict) throws ParseException {
        String unfolded = FOLD.matcher(rdata).replaceAll("").trim();
        if ("".equals(unfolded)) {
            return new IcalObject[0];
        }
        String[] lines = NEWLINE.split(unfolded);
        IcalObject[] out = new IcalObject[lines.length];
        int nbad = 0;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            try {
                if (RULE.matcher(line).find()) {
                    out[i] = new RRule(line);
                    continue;
                }
                if (DATE.matcher(line).find()) {
                    out[i] = new RDateList(line, tzid);
                    continue;
                }
                throw new ParseException(lines[i], i);
            }
            catch (ParseException ex) {
                if (strict) {
                    throw ex;
                }
                LOGGER.log(Level.SEVERE, "Dropping bad recurrence rule line: " + line, ex);
                ++nbad;
                continue;
            }
            catch (IllegalArgumentException ex) {
                if (strict) {
                    throw ex;
                }
                LOGGER.log(Level.SEVERE, "Dropping bad recurrence rule line: " + line, ex);
                ++nbad;
            }
        }
        if (0 != nbad) {
            IcalObject[] trimmed = new IcalObject[out.length - nbad];
            int i = 0;
            int k = 0;
            while (i < trimmed.length) {
                if (null != out[k]) {
                    trimmed[i++] = out[k];
                }
                ++k;
            }
            out = trimmed;
        }
        return out;
    }

    private RecurrenceIteratorFactory() {
    }
}

