/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.Path;
import com.google.gdata.model.PathAdapter;

class VirtualElementHolder {
    private final ElementMetadata.SingleVirtualElement single;
    private final ElementMetadata.MultipleVirtualElement multiple;

    static VirtualElementHolder of(ElementMetadata.SingleVirtualElement single) {
        if (single == null) {
            return null;
        }
        return new VirtualElementHolder(single, null);
    }

    static VirtualElementHolder of(ElementMetadata.MultipleVirtualElement multiple) {
        if (multiple == null) {
            return null;
        }
        return new VirtualElementHolder(null, multiple);
    }

    static VirtualElementHolder of(Path path) {
        if (path == null) {
            return null;
        }
        PathAdapter.ElementAdapter adapter = PathAdapter.elementAdapter(path);
        return new VirtualElementHolder(adapter, adapter);
    }

    private VirtualElementHolder(ElementMetadata.SingleVirtualElement single, ElementMetadata.MultipleVirtualElement multiple) {
        this.single = single;
        this.multiple = multiple;
    }

    ElementMetadata.SingleVirtualElement getSingleVirtualElement() {
        return this.single;
    }

    ElementMetadata.MultipleVirtualElement getMultipleVirtualElement() {
        return this.multiple;
    }
}

