/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.junit;

import com.amazonaws.services.simpleworkflow.flow.junit.WorkflowTestBase;
import java.util.List;
import org.junit.Test;
import org.junit.rules.MethodRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class FlowBlockJUnit4ClassRunner
extends BlockJUnit4ClassRunner {
    private WorkflowTestBase workflowTestRule;
    private long timeout;
    private Class<? extends Throwable> expectedException;

    public FlowBlockJUnit4ClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        Test annotation = (Test)method.getAnnotation(Test.class);
        this.timeout = annotation.timeout();
        if (this.timeout > 0L && this.workflowTestRule != null) {
            this.workflowTestRule.setTestTimeoutActualTimeMilliseconds(this.timeout);
        }
        return next;
    }

    protected List<MethodRule> rules(Object test) {
        List result = super.rules(test);
        for (MethodRule methodRule : result) {
            if (!WorkflowTestBase.class.isAssignableFrom(methodRule.getClass())) continue;
            this.workflowTestRule = (WorkflowTestBase)methodRule;
            this.workflowTestRule.setFlowTestRunner(true);
            if (this.timeout > 0L) {
                this.workflowTestRule.setTestTimeoutActualTimeMilliseconds(this.timeout);
            }
            if (this.expectedException == null) continue;
            this.workflowTestRule.setExpectedException(this.expectedException);
        }
        return result;
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod method, Object test, Statement next) {
        Test annotation = (Test)method.getAnnotation(Test.class);
        Class expected = annotation.expected();
        if (expected != Test.None.class) {
            this.expectedException = expected;
            if (this.workflowTestRule != null) {
                this.workflowTestRule.setExpectedException(this.expectedException);
            }
        }
        return next;
    }
}

