/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.InputStream;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.SequenceFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMCaptureInInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getLogger(RMCaptureInInterceptor.class);

    public RMCaptureInInterceptor() {
        super("pre-stream");
    }

    @Override
    protected void handle(Message message) throws SequenceFault, RMException {
        InputStream is;
        LOG.entering(this.getClass().getName(), "handleMessage");
        if (!MessageUtils.isTrue(message.getContextualProperty("org.apache.cxf.oneway.robust")) && (is = message.getContent(InputStream.class)) != null) {
            CachedOutputStream saved = new CachedOutputStream();
            try {
                IOUtils.copy(is, saved);
                saved.flush();
                is.close();
                saved.lockOutputStream();
                message.setContent(InputStream.class, saved.getInputStream());
                LOG.fine("Capturing the original RM message");
                message.put("org.apache.cxf.ws.rm.content", saved);
            }
            catch (Exception e) {
                throw new Fault(e);
            }
        }
    }
}

