/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.org.json;

import twitter4j.org.json.JSONArray;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;
import twitter4j.org.json.JSONTokener;

public class CDL {
    private static String getValue(JSONTokener x) throws JSONException {
        char c;
        while ((c = x.next()) == ' ' || c == '\t') {
        }
        switch (c) {
            case '\u0000': {
                return null;
            }
            case '\"': 
            case '\'': {
                return x.nextString(c);
            }
            case ',': {
                x.back();
                return "";
            }
        }
        x.back();
        return x.nextTo(',');
    }

    public static JSONArray rowToJSONArray(JSONTokener x) throws JSONException {
        char c;
        JSONArray ja = new JSONArray();
        block0: while (true) {
            String value;
            if ((value = CDL.getValue(x)) == null || ja.length() == 0 && value.length() == 0) {
                return null;
            }
            ja.put(value);
            do {
                if ((c = x.next()) == ',') continue block0;
            } while (c == ' ');
            break;
        }
        if (c == '\n' || c == '\r' || c == '\u0000') {
            return ja;
        }
        throw x.syntaxError("Bad character '" + c + "' (" + c + ").");
    }

    public static JSONObject rowToJSONObject(JSONArray names, JSONTokener x) throws JSONException {
        JSONArray ja = CDL.rowToJSONArray(x);
        return ja != null ? ja.toJSONObject(names) : null;
    }

    public static JSONArray toJSONArray(String string) throws JSONException {
        return CDL.toJSONArray(new JSONTokener(string));
    }

    public static JSONArray toJSONArray(JSONTokener x) throws JSONException {
        return CDL.toJSONArray(CDL.rowToJSONArray(x), x);
    }

    public static JSONArray toJSONArray(JSONArray names, String string) throws JSONException {
        return CDL.toJSONArray(names, new JSONTokener(string));
    }

    public static JSONArray toJSONArray(JSONArray names, JSONTokener x) throws JSONException {
        JSONObject jo;
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        while ((jo = CDL.rowToJSONObject(names, x)) != null) {
            ja.put(jo);
        }
        if (ja.length() == 0) {
            return null;
        }
        return ja;
    }

    public static String rowToString(JSONArray ja) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ja.length()) {
            Object o;
            if (i > 0) {
                sb.append(',');
            }
            if ((o = ja.opt(i)) != null) {
                String s = o.toString();
                if (s.indexOf(44) >= 0) {
                    if (s.indexOf(34) >= 0) {
                        sb.append('\'');
                        sb.append(s);
                        sb.append('\'');
                    } else {
                        sb.append('\"');
                        sb.append(s);
                        sb.append('\"');
                    }
                } else {
                    sb.append(s);
                }
            }
            ++i;
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String toString(JSONArray ja) throws JSONException {
        JSONArray names;
        JSONObject jo = ja.optJSONObject(0);
        if (jo != null && (names = jo.names()) != null) {
            return String.valueOf(CDL.rowToString(names)) + CDL.toString(names, ja);
        }
        return null;
    }

    public static String toString(JSONArray names, JSONArray ja) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ja.length()) {
            JSONObject jo = ja.optJSONObject(i);
            if (jo != null) {
                sb.append(CDL.rowToString(jo.toJSONArray(names)));
            }
            ++i;
        }
        return sb.toString();
    }
}

