/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.machinelearning.AmazonMachineLearningAsync;
import com.amazonaws.services.machinelearning.AmazonMachineLearningClient;
import com.amazonaws.services.machinelearning.model.CreateBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.CreateBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Request;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Result;
import com.amazonaws.services.machinelearning.model.CreateEvaluationRequest;
import com.amazonaws.services.machinelearning.model.CreateEvaluationResult;
import com.amazonaws.services.machinelearning.model.CreateMLModelRequest;
import com.amazonaws.services.machinelearning.model.CreateMLModelResult;
import com.amazonaws.services.machinelearning.model.CreateRealtimeEndpointRequest;
import com.amazonaws.services.machinelearning.model.CreateRealtimeEndpointResult;
import com.amazonaws.services.machinelearning.model.DeleteBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.DeleteBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.DeleteDataSourceRequest;
import com.amazonaws.services.machinelearning.model.DeleteDataSourceResult;
import com.amazonaws.services.machinelearning.model.DeleteEvaluationRequest;
import com.amazonaws.services.machinelearning.model.DeleteEvaluationResult;
import com.amazonaws.services.machinelearning.model.DeleteMLModelRequest;
import com.amazonaws.services.machinelearning.model.DeleteMLModelResult;
import com.amazonaws.services.machinelearning.model.DeleteRealtimeEndpointRequest;
import com.amazonaws.services.machinelearning.model.DeleteRealtimeEndpointResult;
import com.amazonaws.services.machinelearning.model.DescribeBatchPredictionsRequest;
import com.amazonaws.services.machinelearning.model.DescribeBatchPredictionsResult;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesRequest;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesResult;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsRequest;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsResult;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsRequest;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsResult;
import com.amazonaws.services.machinelearning.model.GetBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.GetBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.GetDataSourceRequest;
import com.amazonaws.services.machinelearning.model.GetDataSourceResult;
import com.amazonaws.services.machinelearning.model.GetEvaluationRequest;
import com.amazonaws.services.machinelearning.model.GetEvaluationResult;
import com.amazonaws.services.machinelearning.model.GetMLModelRequest;
import com.amazonaws.services.machinelearning.model.GetMLModelResult;
import com.amazonaws.services.machinelearning.model.PredictRequest;
import com.amazonaws.services.machinelearning.model.PredictResult;
import com.amazonaws.services.machinelearning.model.UpdateBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.UpdateBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.UpdateDataSourceRequest;
import com.amazonaws.services.machinelearning.model.UpdateDataSourceResult;
import com.amazonaws.services.machinelearning.model.UpdateEvaluationRequest;
import com.amazonaws.services.machinelearning.model.UpdateEvaluationResult;
import com.amazonaws.services.machinelearning.model.UpdateMLModelRequest;
import com.amazonaws.services.machinelearning.model.UpdateMLModelResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonMachineLearningAsyncClient
extends AmazonMachineLearningClient
implements AmazonMachineLearningAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonMachineLearningAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonMachineLearningAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonMachineLearningAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonMachineLearningAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonMachineLearningAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<UpdateEvaluationResult> updateEvaluationAsync(final UpdateEvaluationRequest updateEvaluationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateEvaluationResult>(){

            @Override
            public UpdateEvaluationResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.updateEvaluation(updateEvaluationRequest);
            }
        });
    }

    @Override
    public Future<UpdateEvaluationResult> updateEvaluationAsync(final UpdateEvaluationRequest updateEvaluationRequest, final AsyncHandler<UpdateEvaluationRequest, UpdateEvaluationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateEvaluationResult>(){

            @Override
            public UpdateEvaluationResult call() throws Exception {
                UpdateEvaluationResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.updateEvaluation(updateEvaluationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateEvaluationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateMLModelResult> createMLModelAsync(final CreateMLModelRequest createMLModelRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateMLModelResult>(){

            @Override
            public CreateMLModelResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.createMLModel(createMLModelRequest);
            }
        });
    }

    @Override
    public Future<CreateMLModelResult> createMLModelAsync(final CreateMLModelRequest createMLModelRequest, final AsyncHandler<CreateMLModelRequest, CreateMLModelResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateMLModelResult>(){

            @Override
            public CreateMLModelResult call() throws Exception {
                CreateMLModelResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createMLModel(createMLModelRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createMLModelRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateRealtimeEndpointResult> createRealtimeEndpointAsync(final CreateRealtimeEndpointRequest createRealtimeEndpointRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateRealtimeEndpointResult>(){

            @Override
            public CreateRealtimeEndpointResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.createRealtimeEndpoint(createRealtimeEndpointRequest);
            }
        });
    }

    @Override
    public Future<CreateRealtimeEndpointResult> createRealtimeEndpointAsync(final CreateRealtimeEndpointRequest createRealtimeEndpointRequest, final AsyncHandler<CreateRealtimeEndpointRequest, CreateRealtimeEndpointResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateRealtimeEndpointResult>(){

            @Override
            public CreateRealtimeEndpointResult call() throws Exception {
                CreateRealtimeEndpointResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createRealtimeEndpoint(createRealtimeEndpointRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createRealtimeEndpointRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromS3Result> createDataSourceFromS3Async(final CreateDataSourceFromS3Request createDataSourceFromS3Request) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDataSourceFromS3Result>(){

            @Override
            public CreateDataSourceFromS3Result call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.createDataSourceFromS3(createDataSourceFromS3Request);
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromS3Result> createDataSourceFromS3Async(final CreateDataSourceFromS3Request createDataSourceFromS3Request, final AsyncHandler<CreateDataSourceFromS3Request, CreateDataSourceFromS3Result> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDataSourceFromS3Result>(){

            @Override
            public CreateDataSourceFromS3Result call() throws Exception {
                CreateDataSourceFromS3Result result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createDataSourceFromS3(createDataSourceFromS3Request);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createDataSourceFromS3Request, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMLModelResult> deleteMLModelAsync(final DeleteMLModelRequest deleteMLModelRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteMLModelResult>(){

            @Override
            public DeleteMLModelResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.deleteMLModel(deleteMLModelRequest);
            }
        });
    }

    @Override
    public Future<DeleteMLModelResult> deleteMLModelAsync(final DeleteMLModelRequest deleteMLModelRequest, final AsyncHandler<DeleteMLModelRequest, DeleteMLModelResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteMLModelResult>(){

            @Override
            public DeleteMLModelResult call() throws Exception {
                DeleteMLModelResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteMLModel(deleteMLModelRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteMLModelRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<PredictResult> predictAsync(final PredictRequest predictRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PredictResult>(){

            @Override
            public PredictResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.predict(predictRequest);
            }
        });
    }

    @Override
    public Future<PredictResult> predictAsync(final PredictRequest predictRequest, final AsyncHandler<PredictRequest, PredictResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PredictResult>(){

            @Override
            public PredictResult call() throws Exception {
                PredictResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.predict(predictRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(predictRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBatchPredictionsResult> describeBatchPredictionsAsync(final DescribeBatchPredictionsRequest describeBatchPredictionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeBatchPredictionsResult>(){

            @Override
            public DescribeBatchPredictionsResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.describeBatchPredictions(describeBatchPredictionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeBatchPredictionsResult> describeBatchPredictionsAsync(final DescribeBatchPredictionsRequest describeBatchPredictionsRequest, final AsyncHandler<DescribeBatchPredictionsRequest, DescribeBatchPredictionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeBatchPredictionsResult>(){

            @Override
            public DescribeBatchPredictionsResult call() throws Exception {
                DescribeBatchPredictionsResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.describeBatchPredictions(describeBatchPredictionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeBatchPredictionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetEvaluationResult> getEvaluationAsync(final GetEvaluationRequest getEvaluationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetEvaluationResult>(){

            @Override
            public GetEvaluationResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.getEvaluation(getEvaluationRequest);
            }
        });
    }

    @Override
    public Future<GetEvaluationResult> getEvaluationAsync(final GetEvaluationRequest getEvaluationRequest, final AsyncHandler<GetEvaluationRequest, GetEvaluationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetEvaluationResult>(){

            @Override
            public GetEvaluationResult call() throws Exception {
                GetEvaluationResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.getEvaluation(getEvaluationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getEvaluationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMLModelResult> updateMLModelAsync(final UpdateMLModelRequest updateMLModelRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateMLModelResult>(){

            @Override
            public UpdateMLModelResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.updateMLModel(updateMLModelRequest);
            }
        });
    }

    @Override
    public Future<UpdateMLModelResult> updateMLModelAsync(final UpdateMLModelRequest updateMLModelRequest, final AsyncHandler<UpdateMLModelRequest, UpdateMLModelResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateMLModelResult>(){

            @Override
            public UpdateMLModelResult call() throws Exception {
                UpdateMLModelResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.updateMLModel(updateMLModelRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateMLModelRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetDataSourceResult> getDataSourceAsync(final GetDataSourceRequest getDataSourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetDataSourceResult>(){

            @Override
            public GetDataSourceResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.getDataSource(getDataSourceRequest);
            }
        });
    }

    @Override
    public Future<GetDataSourceResult> getDataSourceAsync(final GetDataSourceRequest getDataSourceRequest, final AsyncHandler<GetDataSourceRequest, GetDataSourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetDataSourceResult>(){

            @Override
            public GetDataSourceResult call() throws Exception {
                GetDataSourceResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.getDataSource(getDataSourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getDataSourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDataSourcesResult> describeDataSourcesAsync(final DescribeDataSourcesRequest describeDataSourcesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDataSourcesResult>(){

            @Override
            public DescribeDataSourcesResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.describeDataSources(describeDataSourcesRequest);
            }
        });
    }

    @Override
    public Future<DescribeDataSourcesResult> describeDataSourcesAsync(final DescribeDataSourcesRequest describeDataSourcesRequest, final AsyncHandler<DescribeDataSourcesRequest, DescribeDataSourcesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDataSourcesResult>(){

            @Override
            public DescribeDataSourcesResult call() throws Exception {
                DescribeDataSourcesResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.describeDataSources(describeDataSourcesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeDataSourcesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEvaluationResult> deleteEvaluationAsync(final DeleteEvaluationRequest deleteEvaluationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteEvaluationResult>(){

            @Override
            public DeleteEvaluationResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.deleteEvaluation(deleteEvaluationRequest);
            }
        });
    }

    @Override
    public Future<DeleteEvaluationResult> deleteEvaluationAsync(final DeleteEvaluationRequest deleteEvaluationRequest, final AsyncHandler<DeleteEvaluationRequest, DeleteEvaluationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteEvaluationResult>(){

            @Override
            public DeleteEvaluationResult call() throws Exception {
                DeleteEvaluationResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteEvaluation(deleteEvaluationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteEvaluationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBatchPredictionResult> updateBatchPredictionAsync(final UpdateBatchPredictionRequest updateBatchPredictionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateBatchPredictionResult>(){

            @Override
            public UpdateBatchPredictionResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.updateBatchPrediction(updateBatchPredictionRequest);
            }
        });
    }

    @Override
    public Future<UpdateBatchPredictionResult> updateBatchPredictionAsync(final UpdateBatchPredictionRequest updateBatchPredictionRequest, final AsyncHandler<UpdateBatchPredictionRequest, UpdateBatchPredictionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateBatchPredictionResult>(){

            @Override
            public UpdateBatchPredictionResult call() throws Exception {
                UpdateBatchPredictionResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.updateBatchPrediction(updateBatchPredictionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateBatchPredictionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateBatchPredictionResult> createBatchPredictionAsync(final CreateBatchPredictionRequest createBatchPredictionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateBatchPredictionResult>(){

            @Override
            public CreateBatchPredictionResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.createBatchPrediction(createBatchPredictionRequest);
            }
        });
    }

    @Override
    public Future<CreateBatchPredictionResult> createBatchPredictionAsync(final CreateBatchPredictionRequest createBatchPredictionRequest, final AsyncHandler<CreateBatchPredictionRequest, CreateBatchPredictionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateBatchPredictionResult>(){

            @Override
            public CreateBatchPredictionResult call() throws Exception {
                CreateBatchPredictionResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createBatchPrediction(createBatchPredictionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createBatchPredictionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMLModelsResult> describeMLModelsAsync(final DescribeMLModelsRequest describeMLModelsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMLModelsResult>(){

            @Override
            public DescribeMLModelsResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.describeMLModels(describeMLModelsRequest);
            }
        });
    }

    @Override
    public Future<DescribeMLModelsResult> describeMLModelsAsync(final DescribeMLModelsRequest describeMLModelsRequest, final AsyncHandler<DescribeMLModelsRequest, DescribeMLModelsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMLModelsResult>(){

            @Override
            public DescribeMLModelsResult call() throws Exception {
                DescribeMLModelsResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.describeMLModels(describeMLModelsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeMLModelsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBatchPredictionResult> deleteBatchPredictionAsync(final DeleteBatchPredictionRequest deleteBatchPredictionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteBatchPredictionResult>(){

            @Override
            public DeleteBatchPredictionResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.deleteBatchPrediction(deleteBatchPredictionRequest);
            }
        });
    }

    @Override
    public Future<DeleteBatchPredictionResult> deleteBatchPredictionAsync(final DeleteBatchPredictionRequest deleteBatchPredictionRequest, final AsyncHandler<DeleteBatchPredictionRequest, DeleteBatchPredictionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteBatchPredictionResult>(){

            @Override
            public DeleteBatchPredictionResult call() throws Exception {
                DeleteBatchPredictionResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteBatchPrediction(deleteBatchPredictionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteBatchPredictionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDataSourceResult> updateDataSourceAsync(final UpdateDataSourceRequest updateDataSourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateDataSourceResult>(){

            @Override
            public UpdateDataSourceResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.updateDataSource(updateDataSourceRequest);
            }
        });
    }

    @Override
    public Future<UpdateDataSourceResult> updateDataSourceAsync(final UpdateDataSourceRequest updateDataSourceRequest, final AsyncHandler<UpdateDataSourceRequest, UpdateDataSourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateDataSourceResult>(){

            @Override
            public UpdateDataSourceResult call() throws Exception {
                UpdateDataSourceResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.updateDataSource(updateDataSourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateDataSourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromRDSResult> createDataSourceFromRDSAsync(final CreateDataSourceFromRDSRequest createDataSourceFromRDSRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDataSourceFromRDSResult>(){

            @Override
            public CreateDataSourceFromRDSResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.createDataSourceFromRDS(createDataSourceFromRDSRequest);
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromRDSResult> createDataSourceFromRDSAsync(final CreateDataSourceFromRDSRequest createDataSourceFromRDSRequest, final AsyncHandler<CreateDataSourceFromRDSRequest, CreateDataSourceFromRDSResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDataSourceFromRDSResult>(){

            @Override
            public CreateDataSourceFromRDSResult call() throws Exception {
                CreateDataSourceFromRDSResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createDataSourceFromRDS(createDataSourceFromRDSRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createDataSourceFromRDSRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromRedshiftResult> createDataSourceFromRedshiftAsync(final CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDataSourceFromRedshiftResult>(){

            @Override
            public CreateDataSourceFromRedshiftResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.createDataSourceFromRedshift(createDataSourceFromRedshiftRequest);
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromRedshiftResult> createDataSourceFromRedshiftAsync(final CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest, final AsyncHandler<CreateDataSourceFromRedshiftRequest, CreateDataSourceFromRedshiftResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDataSourceFromRedshiftResult>(){

            @Override
            public CreateDataSourceFromRedshiftResult call() throws Exception {
                CreateDataSourceFromRedshiftResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createDataSourceFromRedshift(createDataSourceFromRedshiftRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createDataSourceFromRedshiftRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEvaluationsResult> describeEvaluationsAsync(final DescribeEvaluationsRequest describeEvaluationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEvaluationsResult>(){

            @Override
            public DescribeEvaluationsResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.describeEvaluations(describeEvaluationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeEvaluationsResult> describeEvaluationsAsync(final DescribeEvaluationsRequest describeEvaluationsRequest, final AsyncHandler<DescribeEvaluationsRequest, DescribeEvaluationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEvaluationsResult>(){

            @Override
            public DescribeEvaluationsResult call() throws Exception {
                DescribeEvaluationsResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.describeEvaluations(describeEvaluationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeEvaluationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetMLModelResult> getMLModelAsync(final GetMLModelRequest getMLModelRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetMLModelResult>(){

            @Override
            public GetMLModelResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.getMLModel(getMLModelRequest);
            }
        });
    }

    @Override
    public Future<GetMLModelResult> getMLModelAsync(final GetMLModelRequest getMLModelRequest, final AsyncHandler<GetMLModelRequest, GetMLModelResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetMLModelResult>(){

            @Override
            public GetMLModelResult call() throws Exception {
                GetMLModelResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.getMLModel(getMLModelRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getMLModelRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDataSourceResult> deleteDataSourceAsync(final DeleteDataSourceRequest deleteDataSourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDataSourceResult>(){

            @Override
            public DeleteDataSourceResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.deleteDataSource(deleteDataSourceRequest);
            }
        });
    }

    @Override
    public Future<DeleteDataSourceResult> deleteDataSourceAsync(final DeleteDataSourceRequest deleteDataSourceRequest, final AsyncHandler<DeleteDataSourceRequest, DeleteDataSourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDataSourceResult>(){

            @Override
            public DeleteDataSourceResult call() throws Exception {
                DeleteDataSourceResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteDataSource(deleteDataSourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteDataSourceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetBatchPredictionResult> getBatchPredictionAsync(final GetBatchPredictionRequest getBatchPredictionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetBatchPredictionResult>(){

            @Override
            public GetBatchPredictionResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.getBatchPrediction(getBatchPredictionRequest);
            }
        });
    }

    @Override
    public Future<GetBatchPredictionResult> getBatchPredictionAsync(final GetBatchPredictionRequest getBatchPredictionRequest, final AsyncHandler<GetBatchPredictionRequest, GetBatchPredictionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetBatchPredictionResult>(){

            @Override
            public GetBatchPredictionResult call() throws Exception {
                GetBatchPredictionResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.getBatchPrediction(getBatchPredictionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getBatchPredictionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateEvaluationResult> createEvaluationAsync(final CreateEvaluationRequest createEvaluationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateEvaluationResult>(){

            @Override
            public CreateEvaluationResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.createEvaluation(createEvaluationRequest);
            }
        });
    }

    @Override
    public Future<CreateEvaluationResult> createEvaluationAsync(final CreateEvaluationRequest createEvaluationRequest, final AsyncHandler<CreateEvaluationRequest, CreateEvaluationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateEvaluationResult>(){

            @Override
            public CreateEvaluationResult call() throws Exception {
                CreateEvaluationResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createEvaluation(createEvaluationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createEvaluationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRealtimeEndpointResult> deleteRealtimeEndpointAsync(final DeleteRealtimeEndpointRequest deleteRealtimeEndpointRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteRealtimeEndpointResult>(){

            @Override
            public DeleteRealtimeEndpointResult call() throws Exception {
                return AmazonMachineLearningAsyncClient.this.deleteRealtimeEndpoint(deleteRealtimeEndpointRequest);
            }
        });
    }

    @Override
    public Future<DeleteRealtimeEndpointResult> deleteRealtimeEndpointAsync(final DeleteRealtimeEndpointRequest deleteRealtimeEndpointRequest, final AsyncHandler<DeleteRealtimeEndpointRequest, DeleteRealtimeEndpointResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteRealtimeEndpointResult>(){

            @Override
            public DeleteRealtimeEndpointResult call() throws Exception {
                DeleteRealtimeEndpointResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteRealtimeEndpoint(deleteRealtimeEndpointRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteRealtimeEndpointRequest, result);
                return result;
            }
        });
    }
}

