/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtils;

public class ChangeParameterMetaData {
    public static final String COMPUTE = "COMPUTE";
    private Change change;
    private String parameterName;
    private String description;
    private String exampleValue;
    private String displayName;
    private String dataType;
    private String since;
    private Set<String> requiredForDatabase;
    private Set<String> supportedDatabases;
    private String mustEqualExisting;
    private LiquibaseSerializable.SerializationType serializationType;

    public ChangeParameterMetaData(Change change, String parameterName, String displayName, String description, String exampleValue, String since, Type dataType, String[] requiredForDatabase, String[] supportedDatabases, String mustEqualExisting, LiquibaseSerializable.SerializationType serializationType) {
        if (parameterName == null) {
            throw new UnexpectedLiquibaseException("Unexpected null parameterName");
        }
        if (parameterName.contains(" ")) {
            throw new UnexpectedLiquibaseException("Unexpected space in parameterName");
        }
        if (displayName == null) {
            throw new UnexpectedLiquibaseException("Unexpected null displayName");
        }
        if (dataType == null) {
            throw new UnexpectedLiquibaseException("Unexpected null dataType");
        }
        this.change = change;
        this.parameterName = parameterName;
        this.displayName = displayName;
        this.description = description;
        this.exampleValue = exampleValue;
        if (dataType instanceof Class) {
            this.dataType = StringUtils.lowerCaseFirst(((Class)dataType).getSimpleName());
        } else if (dataType instanceof ParameterizedType) {
            this.dataType = StringUtils.lowerCaseFirst(((Class)((ParameterizedType)dataType).getRawType()).getSimpleName() + " of " + StringUtils.lowerCaseFirst(((Class)((ParameterizedType)dataType).getActualTypeArguments()[0]).getSimpleName()));
        }
        this.mustEqualExisting = mustEqualExisting;
        this.serializationType = serializationType;
        this.since = since;
        this.supportedDatabases = Collections.unmodifiableSet(this.analyzeSupportedDatabases(supportedDatabases));
        this.requiredForDatabase = Collections.unmodifiableSet(this.analyzeRequiredDatabases(requiredForDatabase));
    }

    protected Set<String> analyzeSupportedDatabases(String[] supportedDatabases) {
        if (supportedDatabases == null) {
            supportedDatabases = new String[]{COMPUTE};
        }
        HashSet<String> computedDatabases = new HashSet<String>();
        if (supportedDatabases.length == 1 && StringUtils.join(supportedDatabases, ",").equals(COMPUTE)) {
            int validDatabases = 0;
            for (Database database : DatabaseFactory.getInstance().getImplementedDatabases()) {
                if (database.getShortName() == null || database.getShortName().equals("unsupported") || !this.change.supports(database)) continue;
                try {
                    if (this.change.generateStatementsVolatile(database)) continue;
                    Change testChange = (Change)this.change.getClass().newInstance();
                    ValidationErrors originalErrors = this.getStatementErrors(testChange, database);
                    this.setValue(testChange, this.getExampleValue());
                    ValidationErrors finalErrors = this.getStatementErrors(testChange, database);
                    if (finalErrors.getUnsupportedErrorMessages().size() == 0 || finalErrors.getUnsupportedErrorMessages().size() == originalErrors.getUnsupportedErrorMessages().size()) {
                        computedDatabases.add(database.getShortName());
                    }
                    ++validDatabases;
                }
                catch (Exception exception) {}
            }
            if (validDatabases == 0) {
                return new HashSet<String>(Arrays.asList("all"));
            }
            if (computedDatabases.size() == validDatabases) {
                computedDatabases = new HashSet<String>(Arrays.asList("all"));
            }
            computedDatabases.remove("none");
            return computedDatabases;
        }
        return new HashSet<String>(Arrays.asList(supportedDatabases));
    }

    protected Set<String> analyzeRequiredDatabases(String[] requiredDatabases) {
        if (requiredDatabases == null) {
            requiredDatabases = new String[]{COMPUTE};
        }
        HashSet<Object> computedDatabases = new HashSet();
        if (requiredDatabases.length == 1 && StringUtils.join(requiredDatabases, ",").equals(COMPUTE)) {
            int validDatabases = 0;
            for (Database database : DatabaseFactory.getInstance().getImplementedDatabases()) {
                try {
                    if (this.change.generateStatementsVolatile(database)) continue;
                    Change testChange = (Change)this.change.getClass().newInstance();
                    ValidationErrors originalErrors = this.getStatementErrors(testChange, database);
                    this.setValue(testChange, this.getExampleValue());
                    ValidationErrors finalErrors = this.getStatementErrors(testChange, database);
                    if (originalErrors.getRequiredErrorMessages().size() > 0 && finalErrors.getRequiredErrorMessages().size() < originalErrors.getRequiredErrorMessages().size()) {
                        computedDatabases.add(database.getShortName());
                    }
                    ++validDatabases;
                }
                catch (Exception exception) {}
            }
            if (validDatabases == 0) {
                return new HashSet<String>();
            }
            if (computedDatabases.size() == validDatabases) {
                computedDatabases = new HashSet<String>(Arrays.asList("all"));
            }
            computedDatabases.remove("none");
        } else {
            computedDatabases = new HashSet<String>(Arrays.asList(requiredDatabases));
        }
        computedDatabases.remove("none");
        return computedDatabases;
    }

    private ValidationErrors getStatementErrors(Change testChange, Database database) {
        SqlStatement[] statements;
        ValidationErrors errors = new ValidationErrors();
        for (SqlStatement statement : statements = testChange.generateStatements(database)) {
            errors.addAll(SqlGeneratorFactory.getInstance().validate(statement, database));
        }
        return errors;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSince() {
        return this.since;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Set<String> getRequiredForDatabase() {
        return this.requiredForDatabase;
    }

    public Set<String> getSupportedDatabases() {
        return this.supportedDatabases;
    }

    public boolean isRequiredFor(Database database) {
        return this.requiredForDatabase.contains("all") || this.requiredForDatabase.contains(database.getShortName());
    }

    public boolean supports(Database database) {
        return this.supportedDatabases.contains("all") || this.supportedDatabases.contains(database.getShortName());
    }

    public Object getCurrentValue(Change change) {
        try {
            for (PropertyDescriptor descriptor : Introspector.getBeanInfo(change.getClass()).getPropertyDescriptors()) {
                if (!descriptor.getDisplayName().equals(this.parameterName)) continue;
                Method readMethod = descriptor.getReadMethod();
                if (readMethod == null) {
                    readMethod = change.getClass().getMethod("is" + StringUtils.upperCaseFirst(descriptor.getName()), new Class[0]);
                }
                return readMethod.invoke((Object)change, new Object[0]);
            }
            throw new RuntimeException("Could not find readMethod for " + this.parameterName);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public void setValue(Change change, Object value) {
        block12: {
            if (value instanceof String && !this.dataType.equals("string")) {
                try {
                    if (this.dataType.equals("bigInteger")) {
                        value = new BigInteger((String)value);
                        break block12;
                    }
                    if (this.dataType.equals("databaseFunction")) {
                        value = new DatabaseFunction((String)value);
                        break block12;
                    }
                    throw new UnexpectedLiquibaseException("Unknown Data Type: " + this.dataType);
                }
                catch (Throwable e) {
                    throw new UnexpectedLiquibaseException("Cannot convert string value '" + value + "' to " + this.dataType + ": " + e.getMessage());
                }
            }
        }
        try {
            for (PropertyDescriptor descriptor : Introspector.getBeanInfo(change.getClass()).getPropertyDescriptors()) {
                if (!descriptor.getDisplayName().equals(this.parameterName)) continue;
                Method writeMethod = descriptor.getWriteMethod();
                if (writeMethod == null) {
                    throw new UnexpectedLiquibaseException("Could not find writeMethod for " + this.parameterName);
                }
                Class<?> expectedWriteType = writeMethod.getParameterTypes()[0];
                if (value != null && !expectedWriteType.isAssignableFrom(value.getClass())) {
                    if (expectedWriteType.equals(String.class)) {
                        value = value.toString();
                    } else {
                        throw new UnexpectedLiquibaseException("Could not convert " + value.getClass().getName() + " to " + expectedWriteType.getName());
                    }
                }
                writeMethod.invoke((Object)change, value);
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException("Error setting " + this.parameterName + " to " + value, e);
        }
    }

    public String getMustEqualExisting() {
        return this.mustEqualExisting;
    }

    public LiquibaseSerializable.SerializationType getSerializationType() {
        return this.serializationType;
    }

    public Object getExampleValue() {
        ArrayList<ColumnConfig> list;
        if (this.exampleValue != null) {
            return this.exampleValue;
        }
        HashMap<String, String> standardExamples = new HashMap<String, String>();
        standardExamples.put("tableName", "person");
        standardExamples.put("schemaName", "public");
        standardExamples.put("catalogName", "cat");
        standardExamples.put("columnName", "id");
        standardExamples.put("columnNames", "id, name");
        standardExamples.put("indexName", "idx_address");
        standardExamples.put("columnDataType", "int");
        standardExamples.put("dataType", "int");
        standardExamples.put("sequenceName", "seq_id");
        standardExamples.put("viewName", "v_person");
        standardExamples.put("constraintName", "const_name");
        standardExamples.put("primaryKey", "pk_id");
        if (standardExamples.containsKey(this.parameterName)) {
            return standardExamples.get(this.parameterName);
        }
        for (String prefix : new String[]{"base", "new", "old"}) {
            String mainName;
            if (!this.parameterName.startsWith(prefix) || !standardExamples.containsKey(mainName = StringUtils.lowerCaseFirst(this.parameterName.replaceFirst("^" + prefix, "")))) continue;
            return standardExamples.get(mainName);
        }
        if (this.dataType.equals("string")) {
            return "A String";
        }
        if (this.dataType.equals("integer")) {
            return 3;
        }
        if (this.dataType.equals("boolean")) {
            return true;
        }
        if (this.dataType.equals("bigInteger")) {
            return new BigInteger("371717");
        }
        if (this.dataType.equals("list")) {
            return null;
        }
        if (this.dataType.equals("sequenceNextValueFunction")) {
            return new SequenceNextValueFunction("seq_name");
        }
        if (this.dataType.equals("databaseFunction")) {
            return new DatabaseFunction("now");
        }
        if (this.dataType.equals("list of columnConfig")) {
            list = new ArrayList<ColumnConfig>();
            list.add(new ColumnConfig().setName("id").setType("int"));
            return list;
        }
        if (this.dataType.equals("list of loadDataColumnConfig")) {
            list = new ArrayList();
            list.add(new LoadDataColumnConfig().setName("id").setType("int"));
            return list;
        }
        throw new UnexpectedLiquibaseException("Unknown dataType " + this.dataType + " for " + this.getParameterName());
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        HashMap<String, String> standardDescriptions = new HashMap<String, String>();
        standardDescriptions.put("tableName", "Name of the table");
        standardDescriptions.put("schemaName", "Name of the schema");
        standardDescriptions.put("catalogName", "Name of the catalog");
        standardDescriptions.put("columnName", "Name of the column");
        return StringUtils.trimToEmpty((String)standardDescriptions.get(this.parameterName));
    }
}

