/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.magicwerk.brownies.collections.BigList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.helper.NaturalComparator;
import org.magicwerk.brownies.collections.primitive.LongBigList;

public class LongObjBigList
extends IList<Long> {
    LongBigList list;

    static Long[] toWrapper(long[] elems) {
        Long[] e = new Long[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static long[] toPrimitive(Long[] elems) {
        long[] e = new long[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static long[] toPrimitive(BigList<? extends Long> list2) {
        long[] e = new long[list2.size()];
        for (int i = 0; i < e.length; ++i) {
            e[i] = (Long)list2.get(i);
        }
        return e;
    }

    static long[] toPrimitive(Collection<? extends Long> list) {
        long[] e = new long[list.size()];
        Iterator<? extends Long> iter = list.iterator();
        for (int i = 0; i < e.length; ++i) {
            e[i] = iter.next();
        }
        return e;
    }

    public static LongObjBigList create() {
        return new LongObjBigList();
    }

    public static LongObjBigList create(Long ... elems) {
        LongObjBigList list = new LongObjBigList();
        list.init(elems);
        return list;
    }

    public static LongObjBigList create(Collection<? extends Long> elems) {
        return new LongObjBigList(elems);
    }

    public LongObjBigList() {
        this.init();
    }

    public void init() {
        this.list = new LongBigList();
    }

    public LongObjBigList(int capacity) {
        this.list = new LongBigList(capacity);
    }

    public void init(Long ... elems) {
        this.list = LongBigList.create(LongObjBigList.toPrimitive(elems));
    }

    public LongObjBigList(Collection<? extends Long> elems) {
        this.init(elems);
    }

    public void init(Collection<? extends Long> elems) {
        this.list = LongBigList.create(LongObjBigList.toPrimitive(elems));
    }

    @Override
    protected void doClone(IList<Long> that) {
        this.list = (LongBigList)((LongObjBigList)that).list.clone();
    }

    @Override
    protected void doAssign(IList<Long> that) {
        LongObjBigList list = (LongObjBigList)that;
        this.list = list.list;
    }

    public LongObjBigList copy() {
        return (LongObjBigList)this.clone();
    }

    @Override
    public Long getDefaultElem() {
        return this.list.getDefaultElem();
    }

    @Override
    public IList<Long> doCreate(int capacity) {
        return new LongObjBigList();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int capacity() {
        return this.list.capacity();
    }

    @Override
    public Long get(int index) {
        return this.list.get(index);
    }

    @Override
    protected Long doGet(int index) {
        return this.list.doGet(index);
    }

    @Override
    protected void doGetAll(Object[] elems, int index, int len) {
        this.list.doGetAll(LongObjBigList.toPrimitive((Long[])elems), index, len);
    }

    @Override
    protected boolean doAdd(int index, Long elem) {
        return this.list.doAdd(index, elem);
    }

    @Override
    protected Long doSet(int index, Long elem) {
        return this.list.doSet(index, elem);
    }

    @Override
    protected Long doRemove(int index) {
        return this.list.doRemove(index);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        this.list.doRemoveAll(index, len);
    }

    @Override
    protected Long doReSet(int index, Long elem) {
        return this.list.doReSet(index, elem);
    }

    @Override
    public void move(int srcIndex, int dstIndex, int len) {
        this.list.move(srcIndex, dstIndex, len);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        this.list.doEnsureCapacity(minCapacity);
    }

    @Override
    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.list.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return -1;
        }
        return this.list.indexOf((Long)elem);
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return -1;
        }
        return this.list.lastIndexOf((Long)elem);
    }

    @Override
    public boolean remove(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return false;
        }
        int index = this.list.indexOf((Long)elem);
        if (index == -1) {
            return false;
        }
        this.list.remove(index);
        return true;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return false;
        }
        return this.list.contains((Long)elem);
    }

    @Override
    public boolean containsAny(Collection<?> coll) {
        return this.list.containsAny(coll);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean removeAll(IList<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public boolean retainAll(IList<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(0, this.size());
    }

    @Override
    public Object[] toArray(int index, int len) {
        Object[] elems = new Object[len];
        for (int i = 0; i < len; ++i) {
            elems[i] = this.list.get(i);
        }
        return elems;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.list.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        for (int i = 0; i < size; ++i) {
            array[i] = this.list.get(i);
        }
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    @Override
    public boolean addAll(Collection<? extends Long> coll) {
        return this.list.addAll(coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> coll) {
        return this.list.addAll(index, coll);
    }

    public boolean addArray(Long ... elems) {
        long[] e = LongObjBigList.toPrimitive(elems);
        return this.list.addArray(e);
    }

    public boolean addArray(int index, Long ... elems) {
        long[] e = LongObjBigList.toPrimitive(elems);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean addAll(IList<? extends Long> list2) {
        long[] e = LongObjBigList.toPrimitive(list2);
        return this.list.addArray(e);
    }

    @Override
    public boolean addAll(int index, IList<? extends Long> list2) {
        long[] e = LongObjBigList.toPrimitive(list2);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean removeFirstOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return false;
        }
        return this.list.removeFirstOccurrence((Long)elem);
    }

    @Override
    public boolean removeLastOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return false;
        }
        return this.list.removeLastOccurrence((Long)elem);
    }

    @Override
    public BigList<Long> getAll(int index, int len) {
        long[] elems = this.list.getArray(index, len);
        return BigList.create(LongObjBigList.toWrapper(elems));
    }

    public Long[] getArray(int index, int len) {
        long[] elems = this.list.getArray(index, len);
        return LongObjBigList.toWrapper(elems);
    }

    @Override
    public void setAll(int index, IList<? extends Long> list2) {
        long[] e = LongObjBigList.toPrimitive(list2);
        this.list.setArray(index, e);
    }

    @Override
    public void setAll(int index, Collection<? extends Long> coll) {
        long[] e = LongObjBigList.toPrimitive(coll);
        this.list.setArray(index, e);
    }

    public void setArray(int index, Long ... elems) {
        long[] e = LongObjBigList.toPrimitive(elems);
        this.list.setArray(index, e);
    }

    @Override
    public void sort(int index, int len, Comparator comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        this.list.sort(index, len);
    }

    @Override
    public <K> int binarySearch(int index, int len, K key, Comparator<? super K> comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        return this.list.binarySearch(index, len, (Long)key);
    }

    public LongObjBigList unmodifiableList() {
        return new ImmutableLongObjBigList(this);
    }

    protected static class ImmutableLongObjBigList
    extends LongObjBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableLongObjBigList(LongObjBigList that) {
            super(that);
        }

        @Override
        protected boolean doAdd(int index, Long elem) {
            this.error();
            return false;
        }

        @Override
        protected Long doSet(int index, Long elem) {
            this.error();
            return null;
        }

        @Override
        protected Long doReSet(int index, Long elem) {
            this.error();
            return null;
        }

        @Override
        protected Long doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }
}

