/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.magicwerk.brownies.collections.helper.primitive.LongBinarySearch;
import org.magicwerk.brownies.collections.helper.primitive.LongMergeSort;
import org.magicwerk.brownies.collections.primitive.ILongList;
import org.magicwerk.brownies.collections.primitive.LongGapList;

public class LongBigList
extends ILongList {
    private static final long serialVersionUID = 3715838828540564836L;
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private static final float MERGE_THRESHOLD = 0.35f;
    private static final float FILL_THRESHOLD = 0.95f;
    private static final boolean CHECK = false;
    private static final LongBigList EMPTY = LongBigList.create().unmodifiableList();
    private int blockSize;
    private int size;
    private LongBlockNode rootNode;
    private LongBlockNode currNode;
    private int currLongBlockStart;
    private int currLongBlockEnd;
    private int currModify;

    public static ILongList of(long[] values) {
        return new ImmutableLongListArrayPrimitive(values);
    }

    public static ILongList of(Long[] values) {
        return new ImmutableLongListArrayWrapper(values);
    }

    public static ILongList of(List<Long> values) {
        return new ImmutableLongListList(values);
    }

    public static LongBigList EMPTY() {
        return EMPTY;
    }

    protected LongBigList(boolean copy, LongBigList that) {
        if (copy) {
            this.blockSize = that.blockSize;
            this.currLongBlockStart = that.currLongBlockStart;
            this.currLongBlockEnd = that.currLongBlockEnd;
            this.currNode = that.currNode;
            this.rootNode = that.rootNode;
            this.size = that.size;
        }
    }

    public static LongBigList create() {
        return new LongBigList();
    }

    public static LongBigList create(Collection<Long> coll) {
        return new LongBigList(coll);
    }

    public static LongBigList create(long ... elems) {
        LongBigList list = new LongBigList();
        for (long elem : elems) {
            list.add(elem);
        }
        return list;
    }

    public LongBigList() {
        this(1000);
    }

    public LongBigList(int blockSize) {
        if (blockSize < 2) {
            throw new IndexOutOfBoundsException("Invalid blockSize: " + blockSize);
        }
        this.doInit(blockSize, -1);
    }

    public LongBigList(Collection<Long> coll) {
        if (coll instanceof LongBigList) {
            this.doAssign((LongBigList)((Object)coll));
            this.doClone((LongBigList)((Object)coll));
        } else {
            this.blockSize = 1000;
            this.addLongBlock(0, new LongBlock());
            for (Object obj : coll.toArray()) {
                this.add((Long)obj);
            }
            assert (this.size() == coll.size());
        }
    }

    public int blockSize() {
        return this.blockSize;
    }

    private LongBigList(int blockSize, int firstLongBlockSize) {
        this.doInit(blockSize, firstLongBlockSize);
    }

    private void doInit(int blockSize, int firstLongBlockSize) {
        this.blockSize = blockSize;
        LongBlock block = firstLongBlockSize <= 1 ? new LongBlock() : new LongBlock(firstLongBlockSize);
        this.addLongBlock(0, block);
    }

    @Override
    public LongBigList copy() {
        return (LongBigList)super.copy();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    protected void doAssign(ILongList that) {
        LongBigList list = (LongBigList)that;
        this.blockSize = list.blockSize;
        this.currLongBlockEnd = list.currLongBlockEnd;
        this.currLongBlockStart = list.currLongBlockStart;
        this.currNode = list.currNode;
        this.rootNode = list.rootNode;
        this.size = list.size;
    }

    @Override
    protected void doClone(ILongList that) {
        LongBigList bigList = (LongBigList)that;
        bigList.releaseLongBlock();
        this.rootNode = this.copy(bigList.rootNode);
        this.currNode = null;
        this.currModify = 0;
    }

    private LongBlockNode copy(LongBlockNode node) {
        LongBlockNode newNode = node.min();
        int index = newNode.block.size();
        LongBlockNode newRoot = new LongBlockNode(null, index, newNode.block.ref(), null, null);
        while ((newNode = newNode.next()) != null) {
            newRoot = newRoot.insert(index += newNode.block.size(), newNode.block.ref());
            newRoot.parent = null;
        }
        return newRoot;
    }

    @Override
    public long getDefaultElem() {
        return 0L;
    }

    protected void finalize() {
        LongBlockNode node = this.rootNode.min();
        while (node != null) {
            node.block.unref();
            node = node.next();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    protected long doGet(int index) {
        int pos = this.getLongBlockIndex(index, false, 0);
        return this.currNode.block.doGet(pos);
    }

    @Override
    protected long doSet(int index, long elem) {
        int pos = this.getLongBlockIndex(index, true, 0);
        long oldElem = this.currNode.block.doGet(pos);
        this.currNode.block.doSet(pos, elem);
        return oldElem;
    }

    @Override
    protected long doReSet(int index, long elem) {
        int pos = this.getLongBlockIndex(index, true, 0);
        long oldElem = this.currNode.block.doGet(pos);
        this.currNode.block.doSet(pos, elem);
        return oldElem;
    }

    private void releaseLongBlock() {
        if (this.currModify != 0) {
            int modify = this.currModify;
            this.currModify = 0;
            this.modify(this.currNode, modify);
        }
        this.currNode = null;
    }

    private int getLongBlockIndex(int index, boolean write, int modify) {
        if (this.currNode != null) {
            if (index >= this.currLongBlockStart && (index < this.currLongBlockEnd || index == this.currLongBlockEnd && this.size == index)) {
                if (write && this.currNode.block.isShared()) {
                    this.currNode.block.unref();
                    this.currNode.setLongBlock(new LongBlock(this.currNode.block));
                }
                this.currModify += modify;
                return index - this.currLongBlockStart;
            }
            this.releaseLongBlock();
        }
        if (index == this.size) {
            if (this.currNode == null || this.currLongBlockEnd != this.size) {
                this.currNode = this.rootNode.max();
                this.currLongBlockEnd = this.size;
                this.currLongBlockStart = this.size - this.currNode.block.size();
            }
            if (modify != 0) {
                this.currNode.relPos += modify;
                LongBlockNode leftNode = this.currNode.getLeftSubTree();
                if (leftNode != null) {
                    leftNode.relPos -= modify;
                }
            }
        } else if (index == 0) {
            if (this.currNode == null || this.currLongBlockStart != 0) {
                this.currNode = this.rootNode.min();
                this.currLongBlockEnd = this.currNode.block.size();
                this.currLongBlockStart = 0;
            }
            if (modify != 0) {
                this.rootNode.relPos += modify;
            }
        }
        if (this.currNode == null) {
            this.doGetLongBlock(index, modify);
        }
        assert (index >= this.currLongBlockStart && index <= this.currLongBlockEnd);
        if (write && this.currNode.block.isShared()) {
            this.currNode.block.unref();
            this.currNode.setLongBlock(new LongBlock(this.currNode.block));
        }
        return index - this.currLongBlockStart;
    }

    private boolean isOnlyRootLongBlock() {
        return this.rootNode.left == null && this.rootNode.right == null;
    }

    private void doGetLongBlock(int index, int modify) {
        this.currNode = this.rootNode;
        this.currLongBlockEnd = this.rootNode.relPos;
        if (this.currNode.relPos == 0) {
            if (modify != 0) {
                this.currNode.relPos += modify;
            }
        } else {
            boolean wasLeft = false;
            while (true) {
                LongBlockNode nextNode;
                assert (index >= 0);
                int leftIndex = this.currLongBlockEnd - this.currNode.block.size();
                assert (leftIndex >= 0);
                if (index >= leftIndex && index < this.currLongBlockEnd) {
                    if (modify == 0) break;
                    LongBlockNode leftNode = this.currNode.getLeftSubTree();
                    if (this.currNode.relPos > 0) {
                        this.currNode.relPos += modify;
                        if (leftNode == null) break;
                        leftNode.relPos -= modify;
                        break;
                    }
                    if (leftNode == null) break;
                    leftNode.relPos -= modify;
                    break;
                }
                if (index < this.currLongBlockEnd) {
                    nextNode = this.currNode.getLeftSubTree();
                    if (!(modify == 0 || nextNode != null && wasLeft)) {
                        this.currNode.relPos = this.currNode.relPos > 0 ? (this.currNode.relPos += modify) : (this.currNode.relPos -= modify);
                        wasLeft = true;
                    }
                    if (nextNode == null) {
                        break;
                    }
                } else {
                    nextNode = this.currNode.getRightSubTree();
                    if (modify != 0 && (nextNode == null || wasLeft)) {
                        if (this.currNode.relPos > 0) {
                            this.currNode.relPos += modify;
                            LongBlockNode left = this.currNode.getLeftSubTree();
                            if (left != null) {
                                left.relPos -= modify;
                            }
                        } else {
                            this.currNode.relPos -= modify;
                        }
                        wasLeft = false;
                    }
                    if (nextNode == null) break;
                }
                this.currLongBlockEnd += nextNode.relPos;
                this.currNode = nextNode;
            }
        }
        this.currLongBlockStart = this.currLongBlockEnd - this.currNode.block.size();
    }

    private void addLongBlock(int index, LongBlock obj) {
        if (this.rootNode == null) {
            this.rootNode = new LongBlockNode(null, index, obj, null, null);
        } else {
            this.rootNode = this.rootNode.insert(index, obj);
            this.rootNode.parent = null;
        }
    }

    @Override
    protected boolean doAdd(int index, long element) {
        int maxSize;
        if (index == -1) {
            index = this.size;
        }
        int pos = this.getLongBlockIndex(index, true, 1);
        int n = maxSize = index == this.size || index == 0 ? (int)((float)this.blockSize * 0.95f) : this.blockSize;
        if (this.currNode.block.size() < maxSize || this.currNode.block.size() == 1 && this.currNode.block.size() < this.blockSize) {
            this.currNode.block.doAdd(pos, element);
            ++this.currLongBlockEnd;
        } else {
            LongBlock newLongBlock = new LongBlock(this.blockSize);
            if (index == this.size) {
                LongBlockNode lastNode;
                newLongBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addLongBlock(this.size + 1, newLongBlock);
                this.currNode = lastNode = this.currNode.next();
                this.currLongBlockStart = this.currLongBlockEnd++;
            } else if (index == 0) {
                LongBlockNode firstNode;
                newLongBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addLongBlock(1, newLongBlock);
                this.currNode = firstNode = this.currNode.previous();
                this.currLongBlockStart = 0;
                this.currLongBlockEnd = 1;
            } else {
                int nextLongBlockLen = this.blockSize / 2;
                int blockLen = this.blockSize - nextLongBlockLen;
                LongGapList.transferRemove(this.currNode.block, blockLen, nextLongBlockLen, newLongBlock, 0, 0);
                this.modify(this.currNode, -nextLongBlockLen - 1);
                this.addLongBlock(this.currLongBlockEnd - nextLongBlockLen, newLongBlock);
                if (pos < blockLen) {
                    this.currNode.block.doAdd(pos, element);
                    this.currLongBlockEnd = this.currLongBlockStart + blockLen + 1;
                    this.modify(this.currNode, 1);
                } else {
                    this.currNode = this.currNode.next();
                    this.modify(this.currNode, 1);
                    this.currNode.block.doAdd(pos - blockLen, element);
                    this.currLongBlockStart += blockLen;
                    ++this.currLongBlockEnd;
                }
            }
        }
        ++this.size;
        return true;
    }

    private void modify(LongBlockNode node, int modify) {
        if (node == this.currNode) {
            modify += this.currModify;
            this.currModify = 0;
        } else {
            this.releaseLongBlock();
        }
        if (modify == 0) {
            return;
        }
        if (node.relPos < 0) {
            LongBlockNode p;
            LongBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            LongBlockNode pp = node.parent;
            assert (pp.getLeftSubTree() == node);
            boolean parentRight = true;
            while ((p = pp.parent) != null) {
                boolean pRight;
                boolean bl = pRight = p.getLeftSubTree() == pp;
                if (parentRight != pRight) {
                    pp.relPos = pp.relPos > 0 ? (pp.relPos += modify) : (pp.relPos -= modify);
                }
                pp = p;
                parentRight = pRight;
            }
            if (parentRight) {
                this.rootNode.relPos += modify;
            }
        } else {
            LongBlockNode parent;
            node.relPos += modify;
            LongBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            if ((parent = node.parent) != null) {
                LongBlockNode p;
                assert (parent.getRightSubTree() == node);
                boolean parentLeft = true;
                while ((p = parent.parent) != null) {
                    boolean pLeft;
                    boolean bl = pLeft = p.getRightSubTree() == parent;
                    if (parentLeft != pLeft) {
                        parent.relPos = parent.relPos > 0 ? (parent.relPos += modify) : (parent.relPos -= modify);
                    }
                    parent = p;
                    parentLeft = pLeft;
                }
                if (!parentLeft) {
                    this.rootNode.relPos += modify;
                }
            }
        }
    }

    private LongBlockNode doRemove(LongBlockNode node) {
        LongBlockNode newNode;
        LongBlockNode p = node.parent;
        LongBlockNode n = newNode = node.removeSelf();
        while (p != null) {
            assert (p.left == node || p.right == node);
            if (p.left == node) {
                p.left = newNode;
            } else {
                p.right = newNode;
            }
            node = p;
            node.recalcHeight();
            newNode = node.balance();
            p = newNode.parent;
        }
        this.rootNode = newNode;
        return n;
    }

    @Override
    protected boolean doAddAll(int index, ILongList list) {
        if (list.size() == 0) {
            return false;
        }
        if (index == -1) {
            index = this.size;
        }
        int oldSize = this.size;
        if (list.size() == 1) {
            return this.doAdd(index, list.get(0));
        }
        int addPos = this.getLongBlockIndex(index, true, 0);
        LongBlock addLongBlock = this.currNode.block;
        int space = this.blockSize - addLongBlock.size();
        int addLen = list.size();
        if (addLen <= space) {
            this.currNode.block.addAll(addPos, list);
            this.modify(this.currNode, addLen);
            this.size += addLen;
            this.currLongBlockEnd += addLen;
        } else if (index == this.size) {
            int add;
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list.get(i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                LongBlock nextLongBlock = new LongBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextLongBlock.add(i, list.get(done + i));
                }
                this.addLongBlock(this.size + (done += add), nextLongBlock);
                this.currNode = this.currNode.next();
            }
            this.size += addLen;
            this.currLongBlockEnd = this.size;
            this.currLongBlockStart = this.currLongBlockEnd - this.currNode.block.size();
        } else if (index == 0) {
            int add;
            assert (addPos == 0);
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list.get(addLen - space + i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                LongBlock nextLongBlock = new LongBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextLongBlock.add(i, list.get(addLen - done - add + i));
                }
                done += add;
                this.addLongBlock(0, nextLongBlock);
                this.currNode = this.currNode.previous();
            }
            this.size += addLen;
            this.currLongBlockStart = 0;
            this.currLongBlockEnd = this.currNode.block.size();
        } else {
            LongGapList sublist;
            int add;
            LongGapList list2 = LongGapList.create();
            list2.addAll(list);
            int remove = this.currNode.block.size() - addPos;
            if (remove > 0) {
                list2.addAll(this.currNode.block.getAll(addPos, remove));
                this.currNode.block.remove(addPos, remove);
                this.modify(this.currNode, -remove);
                this.size -= remove;
                this.currLongBlockEnd -= remove;
            }
            int numElems = this.currNode.block.size() + list2.size();
            int numLongBlocks = (numElems - 1) / this.blockSize + 1;
            assert (numLongBlocks > 1);
            int has = this.currNode.block.size();
            int should = numElems / numLongBlocks;
            int listPos = 0;
            if (has < should) {
                add = should - has;
                sublist = list2.getAll(0, add);
                listPos += add;
                this.currNode.block.addAll(addPos, sublist);
                this.modify(this.currNode, add);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                --numLongBlocks;
                this.size += add;
                this.currLongBlockEnd += add;
            } else if (has > should) {
                LongBlock nextLongBlock = new LongBlock(this.blockSize);
                int move = has - should;
                nextLongBlock.addAll(this.currNode.block.getAll(this.currNode.block.size() - move, move));
                this.currNode.block.remove(this.currNode.block.size() - move, move);
                this.modify(this.currNode, -move);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                this.currLongBlockEnd -= move;
                should = numElems / --numLongBlocks;
                int add2 = should - move;
                assert (add2 >= 0);
                LongGapList sublist2 = list2.getAll(0, add2);
                nextLongBlock.addAll(move, sublist2);
                listPos += add2;
                assert (nextLongBlock.size() == should);
                numElems -= should;
                --numLongBlocks;
                this.size += add2;
                this.addLongBlock(this.currLongBlockEnd, nextLongBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextLongBlock);
                assert (this.currNode.block.size() == add2 + move);
                this.currLongBlockStart = this.currLongBlockEnd;
                this.currLongBlockEnd += add2 + move;
            } else {
                numElems -= should;
                --numLongBlocks;
            }
            while (numLongBlocks > 0) {
                add = numElems / numLongBlocks;
                assert (add > 0);
                sublist = list2.getAll(listPos, add);
                listPos += add;
                LongBlock nextLongBlock = new LongBlock();
                nextLongBlock.addAll(sublist);
                assert (nextLongBlock.size() == add);
                numElems -= add;
                this.addLongBlock(this.currLongBlockEnd, nextLongBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextLongBlock);
                assert (this.currNode.block.size() == add);
                this.currLongBlockStart = this.currLongBlockEnd;
                this.currLongBlockEnd += add;
                this.size += add;
                --numLongBlocks;
            }
        }
        assert (oldSize + addLen == this.size);
        return true;
    }

    @Override
    protected void doClear() {
        this.rootNode = null;
        this.currLongBlockStart = 0;
        this.currLongBlockEnd = 0;
        this.currModify = 0;
        this.currNode = null;
        this.size = 0;
        this.doInit(this.blockSize, 0);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        if (len == 0) {
            return;
        }
        if (index == 0 && len == this.size) {
            this.doClear();
            return;
        }
        if (len == 1) {
            this.doRemove(index);
            return;
        }
        int startPos = this.getLongBlockIndex(index, true, 0);
        LongBlockNode startNode = this.currNode;
        int endPos = this.getLongBlockIndex(index + len - 1, true, 0);
        LongBlockNode endNode = this.currNode;
        if (startNode == endNode) {
            this.getLongBlockIndex(index, true, -len);
            this.currNode.block.remove(startPos, len);
            if (this.currNode.block.isEmpty()) {
                LongBlockNode oldCurrNode = this.currNode;
                this.releaseLongBlock();
                LongBlockNode node = this.doRemove(oldCurrNode);
                this.merge(node);
            } else {
                this.currLongBlockEnd -= len;
                this.merge(this.currNode);
            }
            this.size -= len;
        } else {
            int startLen = startNode.block.size() - startPos;
            this.getLongBlockIndex(index, true, -startLen);
            startNode.block.remove(startPos, startLen);
            assert (startNode == this.currNode);
            if (this.currNode.block.isEmpty()) {
                this.releaseLongBlock();
                this.doRemove(startNode);
                startNode = null;
            }
            len -= startLen;
            this.size -= startLen;
            while (len > 0) {
                this.currNode = null;
                this.getLongBlockIndex(index, true, 0);
                int s = this.currNode.block.size();
                if (s <= len) {
                    this.modify(this.currNode, -s);
                    LongBlockNode oldCurrNode = this.currNode;
                    this.releaseLongBlock();
                    this.doRemove(oldCurrNode);
                    if (oldCurrNode == endNode) {
                        endNode = null;
                    }
                    len -= s;
                    this.size -= s;
                    continue;
                }
                this.modify(this.currNode, -len);
                this.currNode.block.remove(0, len);
                this.size -= len;
                break;
            }
            this.releaseLongBlock();
            this.getLongBlockIndex(index, false, 0);
            this.merge(this.currNode);
        }
    }

    private void merge(LongBlockNode node) {
        if (node == null) {
            return;
        }
        int minLongBlockSize = Math.max((int)((float)this.blockSize * 0.35f), 1);
        if (node.block.size() >= minLongBlockSize) {
            return;
        }
        LongBlockNode oldCurrNode = node;
        LongBlockNode leftNode = node.previous();
        if (leftNode != null && leftNode.block.size() < minLongBlockSize) {
            int len = node.block.size();
            int dstSize = leftNode.getLongBlock().size();
            for (int i = 0; i < len; ++i) {
                leftNode.block.add(0L);
            }
            LongGapList.transferCopy(node.block, 0, len, leftNode.block, dstSize, len);
            assert (leftNode.block.size() <= this.blockSize);
            this.modify(leftNode, len);
            this.modify(oldCurrNode, -len);
            this.releaseLongBlock();
            this.doRemove(oldCurrNode);
        } else {
            LongBlockNode rightNode = node.next();
            if (rightNode != null && rightNode.block.size() < minLongBlockSize) {
                int len = node.block.size();
                for (int i = 0; i < len; ++i) {
                    rightNode.block.add(0, 0L);
                }
                LongGapList.transferCopy(node.block, 0, len, rightNode.block, 0, len);
                assert (rightNode.block.size() <= this.blockSize);
                this.modify(rightNode, len);
                this.modify(oldCurrNode, -len);
                this.releaseLongBlock();
                this.doRemove(oldCurrNode);
            }
        }
    }

    @Override
    protected long doRemove(int index) {
        int pos = this.getLongBlockIndex(index, true, -1);
        long oldElem = this.currNode.block.doRemove(pos);
        --this.currLongBlockEnd;
        int minLongBlockSize = Math.max(this.blockSize / 3, 1);
        if (this.currNode.block.size() < minLongBlockSize) {
            if (this.currNode.block.size() == 0) {
                if (!this.isOnlyRootLongBlock()) {
                    LongBlockNode oldCurrNode = this.currNode;
                    this.releaseLongBlock();
                    this.doRemove(oldCurrNode);
                }
            } else if (index != 0 && index != this.size - 1) {
                this.merge(this.currNode);
            }
        }
        --this.size;
        return oldElem;
    }

    @Override
    public LongBigList unmodifiableList() {
        return new ImmutableLongBigList(this);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        if (this.isOnlyRootLongBlock()) {
            if (minCapacity > this.blockSize) {
                minCapacity = this.blockSize;
            }
            this.rootNode.block.doEnsureCapacity(minCapacity);
        }
    }

    @Override
    public void trimToSize() {
        this.doModify();
        if (this.isOnlyRootLongBlock()) {
            this.rootNode.block.trimToSize();
        } else {
            LongBigList newList = new LongBigList(this.blockSize);
            LongBlockNode node = this.rootNode.min();
            while (node != null) {
                newList.addAll(node.block);
                this.remove(0, node.block.size());
                node = node.next();
            }
            this.doAssign(newList);
        }
    }

    @Override
    protected ILongList doCreate(int capacity) {
        if (capacity <= this.blockSize) {
            return new LongBigList(this.blockSize);
        }
        return new LongBigList(this.blockSize, capacity);
    }

    @Override
    public void sort(int index, int len) {
        this.checkRange(index, len);
        if (this.isOnlyRootLongBlock()) {
            this.rootNode.block.sort(index, len);
        } else {
            LongMergeSort.sort(this, index, index + len);
        }
    }

    @Override
    public int binarySearch(int index, int len, long key) {
        this.checkRange(index, len);
        if (this.isOnlyRootLongBlock()) {
            return this.rootNode.block.binarySearch(key);
        }
        return LongBinarySearch.binarySearch(this, key, 0, this.size());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.blockSize);
        int size = this.size();
        oos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            oos.writeLong(this.doGet(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int blockSize = ois.readInt();
        int size = ois.readInt();
        int firstLongBlockSize = size <= blockSize ? size : -1;
        this.doInit(blockSize, firstLongBlockSize);
        for (int i = 0; i < size; ++i) {
            this.add(ois.readLong());
        }
    }

    private void checkNode(LongBlockNode node) {
        assert ((node.block.size() > 0 || node == this.rootNode) && node.block.size() <= this.blockSize);
        LongBlockNode child = node.getLeftSubTree();
        assert (child == null || child.parent == node);
        child = node.getRightSubTree();
        assert (child == null || child.parent == node);
    }

    private void checkHeight(LongBlockNode node) {
        LongBlockNode left = node.getLeftSubTree();
        LongBlockNode right = node.getRightSubTree();
        if (left == null) {
            if (right == null) {
                assert (node.height == 0);
            } else {
                assert (right.height == node.height - 1);
                this.checkHeight(right);
            }
        } else {
            if (right == null) {
                assert (left.height == node.height - 1);
            } else {
                assert (left.height == node.height - 1 || left.height == node.height - 2);
                assert (right.height == node.height - 1 || right.height == node.height - 2);
                assert (right.height == node.height - 1 || left.height == node.height - 1);
            }
            this.checkHeight(left);
        }
    }

    private void check() {
        if (this.currNode != null) {
            assert (this.currLongBlockStart >= 0 && this.currLongBlockEnd <= this.size && this.currLongBlockStart <= this.currLongBlockEnd);
            assert (this.currLongBlockStart + this.currNode.block.size() == this.currLongBlockEnd);
        }
        if (this.rootNode == null) {
            assert (this.size == 0);
            return;
        }
        this.checkHeight(this.rootNode);
        LongBlockNode oldCurrNode = this.currNode;
        int oldCurrModify = this.currModify;
        if (this.currModify != 0) {
            this.currNode = null;
            this.currModify = 0;
            this.modify(oldCurrNode, oldCurrModify);
        }
        LongBlockNode node = this.rootNode;
        this.checkNode(node);
        int index = node.relPos;
        while (node.left != null) {
            node = node.left;
            this.checkNode(node);
            assert (node.relPos < 0);
            index += node.relPos;
        }
        LongBlock block = node.getLongBlock();
        assert (block.size() == index);
        int lastIndex = index;
        while (lastIndex < this.size()) {
            node = this.rootNode;
            index = node.relPos;
            int searchIndex = lastIndex + 1;
            while (true) {
                this.checkNode(node);
                block = node.getLongBlock();
                assert (block.size() > 0);
                if (searchIndex > index - block.size() && searchIndex <= index) break;
                if (searchIndex < index) {
                    if (node.left == null || node.left.height >= node.height) break;
                    node = node.left;
                } else {
                    if (node.right == null || node.right.height >= node.height) break;
                    node = node.right;
                }
                index += node.relPos;
            }
            block = node.getLongBlock();
            assert (block.size() == index - lastIndex);
            lastIndex = index;
        }
        assert (index == this.size());
        if (oldCurrModify != 0) {
            this.modify(oldCurrNode, -oldCurrModify);
        }
        this.currNode = oldCurrNode;
        this.currModify = oldCurrModify;
    }

    protected static class ImmutableLongBigList
    extends LongBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableLongBigList(LongBigList that) {
            super(true, that);
        }

        @Override
        protected boolean doAdd(int index, long elem) {
            this.error();
            return false;
        }

        @Override
        protected long doSet(int index, long elem) {
            this.error();
            return 0L;
        }

        @Override
        protected long doReSet(int index, long elem) {
            this.error();
            return 0L;
        }

        @Override
        protected long doRemove(int index) {
            this.error();
            return 0L;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }

    static class LongBlockNode {
        LongBlockNode parent;
        LongBlockNode left;
        boolean leftIsPrevious;
        LongBlockNode right;
        boolean rightIsNext;
        int height;
        int relPos;
        LongBlock block;

        private LongBlockNode(LongBlockNode parent, int relPos, LongBlock block, LongBlockNode rightFollower, LongBlockNode leftFollower) {
            this.parent = parent;
            this.relPos = relPos;
            this.block = block;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        private LongBlock getLongBlock() {
            return this.block;
        }

        private void setLongBlock(LongBlock block) {
            this.block = block;
        }

        private LongBlockNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        private LongBlockNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        private LongBlockNode insert(int index, LongBlock obj) {
            assert (this.relPos != 0);
            int relIndex = index - this.relPos;
            if (relIndex < 0) {
                return this.insertOnLeft(relIndex, obj);
            }
            return this.insertOnRight(relIndex, obj);
        }

        private LongBlockNode insertOnLeft(int relIndex, LongBlock obj) {
            if (this.getLeftSubTree() == null) {
                int pos = this.relPos >= 0 ? -this.relPos : -this.block.size();
                this.setLeft(new LongBlockNode(this, pos, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(relIndex, obj), null);
            }
            if (this.relPos >= 0) {
                this.relPos += obj.size();
            }
            LongBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private LongBlockNode insertOnRight(int relIndex, LongBlock obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new LongBlockNode(this, obj.size(), obj, this.right, this), null);
            } else {
                this.setRight(this.right.insert(relIndex, obj), null);
            }
            if (this.relPos < 0) {
                this.relPos -= obj.size();
            }
            LongBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private LongBlockNode getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private LongBlockNode getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private LongBlockNode max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        private LongBlockNode min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        private LongBlockNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(this.right.removeMax(), this.right.right);
            this.recalcHeight();
            return this.balance();
        }

        private LongBlockNode removeMin(int size) {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(this.left.removeMin(size), this.left.left);
            if (this.relPos > 0) {
                this.relPos -= size;
            }
            this.recalcHeight();
            return this.balance();
        }

        private LongBlockNode removeSelf() {
            LongBlockNode p = this.parent;
            LongBlockNode n = this.doRemoveSelf();
            if (n != null) {
                assert (p != n);
                n.parent = p;
            }
            return n;
        }

        private LongBlockNode doRemoveSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                this.left.relPos = this.relPos > 0 ? this.left.relPos + (this.relPos + (this.relPos > 0 ? 0 : 1)) : (this.left.relPos += this.relPos);
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                if (this.relPos < 0) {
                    this.right.relPos = this.right.relPos + (this.relPos - (this.relPos < 0 ? 0 : 1));
                }
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                LongBlockNode rightMin = this.right.min();
                this.block = rightMin.block;
                int bs = this.block.size();
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = this.right.removeMin(bs);
                this.relPos += bs;
                this.left.relPos -= bs;
            } else {
                LongBlockNode leftMax = this.left.max();
                this.block = leftMax.block;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                LongBlockNode leftPrevious = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                } else if (this.left.relPos == 0) {
                    this.left.relPos = -1;
                }
            }
            this.recalcHeight();
            return this;
        }

        private LongBlockNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        this.setLeft(this.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        this.setRight(this.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(LongBlockNode node) {
            if (node == null) {
                return 0;
            }
            return node.relPos;
        }

        private int setOffset(LongBlockNode node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relPos = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(LongBlockNode node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private LongBlockNode rotateLeft() {
            assert (!this.rightIsNext);
            LongBlockNode newTop = this.right;
            LongBlockNode movedNode = this.getRightSubTree().getLeftSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            LongBlockNode p = this.parent;
            this.setRight(movedNode, newTop);
            newTop.setLeft(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private LongBlockNode rotateRight() {
            assert (!this.leftIsPrevious);
            LongBlockNode newTop = this.left;
            LongBlockNode movedNode = this.getLeftSubTree().getRightSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            LongBlockNode p = this.parent;
            this.setLeft(movedNode, newTop);
            newTop.setRight(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private void setLeft(LongBlockNode node, LongBlockNode previous) {
            assert (node != this && previous != this);
            boolean bl = this.leftIsPrevious = node == null;
            if (this.leftIsPrevious) {
                this.left = previous;
            } else {
                this.left = node;
                this.left.parent = this;
            }
            this.recalcHeight();
        }

        private void setRight(LongBlockNode node, LongBlockNode next) {
            assert (node != this && next != this);
            boolean bl = this.rightIsNext = node == null;
            if (this.rightIsNext) {
                this.right = next;
            } else {
                this.right = node;
                this.right.parent = this;
            }
            this.recalcHeight();
        }

        public String toString() {
            return "LongBlockNode(" + this.relPos + ',' + (this.getRightSubTree() != null) + ',' + this.block + ',' + (this.getRightSubTree() != null) + ", height " + this.height + " )";
        }
    }

    public static class LongBlock
    extends LongGapList {
        private AtomicInteger refCount = new AtomicInteger();

        public LongBlock() {
        }

        public LongBlock(int capacity) {
            super(capacity);
        }

        public LongBlock(LongBlock that) {
            super(that.capacity());
            this.addAll(that);
        }

        public boolean isShared() {
            return this.refCount.get() > 1;
        }

        public LongBlock ref() {
            this.refCount.incrementAndGet();
            return this;
        }

        public void unref() {
            this.refCount.decrementAndGet();
        }
    }

    protected static abstract class ImmutableLongList
    extends ILongList {
        protected ImmutableLongList() {
        }

        @Override
        public int capacity() {
            return this.size();
        }

        @Override
        public int binarySearch(int index, int len, long key) {
            return LongBinarySearch.binarySearch(this, key, index, index + len);
        }

        @Override
        public ILongList unmodifiableList() {
            return this;
        }

        @Override
        protected long getDefaultElem() {
            return 0L;
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        @Override
        protected void doClone(ILongList that) {
            this.error();
        }

        @Override
        protected long doSet(int index, long elem) {
            this.error();
            return 0L;
        }

        @Override
        protected long doReSet(int index, long elem) {
            this.error();
            return 0L;
        }

        @Override
        protected boolean doAdd(int index, long elem) {
            this.error();
            return false;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected ILongList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(ILongList that) {
            this.error();
        }

        @Override
        protected long doRemove(int index) {
            this.error();
            return 0L;
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }
    }

    static class ImmutableLongListList
    extends ImmutableLongList {
        List<Long> values;

        public ImmutableLongListList(List<Long> values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        protected long doGet(int index) {
            return this.values.get(index);
        }
    }

    static class ImmutableLongListArrayWrapper
    extends ImmutableLongList {
        Long[] values;

        public ImmutableLongListArrayWrapper(Long[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected long doGet(int index) {
            return this.values[index];
        }
    }

    static class ImmutableLongListArrayPrimitive
    extends ImmutableLongList {
        long[] values;

        public ImmutableLongListArrayPrimitive(long[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected long doGet(int index) {
            return this.values[index];
        }
    }
}

