/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import org.magicwerk.brownies.collections.function.IFunction;
import org.magicwerk.brownies.collections.function.IPredicate;

public abstract class IList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable,
Deque<E> {
    private static final int TRANSFER_COPY = 0;
    private static final int TRANSFER_MOVE = 1;
    private static final int TRANSFER_REMOVE = 2;

    static Object[] toArray(Collection<?> coll) {
        Object[] values = coll.toArray();
        if (values.getClass() != Object[].class) {
            values = Arrays.copyOf(values, values.length, Object[].class);
        }
        return values;
    }

    public IList<E> copy() {
        return (IList)this.clone();
    }

    public abstract IList<E> unmodifiableList();

    public Object clone() {
        try {
            IList list = (IList)super.clone();
            list.doClone(this);
            return list;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(IList<E> var1);

    @Override
    public void clear() {
        this.doClear();
    }

    protected void doClear() {
        this.doRemoveAll(0, this.size());
    }

    public void resize(int len, E elem) {
        this.checkLength(len);
        int size = this.size();
        if (len < size) {
            this.remove(len, size - len);
        } else {
            for (int i = size; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    @Override
    public abstract int size();

    public abstract int capacity();

    @Override
    public E get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract E doGet(int var1);

    protected abstract E doSet(int var1, E var2);

    @Override
    public E set(int index, E elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    public E put(int index, E elem) {
        this.checkIndexAdd(index);
        if (index < this.size()) {
            return this.doSet(index, elem);
        }
        this.doAdd(-1, elem);
        return null;
    }

    protected abstract E doReSet(int var1, E var2);

    protected abstract E getDefaultElem();

    protected void doModify() {
    }

    @Override
    public boolean add(E elem) {
        return this.doAdd(-1, elem);
    }

    @Override
    public void add(int index, E elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, E var2);

    @Override
    public E remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract E doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List list = (List)obj;
        int size = this.size();
        if (size != list.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (IList.equalsElem(this.doGet(i), list.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E elem = this.doGet(i);
            hashCode = 31 * hashCode + IList.hashCodeElem(elem);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(Object elem1, Object elem2) {
        return elem1 == null ? elem2 == null : elem1.equals(elem2);
    }

    static int hashCodeElem(Object elem) {
        if (elem == null) {
            return 0;
        }
        return elem.hashCode();
    }

    public int getCount(E elem) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public IList<E> getAll(E elem) {
        IList<E> list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.doGet(i);
            if (!IList.equalsElem(e, elem)) continue;
            list.add(e);
        }
        return list;
    }

    public IList<E> getWhere(IPredicate<E> predicate) {
        IList<E> list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list.add(e);
        }
        return list;
    }

    public void removeWhere(IPredicate<E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.doGet(i);
            if (!predicate.test(e)) continue;
            this.doRemove(i);
            --size;
            --i;
        }
    }

    public void retainWhere(IPredicate<E> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.doGet(i);
            if (predicate.test(e)) continue;
            this.doRemove(i);
            --size;
            --i;
        }
    }

    public IList<E> extractWhere(IPredicate<E> predicate) {
        IList<E> list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    public Set<E> getDistinct() {
        HashSet<E> set = new HashSet<E>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            set.add(this.doGet(i));
        }
        return set;
    }

    public <R> IList<R> mappedList(IFunction<E, R> mapper) {
        int size = this.size();
        IList<R> mappedList = this.doCreate(size);
        for (int i = 0; i < size; ++i) {
            E e = this.doGet(i);
            mappedList.add(mapper.apply(e));
        }
        return mappedList;
    }

    public void filter(IPredicate<? super E> predicate) {
        IList<E> list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list.add(e);
        }
        this.doAssign(list);
    }

    @Override
    public int indexOf(Object elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!IList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Object elem, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int size = this.size();
        for (int i = fromIndex; i < size; ++i) {
            if (!IList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object elem, int fromIndex) {
        int size = this.size();
        if (fromIndex >= size) {
            fromIndex = size - 1;
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!IList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean remove(Object elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    @Override
    public boolean contains(Object elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean addIfAbsent(E elem) {
        if (this.contains(elem)) {
            return false;
        }
        return this.add(elem);
    }

    public boolean containsAny(Collection<?> coll) {
        for (Object elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        for (Object elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public IList<E> removeAll(E elem) {
        IList<E> list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.doGet(i);
            if (!IList.equalsElem(elem, e)) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    @Override
    public boolean removeAll(IList<?> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(IList<?> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] array = new Object[size];
        this.doGetAll(array, 0, size);
        return array;
    }

    public Object[] toArray(int index, int len) {
        Object[] array = new Object[len];
        this.doGetAll(array, index, len);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        this.doGetAll(array, 0, size);
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    protected <T> void doGetAll(T[] array, int index, int len) {
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    protected boolean doAddAll(int index, IList<? extends E> list) {
        int listSize = list.size();
        this.doEnsureCapacity(this.size() + listSize);
        if (listSize == 0) {
            return false;
        }
        boolean changed = false;
        int prevSize = this.size();
        for (int i = 0; i < listSize; ++i) {
            E elem = list.get(i);
            if (!this.doAdd(index, elem)) continue;
            changed = true;
            if (index == -1 || prevSize == this.size()) continue;
            prevSize = this.size();
            ++index;
        }
        return changed;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(true);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIter(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListIter(index);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new Iter(false);
    }

    @Override
    public E peek() {
        if (this.size() == 0) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    public E element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    @Override
    public E poll() {
        if (this.size() == 0) {
            return null;
        }
        return this.doRemove(0);
    }

    @Override
    public E remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    @Override
    public boolean offer(E elem) {
        return this.doAdd(-1, elem);
    }

    @Override
    public E getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    @Override
    public E getLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size - 1);
    }

    @Override
    public void addFirst(E elem) {
        this.doAdd(0, elem);
    }

    @Override
    public void addLast(E elem) {
        this.doAdd(-1, elem);
    }

    @Override
    public E removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    @Override
    public E removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size - 1);
    }

    @Override
    public boolean offerFirst(E elem) {
        this.doAdd(0, elem);
        return true;
    }

    @Override
    public boolean offerLast(E elem) {
        this.doAdd(-1, elem);
        return true;
    }

    @Override
    public E peekFirst() {
        if (this.size() == 0) {
            return null;
        }
        return this.doGet(0);
    }

    @Override
    public E peekLast() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.doGet(size - 1);
    }

    @Override
    public E pollFirst() {
        if (this.size() == 0) {
            return null;
        }
        return this.doRemove(0);
    }

    @Override
    public E pollLast() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.doRemove(size - 1);
    }

    @Override
    public E pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    @Override
    public void push(E elem) {
        this.doAdd(0, elem);
    }

    @Override
    public boolean removeFirstOccurrence(Object elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    @Override
    public boolean removeLastOccurrence(Object elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static <E> void transferCopy(IList<E> src, int srcIndex, int srcLen, IList<? super E> dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.copy(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(0, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static <E> void transferMove(IList<E> src, int srcIndex, int srcLen, IList<? super E> dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.move(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(1, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static <E> void transferRemove(IList<E> src, int srcIndex, int srcLen, IList<? super E> dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.drag(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(2, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    void doTransfer(int transferMode, int srcIndex, int srcLen, IList<? super E> dst, int dstIndex, int dstLen) {
        this.checkRange(srcIndex, srcLen);
        if (dstIndex == -1) {
            dstIndex = dst.size();
        } else {
            dst.checkIndexAdd(dstIndex);
        }
        if (dstLen == -1) {
            dstLen = dst.size() - dstIndex;
        } else {
            dst.checkLength(dstLen);
        }
        E defaultElem = this.getDefaultElem();
        if (dstLen > srcLen) {
            dst.remove(dstIndex, dstLen - srcLen);
        } else if (srcLen > dstLen) {
            dst.addMult(dstIndex, srcLen - dstLen, defaultElem);
        }
        if (transferMode == 1) {
            for (int i = 0; i < srcLen; ++i) {
                E elem = this.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        } else {
            for (int i = 0; i < srcLen; ++i) {
                E elem = this.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
            if (transferMode == 2) {
                this.remove(srcIndex, srcLen);
            }
        }
    }

    public static <E> void transferSwap(IList<E> src, int srcIndex, IList<E> dst, int dstIndex, int len) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len);
        } else {
            src.doTransferSwap(srcIndex, dst, dstIndex, len);
        }
    }

    void doTransferSwap(int srcIndex, IList<E> dst, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        dst.checkRange(dstIndex, len);
        for (int i = 0; i < len; ++i) {
            E swap = this.doGet(srcIndex + i);
            swap = dst.doSet(dstIndex + i, swap);
            this.doSet(srcIndex + i, swap);
        }
    }

    protected abstract IList<E> doCreate(int var1);

    protected abstract void doAssign(IList<E> var1);

    public IList<E> getAll(int index, int len) {
        this.checkRange(index, len);
        IList<E> list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        return list;
    }

    public IList<E> extract(int index, int len) {
        this.checkRange(index, len);
        IList<E> list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        this.remove(index, len);
        return list;
    }

    public E[] getArray(int index, int len) {
        this.checkRange(index, len);
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
        return array;
    }

    public void remove(int index, int len) {
        this.checkRange(index, len);
        this.doRemoveAll(index, len);
    }

    protected void doRemoveAll(int index, int len) {
        for (int i = index + len - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    @Override
    public boolean addAll(IList<? extends E> list) {
        return this.doAddAll(-1, list);
    }

    @Override
    public boolean addAll(int index, IList<? extends E> list) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list);
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        if (coll instanceof List) {
            return this.doAddAll(-1, new IReadOnlyListFromList((List)coll));
        }
        return this.doAddAll(-1, new IReadOnlyListFromCollection<E>(coll));
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        this.checkIndexAdd(index);
        if (coll instanceof List) {
            return this.doAddAll(index, new IReadOnlyListFromList((List)coll));
        }
        return this.doAddAll(index, new IReadOnlyListFromCollection<E>(coll));
    }

    public boolean addArray(E ... elems) {
        return this.doAddAll(-1, new IReadOnlyListFromArray<E>(elems));
    }

    public boolean addArray(int index, E ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyListFromArray<E>(elems));
    }

    public boolean addMult(int len, E elem) {
        return this.doAddAll(-1, new IReadOnlyListFromMult<E>(len, elem));
    }

    public boolean addMult(int index, int len, E elem) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyListFromMult<E>(len, elem));
    }

    public void setAll(int index, IList<? extends E> list) {
        int listSize = list.size();
        this.checkRange(index, listSize);
        this.doReplaceAll(index, listSize, list);
    }

    public void setAll(int index, Collection<? extends E> coll) {
        int collSize = coll.size();
        this.checkRange(index, collSize);
        if (coll instanceof List) {
            this.doReplaceAll(index, collSize, new IReadOnlyListFromList((List)coll));
        } else {
            this.doReplaceAll(index, collSize, new IReadOnlyListFromCollection<E>(coll));
        }
    }

    public void setArray(int index, E ... elems) {
        int arrayLen = elems.length;
        this.checkRange(index, arrayLen);
        this.doReplaceAll(index, arrayLen, new IReadOnlyListFromArray<E>(elems));
    }

    public void setMult(int index, int len, E elem) {
        this.checkRange(index, len);
        this.doReplaceAll(index, len, new IReadOnlyListFromMult<E>(len, elem));
    }

    public void putAll(int index, IList<? extends E> list) {
        this.checkIndexAdd(index);
        this.checkNonNull(list);
        int len = this.size() - index;
        if (list != null && list.size() < len) {
            len = list.size();
        }
        this.doReplaceAll(index, len, list);
    }

    public void putAll(int index, Collection<? extends E> coll) {
        if (coll instanceof IList) {
            this.putAll(index, (IList)coll);
        } else if (coll instanceof List) {
            this.putAll(index, new IReadOnlyListFromList((List)coll));
        } else {
            this.putAll(index, (IList<? extends E>)new IReadOnlyListFromCollection<E>(coll));
        }
    }

    public void putArray(int index, E ... elems) {
        this.putAll(index, (IList<? extends E>)new IReadOnlyListFromArray<E>(elems));
    }

    public void putMult(int index, int len, E elem) {
        this.putAll(index, (IList<? extends E>)new IReadOnlyListFromMult<E>(len, elem));
    }

    public void initAll(IList<? extends E> list) {
        this.checkNonNull(list);
        this.doReplaceAll(0, this.size(), list);
    }

    public void initAll(Collection<? extends E> coll) {
        if (coll instanceof IList) {
            this.initAll((IList)coll);
        } else if (coll instanceof List) {
            this.initAll(new IReadOnlyListFromList((List)coll));
        } else {
            this.initAll((IList<? extends E>)new IReadOnlyListFromCollection<E>(coll));
        }
    }

    public void initArray(E ... elems) {
        this.initAll((IList<? extends E>)new IReadOnlyListFromArray<E>(elems));
    }

    public void initMult(int len, E elem) {
        this.checkLength(len);
        this.initAll((IList<? extends E>)new IReadOnlyListFromMult<E>(len, elem));
    }

    public void replaceAll(int index, int len, Collection<? extends E> coll) {
        if (coll instanceof IList) {
            this.replaceAll(index, len, (IList)coll);
        } else if (coll instanceof List) {
            this.replaceAll(index, len, new IReadOnlyListFromList((List)coll));
        } else {
            this.replaceAll(index, len, (IList<? extends E>)new IReadOnlyListFromCollection<E>(coll));
        }
    }

    public void replaceArray(int index, int len, E ... elems) {
        this.replaceAll(index, len, (IList<? extends E>)new IReadOnlyListFromArray<E>(elems));
    }

    public void replaceMult(int index, int len, int numElems, E elem) {
        this.replaceAll(index, len, (IList<? extends E>)new IReadOnlyListFromMult<E>(numElems, elem));
    }

    public void replaceAll(int index, int len, IList<? extends E> list) {
        if (index == -1) {
            index = this.size();
        } else {
            this.checkIndexAdd(index);
        }
        if (len == -1) {
            len = this.size() - index;
            if (list != null && list.size() < len) {
                len = list.size();
            }
        } else {
            this.checkRange(index, len);
        }
        this.doReplaceAll(index, len, list);
    }

    protected boolean doReplaceAll(int index, int len, IList<? extends E> list) {
        int i;
        assert (index >= 0 && index <= this.size());
        assert (len >= 0 && index + len <= this.size());
        assert (list != null);
        int srcLen = 0;
        if (list != null) {
            srcLen = list.size();
        }
        this.doEnsureCapacity(this.size() - len + srcLen);
        if (len > srcLen) {
            this.doRemoveAll(index, len - srcLen);
            len = srcLen;
        }
        for (i = 0; i < len; ++i) {
            this.doSet(index + i, list.doGet(i));
        }
        for (i = len; i < srcLen; ++i) {
            if (this.doAdd(index + i, list.doGet(i))) continue;
            --index;
        }
        return len > 0 || srcLen > 0;
    }

    public void fill(E elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.doSet(i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len);
                this.checkRange(dstIndex, len);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len) {
        int fill;
        int i;
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            for (i = len - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len, dstIndex - srcIndex);
            this.setMult(srcIndex, fill, null);
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len, srcIndex - dstIndex);
            this.setMult(srcIndex + len - fill, fill, null);
        }
    }

    public void drag(int srcIndex, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            this.doRotate(srcIndex, len + (dstIndex - srcIndex), dstIndex - srcIndex);
        } else if (srcIndex > dstIndex) {
            this.doRotate(dstIndex, len + (srcIndex - dstIndex), dstIndex - srcIndex);
        }
    }

    public void swap(int index1, int index2, int len) {
        this.checkRange(index1, len);
        this.checkRange(index2, len);
        if (index1 < index2 && index1 + len > index2 || index1 > index2 && index2 + len > index1) {
            throw new IndexOutOfBoundsException("Swap ranges overlap");
        }
        for (int i = 0; i < len; ++i) {
            E swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len) {
        this.checkRange(index, len);
        int pos1 = index;
        int pos2 = index + len - 1;
        int mid = len / 2;
        for (int i = 0; i < mid; ++i) {
            E swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len, int distance) {
        this.checkRange(index, len);
        this.doRotate(index, len, distance);
    }

    protected void doRotate(int index, int len, int distance) {
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        assert (distance >= 0 && distance < len);
        int num = 0;
        int start = 0;
        while (num != len) {
            E elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        this.sort(0, this.size(), comparator);
    }

    public abstract void sort(int var1, int var2, Comparator<? super E> var3);

    public <K> int binarySearch(K key, Comparator<? super K> comparator) {
        return this.binarySearch(0, this.size(), key, comparator);
    }

    public abstract <K> int binarySearch(int var1, int var2, K var3, Comparator<? super K> var4);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len) {
        if (index < 0 || len < 0 || index + len > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int len) {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len);
        }
    }

    protected void checkLengths(int len1, int len2) {
        if (len1 != len2) {
            throw new IndexOutOfBoundsException("Invalid lengths: " + len1 + ", " + len2);
        }
        if (len1 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len1);
        }
        if (len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len2);
        }
    }

    protected void checkNonNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Argument may not be null");
        }
    }

    protected static class IReadOnlyListFromList<E>
    extends IReadOnlyList<E> {
        List<E> list2;

        IReadOnlyListFromList(List<? extends E> list) {
            this.list2 = list;
        }

        @Override
        public int size() {
            return this.list2.size();
        }

        @Override
        protected E doGet(int index) {
            return this.list2.get(index);
        }
    }

    protected static class IReadOnlyListFromCollection<E>
    extends IReadOnlyList<E> {
        Object[] array;

        IReadOnlyListFromCollection(Collection<? extends E> coll) {
            this.array = coll.toArray();
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected E doGet(int index) {
            return (E)this.array[index];
        }
    }

    protected static class IReadOnlyListFromMult<E>
    extends IReadOnlyList<E> {
        int len;
        E elem;

        IReadOnlyListFromMult(int len, E elem) {
            this.checkLength(len);
            this.len = len;
            this.elem = elem;
        }

        @Override
        public int size() {
            return this.len;
        }

        @Override
        protected E doGet(int index) {
            return this.elem;
        }
    }

    protected static class IReadOnlyListFromArray<E>
    extends IReadOnlyList<E> {
        E[] array;

        IReadOnlyListFromArray(E[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected E doGet(int index) {
            return this.array[index];
        }
    }

    protected static abstract class IReadOnlyList<E>
    extends IList<E> {
        protected IReadOnlyList() {
        }

        @Override
        public IList<E> unmodifiableList() {
            this.error();
            return null;
        }

        @Override
        protected void doClone(IList<E> that) {
            this.error();
        }

        @Override
        public int capacity() {
            this.error();
            return 0;
        }

        @Override
        protected E doSet(int index, E elem) {
            this.error();
            return null;
        }

        @Override
        protected E doReSet(int index, E elem) {
            this.error();
            return null;
        }

        @Override
        protected E getDefaultElem() {
            this.error();
            return null;
        }

        @Override
        protected boolean doAdd(int index, E elem) {
            this.error();
            return false;
        }

        @Override
        protected E doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IList<E> doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IList<E> that) {
            this.error();
        }

        @Override
        public void sort(int index, int len, Comparator<? super E> comparator) {
            this.error();
        }

        @Override
        public <K> int binarySearch(int index, int len, K key, Comparator<? super K> comparator) {
            this.error();
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is read-only");
        }
    }

    class ListIter
    implements ListIterator<E> {
        int index;
        int remove;

        public ListIter(int index) {
            IList.this.checkIndexAdd(index);
            this.index = index;
            this.remove = -1;
        }

        @Override
        public boolean hasNext() {
            return this.index < IList.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E next() {
            if (this.index >= IList.this.size()) {
                throw new NoSuchElementException();
            }
            Object elem = IList.this.get(this.index);
            this.remove = this.index++;
            return elem;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public E previous() {
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            --this.index;
            Object elem = IList.this.get(this.index);
            this.remove = this.index;
            return elem;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (this.remove == -1) {
                throw new IllegalStateException("No current element to remove");
            }
            IList.this.remove(this.remove);
            if (this.index > this.remove) {
                --this.index;
            }
            this.remove = -1;
        }

        @Override
        public void set(E e) {
            if (this.remove == -1) {
                throw new IllegalStateException("No current element to set");
            }
            IList.this.set(this.remove, e);
        }

        @Override
        public void add(E e) {
            IList.this.add(this.index, e);
            ++this.index;
            this.remove = -1;
        }
    }

    class Iter
    implements Iterator<E> {
        boolean forward;
        int index;
        int remove;

        public Iter(boolean forward) {
            this.forward = forward;
            this.index = forward ? 0 : IList.this.size() - 1;
            this.remove = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.forward) {
                return this.index != IList.this.size();
            }
            return this.index != -1;
        }

        @Override
        public E next() {
            if (this.forward ? this.index >= IList.this.size() : this.index < 0) {
                throw new NoSuchElementException();
            }
            Object elem = IList.this.get(this.index);
            this.remove = this.index++;
            if (!this.forward) {
                --this.index;
            }
            return elem;
        }

        @Override
        public void remove() {
            if (this.remove == -1) {
                throw new IllegalStateException("No current element to remove");
            }
            IList.this.remove(this.remove);
            if (this.index > this.remove) {
                --this.index;
            }
            this.remove = -1;
        }
    }
}

