/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.images;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.reference.PictureTypes;

public class StandardArtwork
implements Artwork {
    private byte[] binaryData;
    private String mimeType = "";
    private String description = "";
    private boolean isLinked = false;
    private String imageUrl = "";
    private int pictureType = -1;
    private int width;
    private int height;

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean setImageFromData() {
        try {
            BufferedImage image = (BufferedImage)this.getImage();
            this.setWidth(image.getWidth());
            this.setHeight(image.getHeight());
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public Object getImage() throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(this.getBinaryData()));
        BufferedImage bi = ImageIO.read(iis);
        return bi;
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public void setLinked(boolean linked) {
        this.isLinked = linked;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public int getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(int pictureType) {
        this.pictureType = pictureType;
    }

    public void setFromFile(File file) throws IOException {
        RandomAccessFile imageFile = new RandomAccessFile(file, "r");
        byte[] imagedata = new byte[(int)imageFile.length()];
        imageFile.read(imagedata);
        imageFile.close();
        this.setBinaryData(imagedata);
        this.setMimeType(ImageFormats.getMimeTypeForBinarySignature(imagedata));
        this.setDescription("");
        this.setPictureType(PictureTypes.DEFAULT_ID);
    }

    public void setLinkedFromURL(String url) throws IOException {
        this.setLinked(true);
        this.setImageUrl(url);
    }

    public static StandardArtwork createArtworkFromFile(File file) throws IOException {
        StandardArtwork artwork = new StandardArtwork();
        artwork.setFromFile(file);
        return artwork;
    }

    public static StandardArtwork createLinkedArtworkFromURL(String url) throws IOException {
        StandardArtwork artwork = new StandardArtwork();
        artwork.setLinkedFromURL(url);
        return artwork;
    }

    public void setFromMetadataBlockDataPicture(MetadataBlockDataPicture coverArt) {
        this.setMimeType(coverArt.getMimeType());
        this.setDescription(coverArt.getDescription());
        this.setPictureType(coverArt.getPictureType());
        if (coverArt.isImageUrl()) {
            this.setLinked(coverArt.isImageUrl());
            this.setImageUrl(coverArt.getImageUrl());
        } else {
            this.setBinaryData(coverArt.getImageData());
        }
        this.setWidth(coverArt.getWidth());
        this.setHeight(coverArt.getHeight());
    }

    public static StandardArtwork createArtworkFromMetadataBlockDataPicture(MetadataBlockDataPicture coverArt) {
        StandardArtwork artwork = new StandardArtwork();
        artwork.setFromMetadataBlockDataPicture(coverArt);
        return artwork;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

