/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import org.javasimon.Sample;
import org.javasimon.console.ActionContext;
import org.javasimon.console.SimonType;
import org.javasimon.console.action.AbstractTableAction;
import org.javasimon.console.html.HtmlBuilder;
import org.javasimon.console.html.HtmlResource;
import org.javasimon.console.text.StringifierFactory;

public class TableHtmlAction
extends AbstractTableAction {
    public static final String PATH = "/data/table.html";
    private Integer index;
    private HtmlBuilder htmlBuilder;

    public TableHtmlAction(ActionContext context) {
        super(context, "text/html");
        this.stringifierFactory = new StringifierFactory();
        this.numberPattern = "0";
    }

    @Override
    protected void printTable(PrintWriter writer) throws IOException {
        this.htmlBuilder = new HtmlBuilder(writer);
        ((HtmlBuilder)this.htmlBuilder.header("List View", Collections.<HtmlResource>emptyList())).begin("table", "flatTable", "flatTable");
        super.printTable(writer);
        ((HtmlBuilder)this.htmlBuilder.end("table")).footer();
    }

    @Override
    protected void printHeaderRow(PrintWriter writer) throws IOException {
        ((HtmlBuilder)this.htmlBuilder.begin("thead")).begin("tr");
        super.printHeaderRow(writer);
        ((HtmlBuilder)this.htmlBuilder.end("tr")).end("thead");
    }

    @Override
    protected void printBody(PrintWriter writer) throws IOException {
        this.htmlBuilder.begin("tbody");
        this.index = 0;
        super.printBody(writer);
        this.index = null;
        this.htmlBuilder.end("tbody");
    }

    @Override
    protected void printBodyRow(Sample sample, PrintWriter writer) throws IOException {
        this.htmlBuilder.begin("tr", Integer.toString(this.index), this.index % 2 == 0 ? "even" : "odd");
        super.printBodyRow(sample, writer);
        Integer n = this.index;
        Integer n2 = this.index = Integer.valueOf(this.index + 1);
        this.htmlBuilder.end("tr");
    }

    @Override
    protected void printCell(AbstractTableAction.Column column, String s, PrintWriter writer) throws IOException {
        this.htmlBuilder.begin("td", null, column.getName());
        if (column.getName().equals("type")) {
            try {
                this.htmlBuilder.simonTypeImg(SimonType.valueOf(s), "../../");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        super.printCell(column, s, writer);
        this.htmlBuilder.end("td");
    }
}

