/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserOperatingSystemMapping;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.Device;
import net.sf.uadetector.internal.data.domain.DevicePattern;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;

@Immutable
public class Data
implements Serializable {
    public static final Data EMPTY = new Data(new HashSet<Browser>(0), new HashMap<Integer, SortedSet<BrowserPattern>>(0), new HashMap<Integer, BrowserType>(0), new TreeMap<BrowserPattern, Browser>(), new HashSet<BrowserOperatingSystemMapping>(0), new HashSet<OperatingSystem>(0), new HashMap<Integer, SortedSet<OperatingSystemPattern>>(0), new TreeMap<OperatingSystemPattern, OperatingSystem>(), new ArrayList<Robot>(0), new HashSet<Device>(0), new HashMap<Integer, SortedSet<DevicePattern>>(0), new TreeMap<DevicePattern, Device>(), "");
    private static final long serialVersionUID = 8522012551928801089L;
    @Nonnull
    private final Map<Integer, SortedSet<BrowserPattern>> browserPatterns;
    @Nonnull
    private final Set<Browser> browsers;
    @Nonnull
    private final Map<Integer, SortedSet<DevicePattern>> devicePatterns;
    @Nonnull
    private final Set<Device> devices;
    @Nonnull
    private final SortedMap<DevicePattern, Device> patternToDeviceMap;
    @Nonnull
    private final Set<BrowserOperatingSystemMapping> browserToOperatingSystemMappings;
    @Nonnull
    private final Map<Integer, BrowserType> browserTypes;
    @Nonnull
    private final Map<Integer, SortedSet<OperatingSystemPattern>> operatingSystemPatterns;
    @Nonnull
    private final Set<OperatingSystem> operatingSystems;
    @Nonnull
    private final SortedMap<BrowserPattern, Browser> patternToBrowserMap;
    @Nonnull
    private final SortedMap<OperatingSystemPattern, OperatingSystem> patternToOperatingSystemMap;
    @Nonnull
    private final List<Robot> robots;
    @Nonnull
    private final String version;

    public Data(@Nonnull Set<Browser> browsers, @Nonnull Map<Integer, SortedSet<BrowserPattern>> browserPatterns, @Nonnull Map<Integer, BrowserType> browserTypes, @Nonnull SortedMap<BrowserPattern, Browser> patternToBrowserMap, @Nonnull Set<BrowserOperatingSystemMapping> browserToOperatingSystemMappings, @Nonnull Set<OperatingSystem> operatingSystems, @Nonnull Map<Integer, SortedSet<OperatingSystemPattern>> operatingSystemPatterns, @Nonnull SortedMap<OperatingSystemPattern, OperatingSystem> patternToOperatingSystemMap, @Nonnull List<Robot> robots, @Nonnull Set<Device> devices, @Nonnull Map<Integer, SortedSet<DevicePattern>> devicePatterns, @Nonnull SortedMap<DevicePattern, Device> patternToDeviceMap, @Nonnull String version) {
        Check.notNull(browsers, (String)"browsers");
        Check.notNull(browserPatterns, (String)"browserPatterns");
        Check.notNull(browserTypes, (String)"browserTypes");
        Check.notNull(patternToBrowserMap, (String)"patternToBrowserMap");
        Check.notNull(browserToOperatingSystemMappings, (String)"browserToOperatingSystemMap");
        Check.notNull(operatingSystems, (String)"operatingSystems");
        Check.notNull(operatingSystemPatterns, (String)"operatingSystemPatterns");
        Check.notNull(patternToOperatingSystemMap, (String)"patternToOperatingSystemMap");
        Check.notNull(robots, (String)"robots");
        Check.notNull(devices, (String)"devices");
        Check.notNull(devicePatterns, (String)"devicePatterns");
        Check.notNull(patternToDeviceMap, (String)"patternToDeviceMap");
        Check.notNull((Object)version, (String)"version");
        this.browsers = Collections.unmodifiableSet(new HashSet<Browser>(browsers));
        this.browserPatterns = Collections.unmodifiableMap(new HashMap<Integer, SortedSet<BrowserPattern>>(browserPatterns));
        this.browserTypes = Collections.unmodifiableMap(new HashMap((Map)Check.notNull(browserTypes, (String)"browserTypes")));
        this.patternToBrowserMap = Collections.unmodifiableSortedMap(new TreeMap<BrowserPattern, Browser>(patternToBrowserMap));
        this.browserToOperatingSystemMappings = Collections.unmodifiableSet(new HashSet<BrowserOperatingSystemMapping>(browserToOperatingSystemMappings));
        this.operatingSystems = Collections.unmodifiableSet(new HashSet<OperatingSystem>(operatingSystems));
        this.operatingSystemPatterns = Collections.unmodifiableMap(new HashMap<Integer, SortedSet<OperatingSystemPattern>>(operatingSystemPatterns));
        this.patternToOperatingSystemMap = Collections.unmodifiableSortedMap(new TreeMap<OperatingSystemPattern, OperatingSystem>(patternToOperatingSystemMap));
        this.robots = Collections.unmodifiableList(new ArrayList<Robot>(robots));
        this.devices = Collections.unmodifiableSet(new HashSet<Device>(devices));
        this.devicePatterns = Collections.unmodifiableMap(new HashMap<Integer, SortedSet<DevicePattern>>(devicePatterns));
        this.patternToDeviceMap = Collections.unmodifiableSortedMap(new TreeMap<DevicePattern, Device>(patternToDeviceMap));
        this.version = (String)Check.notNull((Object)version, (String)"version");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Data other = (Data)obj;
        if (!((Object)this.browsers).equals(other.browsers)) {
            return false;
        }
        if (!((Object)this.browserPatterns).equals(other.browserPatterns)) {
            return false;
        }
        if (!((Object)this.browserTypes).equals(other.browserTypes)) {
            return false;
        }
        if (!this.patternToBrowserMap.equals(other.patternToBrowserMap)) {
            return false;
        }
        if (!((Object)this.browserToOperatingSystemMappings).equals(other.browserToOperatingSystemMappings)) {
            return false;
        }
        if (!((Object)this.operatingSystems).equals(other.operatingSystems)) {
            return false;
        }
        if (!((Object)this.operatingSystemPatterns).equals(other.operatingSystemPatterns)) {
            return false;
        }
        if (!this.patternToOperatingSystemMap.equals(other.patternToOperatingSystemMap)) {
            return false;
        }
        if (!((Object)this.robots).equals(other.robots)) {
            return false;
        }
        if (!((Object)this.devices).equals(other.devices)) {
            return false;
        }
        if (!((Object)this.devicePatterns).equals(other.devicePatterns)) {
            return false;
        }
        if (!this.patternToDeviceMap.equals(other.patternToDeviceMap)) {
            return false;
        }
        return this.version.equals(other.version);
    }

    @Nonnull
    public Map<Integer, SortedSet<BrowserPattern>> getBrowserPatterns() {
        return this.browserPatterns;
    }

    @Nonnull
    public Set<Browser> getBrowsers() {
        return this.browsers;
    }

    @Nonnull
    public Set<BrowserOperatingSystemMapping> getBrowserToOperatingSystemMappings() {
        return this.browserToOperatingSystemMappings;
    }

    @Nonnull
    public Map<Integer, BrowserType> getBrowserTypes() {
        return this.browserTypes;
    }

    @Nonnull
    public Map<Integer, SortedSet<DevicePattern>> getDevicePatterns() {
        return this.devicePatterns;
    }

    @Nonnull
    public Set<Device> getDevices() {
        return this.devices;
    }

    @Nonnull
    public Map<Integer, SortedSet<OperatingSystemPattern>> getOperatingSystemPatterns() {
        return this.operatingSystemPatterns;
    }

    @Nonnull
    public Set<OperatingSystem> getOperatingSystems() {
        return this.operatingSystems;
    }

    @Nonnull
    public SortedMap<BrowserPattern, Browser> getPatternToBrowserMap() {
        return this.patternToBrowserMap;
    }

    @Nonnull
    public SortedMap<DevicePattern, Device> getPatternToDeviceMap() {
        return this.patternToDeviceMap;
    }

    @Nonnull
    public SortedMap<OperatingSystemPattern, OperatingSystem> getPatternToOperatingSystemMap() {
        return this.patternToOperatingSystemMap;
    }

    @Nonnull
    public List<Robot> getRobots() {
        return this.robots;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this.browsers).hashCode();
        result = 31 * result + ((Object)this.browserPatterns).hashCode();
        result = 31 * result + ((Object)this.browserTypes).hashCode();
        result = 31 * result + this.patternToBrowserMap.hashCode();
        result = 31 * result + ((Object)this.browserToOperatingSystemMappings).hashCode();
        result = 31 * result + ((Object)this.operatingSystems).hashCode();
        result = 31 * result + ((Object)this.operatingSystemPatterns).hashCode();
        result = 31 * result + this.patternToOperatingSystemMap.hashCode();
        result = 31 * result + ((Object)this.robots).hashCode();
        result = 31 * result + ((Object)this.devices).hashCode();
        result = 31 * result + ((Object)this.devicePatterns).hashCode();
        result = 31 * result + this.patternToDeviceMap.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    @Nonnull
    public String toStats() {
        StringBuilder builder = new StringBuilder();
        builder.append("UAS data stats\n");
        builder.append("----------------------------------------------------------------");
        builder.append('\n');
        builder.append("version:\t\t");
        builder.append(this.version);
        builder.append('\n');
        builder.append("browser:\t\t");
        builder.append(this.browsers.size());
        builder.append('\n');
        HashMap<String, AtomicInteger> browserByType = new HashMap<String, AtomicInteger>();
        for (Browser browser : this.browsers) {
            AtomicInteger counter = (AtomicInteger)browserByType.get(browser.getType().getName());
            if (counter == null) {
                browserByType.put(browser.getType().getName(), new AtomicInteger(1));
                continue;
            }
            counter.incrementAndGet();
        }
        for (Map.Entry entry : browserByType.entrySet()) {
            builder.append('\t');
            builder.append('\t');
            builder.append('\t');
            builder.append((String)entry.getKey());
            builder.append(":\t");
            builder.append(((AtomicInteger)entry.getValue()).get());
            builder.append('\n');
        }
        builder.append("browser patterns:\t");
        builder.append(this.patternToBrowserMap.size());
        builder.append('\n');
        builder.append("operating systems:\t");
        builder.append(this.operatingSystems.size());
        builder.append('\n');
        builder.append("os patterns:\t\t");
        builder.append(this.patternToOperatingSystemMap.size());
        builder.append('\n');
        builder.append("robots:\t\t\t");
        builder.append(this.robots.size());
        builder.append('\n');
        builder.append("devices:\t");
        builder.append(this.devices.size());
        builder.append('\n');
        builder.append("device patterns:\t");
        builder.append(this.patternToDeviceMap.size());
        builder.append('\n');
        builder.append("----------------------------------------------------------------");
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Data [browsers=");
        builder.append(this.browsers);
        builder.append(", browserPatterns=");
        builder.append(this.browserPatterns);
        builder.append(", browserTypes=");
        builder.append(this.browserTypes);
        builder.append(", patternToBrowserMap=");
        builder.append(this.patternToBrowserMap);
        builder.append(", browserToOperatingSystemMap=");
        builder.append(this.browserToOperatingSystemMappings);
        builder.append(", operatingSystems=");
        builder.append(this.operatingSystems);
        builder.append(", operatingSystemPatterns=");
        builder.append(this.operatingSystemPatterns);
        builder.append(", patternToOperatingSystemMap=");
        builder.append(this.patternToOperatingSystemMap);
        builder.append(", robots=");
        builder.append(this.robots);
        builder.append(", devices=");
        builder.append(this.devices);
        builder.append(", devicePatterns=");
        builder.append(this.devicePatterns);
        builder.append(", patternToDeviceMap=");
        builder.append(this.patternToDeviceMap);
        builder.append(", version=");
        builder.append(this.version);
        builder.append("]");
        return builder.toString();
    }
}

