/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.contrib.beans.BeanMapperException;
import org.jdom2.contrib.beans.StringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMapper {
    protected String beanPackage;
    protected Namespace namespace;
    protected boolean ignoreMissingProperties = false;
    protected boolean ignoreNullProperties = true;
    protected List<Mapping> mappings = new ArrayList<Mapping>();
    protected StringConverter stringconverter = new StringConverter();
    protected Set<String> ignoredProperties = new HashSet<String>();
    protected Set<String> ignoredElements = new HashSet<String>();
    protected Set<String> ignoredAttributes = new HashSet<String>();
    public static int debug = 0;

    public void setBeanPackage(String beanPackage) {
        this.beanPackage = beanPackage;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public StringConverter getStringConverter() {
        return this.stringconverter;
    }

    public void setStringConverter(StringConverter stringconverter) {
        this.stringconverter = stringconverter;
    }

    public void setIgnoreNullProperties(boolean b) {
        this.ignoreNullProperties = b;
    }

    public void setIgnoreMissingProperties(boolean b) {
        this.ignoreMissingProperties = b;
    }

    public Document toDocument(Object bean) throws BeanMapperException {
        return this.toDocument(bean, null);
    }

    public Document toDocument(Object bean, String elementName) throws BeanMapperException {
        Element root = this.toElement(bean, elementName);
        Document doc = new Document(root);
        return doc;
    }

    public Element toElement(Object bean) throws BeanMapperException {
        return this.toElement(bean, null);
    }

    public Element toElement(Object bean, String elementName) throws BeanMapperException {
        Element element;
        BeanInfo info;
        try {
            info = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new BeanMapperException("Mapping bean " + bean, e);
        }
        if (elementName != null) {
            element = this.createElement(elementName);
        } else {
            Class<?> beanclass = info.getBeanDescriptor().getBeanClass();
            String beanname = BeanMapper.unpackage(beanclass.getName());
            element = this.createElement(beanname);
        }
        PropertyDescriptor[] properties = info.getPropertyDescriptors();
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor prop = properties[i];
            String propertyName = prop.getName();
            Method method = prop.getReadMethod();
            if (method.getName().equals("getClass") && prop.getPropertyType().getName().equals("java.lang.Class") || this.isIgnoredProperty(propertyName)) continue;
            Mapping mapping = this.getMappingForProperty(propertyName);
            if (method.getParameterTypes().length != 0) continue;
            Object valueObject = null;
            try {
                Object[] args = new Object[]{};
                valueObject = method.invoke(bean, args);
            }
            catch (IllegalAccessException e) {
                throw new BeanMapperException("Mapping " + propertyName, e);
            }
            catch (InvocationTargetException e) {
                throw new BeanMapperException("Mapping " + propertyName, e);
            }
            Object value = this.convertValue(valueObject);
            if (value == null && this.ignoreNullProperties) {
                BeanMapper.debug("Ignoring null " + propertyName);
                continue;
            }
            String childElementName = mapping == null ? propertyName : mapping.element;
            Element child = null;
            if (childElementName != null && (child = this.namespace != null ? element.getChild(childElementName, this.namespace) : element.getChild(childElementName)) == null) {
                child = this.createElement(childElementName);
                element.addContent((Content)child);
            }
            if (mapping == null || mapping.attribute == null) {
                this.setElementValue(propertyName, childElementName, element, child, value);
                continue;
            }
            try {
                if (value == null) {
                    value = "";
                }
                if (childElementName == null) {
                    element.setAttribute(mapping.attribute, (String)value);
                    continue;
                }
                child.setAttribute(mapping.attribute, (String)value);
                continue;
            }
            catch (ClassCastException e) {
                throw new BeanMapperException("Can't set type " + value.getClass() + " as attribute");
            }
        }
        return element;
    }

    protected Object convertValue(Object value) throws BeanMapperException {
        Object result;
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        String classname = type.getName();
        if (classname.startsWith("java.lang.") || classname.equals("java.util.Date")) {
            result = value.toString();
        } else if (type.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object item = Array.get(value, i);
                list.add(this.convertValue(item));
            }
            result = list;
        } else {
            BeanMapper.debug("Recurse on bean " + classname + "=" + value);
            result = this.toElement(value);
        }
        return result;
    }

    protected void setElementValue(String propertyName, String elementName, Element parent, Element child, Object value) throws BeanMapperException {
        BeanMapper.debug("setElementValue(" + propertyName + "," + elementName + "," + child.getName() + "," + value + ")");
        if (value != null) {
            if (value instanceof Element) {
                child.addContent((Content)((Element)value));
            } else if (value instanceof String) {
                child.setText((String)value);
            } else if (value instanceof List) {
                for (Object item : (List)value) {
                    if (child == null) {
                        child = this.createElement(elementName);
                        parent.addContent((Content)child);
                    }
                    this.setElementValue(propertyName, elementName, parent, child, item);
                    child = null;
                }
            } else {
                throw new BeanMapperException("Unknown result type for property " + propertyName + ": " + value);
            }
        }
    }

    public Object toBean(Document document) throws BeanMapperException {
        return this.toBean(document.getRootElement());
    }

    public Object toBean(Element element) throws BeanMapperException {
        String propertyName;
        Mapping mapping;
        Object bean = this.instantiateBean(element.getName());
        HashSet<String> alreadySet = new HashSet<String>();
        if (element.hasAttributes()) {
            for (Attribute attribute : element.getAttributes()) {
                BeanMapper.debug("Mapping " + attribute);
                mapping = this.getMappingForAttribute(null, attribute.getName());
                propertyName = mapping == null ? attribute.getName() : mapping.property;
                this.setProperty(bean, propertyName, attribute.getValue());
            }
        }
        for (Element child : element.getChildren()) {
            BeanMapper.debug("Mapping " + child);
            mapping = this.getMappingForElement(child.getName());
            propertyName = mapping == null ? child.getName() : mapping.property;
            PropertyDescriptor property = this.findPropertyDescriptor(bean, propertyName);
            if (property != null && !alreadySet.contains(child.getName())) {
                if (property.getPropertyType().isArray()) {
                    this.setProperty(bean, property, element, child);
                } else {
                    this.setProperty(bean, property, element, child);
                }
            }
            for (Attribute attribute : child.getAttributes()) {
                BeanMapper.debug("Mapping " + attribute);
                mapping = this.getMappingForAttribute(child.getName(), attribute.getName());
                propertyName = mapping == null ? attribute.getName() : mapping.property;
                this.setProperty(bean, propertyName, attribute.getValue());
            }
            alreadySet.add(child.getName());
        }
        return bean;
    }

    protected Object instantiateBean(String elementName) throws BeanMapperException {
        String className = null;
        try {
            Class<?> beanClass;
            Mapping mapping = this.getMappingForElement(elementName);
            if (mapping != null && mapping.type != null) {
                beanClass = mapping.type;
            } else {
                className = this.getBeanClassName(this.beanPackage, elementName);
                beanClass = Class.forName(className);
            }
            Object bean = beanClass.newInstance();
            return bean;
        }
        catch (ClassNotFoundException e) {
            throw new BeanMapperException("Class " + className + " not found instantiating " + elementName + " - maybe you need to add a mapping, or add a bean package", e);
        }
        catch (Exception e) {
            throw new BeanMapperException("Instantiating " + elementName, e);
        }
    }

    protected String getBeanClassName(String pbeanPackage, String elementName) {
        return (pbeanPackage == null ? "" : pbeanPackage + ".") + Character.toUpperCase(elementName.charAt(0)) + elementName.substring(1);
    }

    protected PropertyDescriptor findPropertyDescriptor(Object bean, String propertyName) throws BeanMapperException {
        try {
            BeanInfo info = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                PropertyDescriptor prop = properties[i];
                if (!prop.getName().equals(propertyName)) continue;
                return prop;
            }
        }
        catch (Exception e) {
            throw new BeanMapperException("Finding property " + propertyName + " for bean " + bean.getClass(), e);
        }
        if (this.ignoreMissingProperties) {
            return null;
        }
        throw new BeanMapperException("Missing property: " + propertyName + " in bean " + bean.getClass() + ": " + bean);
    }

    protected boolean setProperty(Object bean, String propertyName, Object value) throws BeanMapperException {
        return this.setProperty(bean, this.findPropertyDescriptor(bean, propertyName), null, value);
    }

    protected boolean setProperty(Object bean, PropertyDescriptor property, Element parent, Object value) throws BeanMapperException {
        if (property == null) {
            return false;
        }
        BeanMapper.debug("setProperty: bean=" + bean + " property=" + property.getName() + " value=" + value);
        try {
            Object valueObject;
            if (property.getPropertyType().isArray()) {
                Element child = (Element)value;
                List children = parent.getChildren(child.getName());
                valueObject = this.buildArray(property, children);
            } else {
                valueObject = this.convertJDOMValue(value, property.getPropertyType());
            }
            Method setter = property.getWriteMethod();
            Class<?>[] params = setter.getParameterTypes();
            if (params.length > 1) {
                throw new BeanMapperException("Setter takes multiple parameters: " + bean.getClass() + "." + setter.getName());
            }
            Class<?> param = params[0];
            if (param != property.getPropertyType()) {
                BeanMapper.debug("Weird: setter takes " + param + ", property is " + property.getPropertyType());
            }
            BeanMapper.debug("Invoking setter: " + setter.getName() + "(" + valueObject + ")");
            setter.invoke(bean, valueObject);
            return true;
        }
        catch (BeanMapperException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanMapperException("Setting property " + property.getName() + "=" + value + " in " + bean.getClass(), e);
        }
    }

    protected Object convertString(String value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (type == String.class) {
            return value;
        }
        return this.stringconverter.parse(value, type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object convertJDOMValue(Object value, Class<?> type) throws BeanMapperException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.convertString((String)value, type);
        }
        if (!(value instanceof Element)) throw new BeanMapperException("Can't map unknown type: " + value.getClass() + "=" + value);
        Element element = (Element)value;
        if (type == Element.class) {
            return value;
        }
        if (element.getChildren().isEmpty()) {
            return this.convertString(element.getText(), type);
        }
        if (element.getChildren().size() != 1) throw new BeanMapperException("Mapping of multiple child elements not implemented for " + element.getName());
        return this.toBean((Element)element.getChildren().get(0));
    }

    protected Object buildArray(PropertyDescriptor property, List<Element> children) throws BeanMapperException {
        Class<?> arrayClass = property.getPropertyType();
        Class<?> itemClass = arrayClass.getComponentType();
        if (itemClass == null) {
            throw new BeanMapperException("Can't instantiate array of type " + arrayClass);
        }
        Object array = Array.newInstance(itemClass, children.size());
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            Object value = this.convertJDOMValue(child, itemClass);
            BeanMapper.debug(itemClass + "[" + i + "]=" + value);
            Array.set(array, i, value);
        }
        return array;
    }

    public static Class<?> getArrayItemClass(Class<?> arrayClass) throws ClassNotFoundException {
        String arrayClassName = arrayClass.getName();
        BeanMapper.debug("Parsing array classname: " + arrayClassName);
        Class<Object> itemClass = arrayClassName.equals("[B") ? Byte.TYPE : (arrayClassName.equals("[C") ? Character.TYPE : (arrayClassName.equals("[D") ? Double.TYPE : (arrayClassName.equals("[F") ? Float.TYPE : (arrayClassName.equals("[I") ? Integer.TYPE : (arrayClassName.equals("[J") ? Long.TYPE : (arrayClassName.equals("[S") ? Short.TYPE : (arrayClassName.equals("[Z") ? Boolean.TYPE : (arrayClassName.startsWith("[L") ? Class.forName(arrayClassName.substring(2, arrayClassName.length() - 1)) : null))))))));
        return itemClass;
    }

    public void addMapping(String property, String element) {
        this.addMapping(new Mapping(property, null, element, null));
    }

    public void addMapping(String property, String element, String attribute) {
        this.addMapping(new Mapping(property, null, element, attribute));
    }

    public void addMapping(String property, Class<?> type, String element, String attribute) {
        this.addMapping(new Mapping(property, type, element, attribute));
    }

    public void addMapping(Mapping mapping) {
        this.mappings.add(mapping);
    }

    public Mapping getMappingForProperty(String property) {
        for (Mapping m : this.mappings) {
            if (m.property == null || !m.property.equals(property)) continue;
            return m;
        }
        return null;
    }

    public Mapping getMappingForElement(String element) {
        for (Mapping m : this.mappings) {
            if (!m.element.equals(element)) continue;
            return m;
        }
        return null;
    }

    public Mapping getMappingForAttribute(String element, String attribute) {
        for (Mapping m : this.mappings) {
            if (m.element == null || m.attribute == null || !m.element.equals(element) || !m.attribute.equals(attribute)) continue;
            return m;
        }
        return null;
    }

    public void ignoreProperty(String property) {
        this.ignoredProperties.add(property);
    }

    public boolean isIgnoredProperty(String property) {
        return this.ignoredProperties.contains(property);
    }

    public void ignoreElement(String element) {
        this.ignoredElements.add(element);
    }

    public boolean isIgnoredElement(String element) {
        return this.ignoredElements.contains(element);
    }

    protected static String toAttributeString(String element, String attribute) {
        return (element == null ? "." : element) + "/@" + attribute;
    }

    public void ignoreAttribute(String element, String attribute) {
        this.ignoredAttributes.add(BeanMapper.toAttributeString(element, attribute));
    }

    public boolean isIgnoredAttribute(String element, String attribute) {
        return this.ignoredAttributes.contains(BeanMapper.toAttributeString(element, attribute));
    }

    protected Element createElement(String elementName) {
        return this.namespace == null ? new Element(elementName) : new Element(elementName, this.namespace);
    }

    protected static String unpackage(String classname) {
        int dot = Math.max(classname.lastIndexOf("."), classname.lastIndexOf("$"));
        if (dot > -1) {
            classname = classname.substring(dot + 1);
        }
        classname = Introspector.decapitalize(classname);
        return classname;
    }

    protected static void debug(String msg) {
        if (debug > 0) {
            System.err.println("BeanMapper: " + msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Mapping {
        public String property;
        public Class<?> type;
        public String element;
        public String attribute;

        public Mapping(String property, Class<?> type, String element, String attribute) {
            this.property = property;
            this.type = type;
            this.element = element;
            this.attribute = attribute;
        }
    }
}

