/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.quantiles;

import org.javasimon.callback.quantiles.BucketSample;

public class BucketsSample {
    private final BucketSample[] buckets;
    private final Double median;
    private final Double percentile90;

    public BucketsSample(BucketSample[] buckets, Double median, Double quantile90) {
        this.buckets = buckets;
        this.median = median;
        this.percentile90 = quantile90;
    }

    public BucketSample[] getBuckets() {
        return this.buckets;
    }

    public Double getMedian() {
        return this.median;
    }

    public Double getPercentile90() {
        return this.percentile90;
    }

    private boolean hasNoBuckets() {
        return this.buckets == null || this.buckets.length == 0;
    }

    public Integer getMaxCount() {
        if (this.hasNoBuckets()) {
            return null;
        }
        Integer maxCount = 0;
        for (BucketSample bucket : this.buckets) {
            maxCount = Math.max(bucket.getCount(), maxCount);
        }
        return maxCount;
    }

    public Integer getTotalCount() {
        if (this.hasNoBuckets()) {
            return null;
        }
        Integer totalCount = 0;
        for (BucketSample bucket : this.buckets) {
            totalCount = totalCount + bucket.getCount();
        }
        return totalCount;
    }
}

