/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CaseClasses<T, V> {
    protected final Class<T> clazz;
    private volatile Collection<T> preDefined = null;
    private Collection<T> runtimeDefined = null;

    public CaseClasses(Class<T> clazz) {
        this.clazz = clazz;
    }

    protected abstract T create(V var1);

    protected abstract boolean matches(T var1, V var2);

    public T find(V value) {
        this.checkInit();
        for (T obj : this.preDefined) {
            if (!this.matches(obj, value)) continue;
            return obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(V value) {
        T found = this.find(value);
        if (found != null) {
            return found;
        }
        Collection<T> collection = this.runtimeDefined;
        synchronized (collection) {
            for (T obj : this.runtimeDefined) {
                if (!this.matches(obj, value)) continue;
                return obj;
            }
            T created = this.create(value);
            this.runtimeDefined.add(created);
            return created;
        }
    }

    public Collection<T> all() {
        this.checkInit();
        return this.preDefined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInit() {
        if (this.preDefined == null) {
            CaseClasses caseClasses = this;
            synchronized (caseClasses) {
                if (this.preDefined == null) {
                    this.init();
                }
            }
        }
    }

    private void init() {
        ArrayList<T> preDefined = new ArrayList<T>();
        for (Field field : this.clazz.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || field.getDeclaringClass() != this.clazz || field.getType() != this.clazz) continue;
            try {
                Object obj = field.get(null);
                if (obj == null) continue;
                T c = this.clazz.cast(obj);
                preDefined.add(c);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.runtimeDefined = new ArrayList<T>(0);
        this.preDefined = Collections.unmodifiableCollection(preDefined);
    }
}

