/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonValue {
    private final boolean isNull;
    private final Object value;
    private final List<JsonValue> array;
    private final Map<String, JsonValue> object;

    public JsonValue(Object value) {
        this.value = value;
        this.array = null;
        this.object = null;
        this.isNull = value == null;
    }

    public JsonValue(List<JsonValue> array) {
        this.array = array;
        this.value = null;
        this.object = null;
        this.isNull = array == null;
    }

    public JsonValue(Map<String, JsonValue> object) {
        this.object = object;
        this.value = null;
        this.array = null;
        this.isNull = object == null;
    }

    public Object getValue() {
        return this.value;
    }

    public List<JsonValue> getArray() {
        return this.array;
    }

    public Map<String, JsonValue> getObject() {
        return this.object;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.array == null ? 0 : this.array.hashCode());
        result = 31 * result + (this.isNull ? 1231 : 1237);
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonValue other = (JsonValue)obj;
        if (this.array == null ? other.array != null : !this.array.equals(other.array)) {
            return false;
        }
        if (this.isNull != other.isNull) {
            return false;
        }
        if (this.object == null ? other.object != null : !this.object.equals(other.object)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        if (this.isNull) {
            return "NULL";
        }
        if (this.value != null) {
            return "VALUE = " + this.value;
        }
        if (this.array != null) {
            return "ARRAY = " + this.array;
        }
        if (this.object != null) {
            return "OBJECT = " + this.object;
        }
        return "";
    }
}

