/*
 * Decompiled with CFR 0.152.
 */
package ezvcard;

import ezvcard.Ezvcard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarnings;
import ezvcard.Warning;
import ezvcard.parameter.EmailType;
import ezvcard.parameter.TelephoneType;
import ezvcard.property.Address;
import ezvcard.property.Agent;
import ezvcard.property.Anniversary;
import ezvcard.property.Birthday;
import ezvcard.property.Birthplace;
import ezvcard.property.CalendarRequestUri;
import ezvcard.property.CalendarUri;
import ezvcard.property.Categories;
import ezvcard.property.Classification;
import ezvcard.property.ClientPidMap;
import ezvcard.property.Deathdate;
import ezvcard.property.Deathplace;
import ezvcard.property.Email;
import ezvcard.property.Expertise;
import ezvcard.property.FormattedName;
import ezvcard.property.FreeBusyUrl;
import ezvcard.property.Gender;
import ezvcard.property.Geo;
import ezvcard.property.HasAltId;
import ezvcard.property.Hobby;
import ezvcard.property.Impp;
import ezvcard.property.Interest;
import ezvcard.property.Key;
import ezvcard.property.Kind;
import ezvcard.property.Label;
import ezvcard.property.Language;
import ezvcard.property.Logo;
import ezvcard.property.Mailer;
import ezvcard.property.Member;
import ezvcard.property.Nickname;
import ezvcard.property.Note;
import ezvcard.property.OrgDirectory;
import ezvcard.property.Organization;
import ezvcard.property.Photo;
import ezvcard.property.ProductId;
import ezvcard.property.Profile;
import ezvcard.property.RawProperty;
import ezvcard.property.Related;
import ezvcard.property.Revision;
import ezvcard.property.Role;
import ezvcard.property.SortString;
import ezvcard.property.Sound;
import ezvcard.property.Source;
import ezvcard.property.SourceDisplayText;
import ezvcard.property.StructuredName;
import ezvcard.property.Telephone;
import ezvcard.property.Timezone;
import ezvcard.property.Title;
import ezvcard.property.Uid;
import ezvcard.property.Url;
import ezvcard.property.VCardProperty;
import ezvcard.property.Xml;
import ezvcard.util.ListMultimap;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCard
implements Iterable<VCardProperty> {
    private VCardVersion version = VCardVersion.V3_0;
    private final ListMultimap<Class<? extends VCardProperty>, VCardProperty> properties = new ListMultimap();

    public String write() {
        return Ezvcard.write(this).go();
    }

    public void write(File file) throws IOException {
        Ezvcard.write(this).go(file);
    }

    public void write(OutputStream out) throws IOException {
        Ezvcard.write(this).go(out);
    }

    public void write(Writer writer) throws IOException {
        Ezvcard.write(this).go(writer);
    }

    public String writeXml() {
        return Ezvcard.writeXml(this).indent(2).go();
    }

    public void writeXml(File file) throws IOException, TransformerException {
        Ezvcard.writeXml(this).indent(2).go(file);
    }

    public void writeXml(OutputStream out) throws TransformerException {
        Ezvcard.writeXml(this).indent(2).go(out);
    }

    public void writeXml(Writer writer) throws TransformerException {
        Ezvcard.writeXml(this).indent(2).go(writer);
    }

    public String writeHtml() {
        return Ezvcard.writeHtml(this).go();
    }

    public void writeHtml(File file) throws IOException {
        Ezvcard.writeHtml(this).go(file);
    }

    public void writeHtml(OutputStream out) throws IOException {
        Ezvcard.writeHtml(this).go(out);
    }

    public void writeHtml(Writer writer) throws IOException {
        Ezvcard.writeHtml(this).go(writer);
    }

    public String writeJson() {
        return Ezvcard.writeJson(this).go();
    }

    public void writeJson(File file) throws IOException {
        Ezvcard.writeJson(this).go(file);
    }

    public void writeJson(OutputStream out) throws IOException {
        Ezvcard.writeJson(this).go(out);
    }

    public void writeJson(Writer writer) throws IOException {
        Ezvcard.writeJson(this).go(writer);
    }

    public VCardVersion getVersion() {
        return this.version;
    }

    public void setVersion(VCardVersion version) {
        this.version = version;
    }

    public Kind getKind() {
        return this.getProperty(Kind.class);
    }

    public void setKind(Kind kind) {
        this.setProperty(Kind.class, kind);
    }

    public Gender getGender() {
        return this.getProperty(Gender.class);
    }

    public void setGender(Gender gender) {
        this.setProperty(Gender.class, gender);
    }

    public List<Member> getMembers() {
        return this.getProperties(Member.class);
    }

    public void addMember(Member member) {
        this.addProperty(member);
    }

    public void addMemberAlt(Collection<Member> altRepresentations) {
        this.addPropertyAlt(Member.class, altRepresentations);
    }

    public void addMemberAlt(Member ... altRepresentations) {
        this.addPropertyAlt(Member.class, altRepresentations);
    }

    public Profile getProfile() {
        return this.getProperty(Profile.class);
    }

    public void setProfile(Profile profile) {
        this.setProperty(Profile.class, profile);
    }

    public Classification getClassification() {
        return this.getProperty(Classification.class);
    }

    public void setClassification(Classification classification) {
        this.setProperty(Classification.class, classification);
    }

    public Classification setClassification(String classification) {
        Classification type = null;
        if (classification != null) {
            type = new Classification(classification);
        }
        this.setClassification(type);
        return type;
    }

    public List<Source> getSources() {
        return this.getProperties(Source.class);
    }

    public void addSource(Source source) {
        this.addProperty(source);
    }

    public Source addSource(String source) {
        Source type = new Source(source);
        this.addSource(type);
        return type;
    }

    public void addSourceAlt(Collection<Source> altRepresentations) {
        this.addPropertyAlt(Source.class, altRepresentations);
    }

    public void addSourceAlt(Source ... altRepresentations) {
        this.addPropertyAlt(Source.class, altRepresentations);
    }

    public SourceDisplayText getSourceDisplayText() {
        return this.getProperty(SourceDisplayText.class);
    }

    public void setSourceDisplayText(SourceDisplayText sourceDisplayText) {
        this.setProperty(SourceDisplayText.class, sourceDisplayText);
    }

    public SourceDisplayText setSourceDisplayText(String sourceDisplayText) {
        SourceDisplayText type = null;
        if (sourceDisplayText != null) {
            type = new SourceDisplayText(sourceDisplayText);
        }
        this.setSourceDisplayText(type);
        return type;
    }

    public List<FormattedName> getFormattedNames() {
        return this.getProperties(FormattedName.class);
    }

    public FormattedName getFormattedName() {
        return this.getProperty(FormattedName.class);
    }

    public void setFormattedNameAlt(Collection<FormattedName> altRepresentations) {
        this.setPropertyAlt(FormattedName.class, altRepresentations);
    }

    public void setFormattedNameAlt(FormattedName ... altRepresentations) {
        this.setPropertyAlt(FormattedName.class, altRepresentations);
    }

    public void addFormattedNameAlt(Collection<FormattedName> altRepresentations) {
        this.addPropertyAlt(FormattedName.class, altRepresentations);
    }

    public void addFormattedNameAlt(FormattedName ... altRepresentations) {
        this.addPropertyAlt(FormattedName.class, altRepresentations);
    }

    public void setFormattedName(FormattedName formattedName) {
        this.setProperty(FormattedName.class, formattedName);
    }

    public void addFormattedName(FormattedName formattedName) {
        this.addProperty(formattedName);
    }

    public FormattedName setFormattedName(String formattedName) {
        FormattedName type = null;
        if (formattedName != null) {
            type = new FormattedName(formattedName);
        }
        this.setFormattedName(type);
        return type;
    }

    public List<StructuredName> getStructuredNames() {
        return this.getProperties(StructuredName.class);
    }

    public StructuredName getStructuredName() {
        return this.getProperty(StructuredName.class);
    }

    public void setStructuredNameAlt(Collection<StructuredName> altRepresentations) {
        this.setPropertyAlt(StructuredName.class, altRepresentations);
    }

    public void setStructuredNameAlt(StructuredName ... altRepresentations) {
        this.setPropertyAlt(StructuredName.class, altRepresentations);
    }

    public void setStructuredName(StructuredName structuredName) {
        this.setProperty(StructuredName.class, structuredName);
    }

    public List<Nickname> getNicknames() {
        return this.getProperties(Nickname.class);
    }

    public Nickname getNickname() {
        return this.getProperty(Nickname.class);
    }

    public void setNicknameAlt(Collection<Nickname> altRepresentations) {
        this.setPropertyAlt(Nickname.class, altRepresentations);
    }

    public void setNicknameAlt(Nickname ... altRepresentations) {
        this.setPropertyAlt(Nickname.class, altRepresentations);
    }

    public void addNicknameAlt(Collection<Nickname> altRepresentations) {
        this.addPropertyAlt(Nickname.class, altRepresentations);
    }

    public void addNicknameAlt(Nickname ... altRepresentations) {
        this.addPropertyAlt(Nickname.class, altRepresentations);
    }

    public void setNickname(Nickname nickname) {
        this.setProperty(Nickname.class, nickname);
    }

    public void addNickname(Nickname nickname) {
        this.addProperty(nickname);
    }

    public Nickname setNickname(String ... nicknames) {
        Nickname type = null;
        if (nicknames != null) {
            type = new Nickname();
            for (String nickname : nicknames) {
                type.addValue(nickname);
            }
        }
        this.setNickname(type);
        return type;
    }

    public SortString getSortString() {
        return this.getProperty(SortString.class);
    }

    public void setSortString(SortString sortString) {
        this.setProperty(SortString.class, sortString);
    }

    public SortString setSortString(String sortString) {
        SortString type = null;
        if (sortString != null) {
            type = new SortString(sortString);
        }
        this.setSortString(type);
        return type;
    }

    public List<Title> getTitles() {
        return this.getProperties(Title.class);
    }

    public void addTitle(Title title) {
        this.addProperty(title);
    }

    public Title addTitle(String title) {
        Title type = new Title(title);
        this.addTitle(type);
        return type;
    }

    public void addTitleAlt(Collection<Title> altRepresentations) {
        this.addPropertyAlt(Title.class, altRepresentations);
    }

    public void addTitleAlt(Title ... altRepresentations) {
        this.addPropertyAlt(Title.class, altRepresentations);
    }

    public List<Role> getRoles() {
        return this.getProperties(Role.class);
    }

    public void addRole(Role role) {
        this.addProperty(role);
    }

    public Role addRole(String role) {
        Role type = new Role(role);
        this.addRole(type);
        return type;
    }

    public void addRoleAlt(Collection<Role> altRepresentations) {
        this.addPropertyAlt(Role.class, altRepresentations);
    }

    public void addRoleAlt(Role ... altRepresentations) {
        this.addPropertyAlt(Role.class, altRepresentations);
    }

    public List<Photo> getPhotos() {
        return this.getProperties(Photo.class);
    }

    public void addPhoto(Photo photo) {
        this.addProperty(photo);
    }

    public void addPhotoAlt(Collection<Photo> altRepresentations) {
        this.addPropertyAlt(Photo.class, altRepresentations);
    }

    public void addPhotoAlt(Photo ... altRepresentations) {
        this.addPropertyAlt(Photo.class, altRepresentations);
    }

    public List<Logo> getLogos() {
        return this.getProperties(Logo.class);
    }

    public void addLogo(Logo logo) {
        this.addProperty(logo);
    }

    public void addLogoAlt(Collection<Logo> altRepresentations) {
        this.addPropertyAlt(Logo.class, altRepresentations);
    }

    public void addLogoAlt(Logo ... altRepresentations) {
        this.addPropertyAlt(Logo.class, altRepresentations);
    }

    public List<Sound> getSounds() {
        return this.getProperties(Sound.class);
    }

    public void addSound(Sound sound) {
        this.addProperty(sound);
    }

    public void addSoundAlt(Collection<Sound> altRepresentations) {
        this.addPropertyAlt(Sound.class, altRepresentations);
    }

    public void addSoundAlt(Sound ... altRepresentations) {
        this.addPropertyAlt(Sound.class, altRepresentations);
    }

    public List<Birthplace> getBirthplaces() {
        return this.getProperties(Birthplace.class);
    }

    public Birthplace getBirthplace() {
        return this.getProperty(Birthplace.class);
    }

    public void setBirthplaceAlt(Collection<Birthplace> altRepresentations) {
        this.setPropertyAlt(Birthplace.class, altRepresentations);
    }

    public void setBirthplaceAlt(Birthplace ... altRepresentations) {
        this.setPropertyAlt(Birthplace.class, altRepresentations);
    }

    public void setBirthplace(Birthplace birthplace) {
        this.setProperty(Birthplace.class, birthplace);
    }

    public List<Deathplace> getDeathplaces() {
        return this.getProperties(Deathplace.class);
    }

    public Deathplace getDeathplace() {
        return this.getProperty(Deathplace.class);
    }

    public void setDeathplaceAlt(Collection<Deathplace> altRepresentations) {
        this.setPropertyAlt(Deathplace.class, altRepresentations);
    }

    public void setDeathplaceAlt(Deathplace ... altRepresentations) {
        this.setPropertyAlt(Deathplace.class, altRepresentations);
    }

    public void setDeathplace(Deathplace deathplace) {
        this.setProperty(Deathplace.class, deathplace);
    }

    public List<Deathdate> getDeathdates() {
        return this.getProperties(Deathdate.class);
    }

    public Deathdate getDeathdate() {
        return this.getProperty(Deathdate.class);
    }

    public void setDeathdateAlt(Collection<Deathdate> altRepresentations) {
        this.setPropertyAlt(Deathdate.class, altRepresentations);
    }

    public void setDeathdateAlt(Deathdate ... altRepresentations) {
        this.setPropertyAlt(Deathdate.class, altRepresentations);
    }

    public void setDeathdate(Deathdate deathdate) {
        this.setProperty(Deathdate.class, deathdate);
    }

    public List<Birthday> getBirthdays() {
        return this.getProperties(Birthday.class);
    }

    public Birthday getBirthday() {
        return this.getProperty(Birthday.class);
    }

    public void setBirthdayAlt(Collection<Birthday> altRepresentations) {
        this.setPropertyAlt(Birthday.class, altRepresentations);
    }

    public void setBirthdayAlt(Birthday ... altRepresentations) {
        this.setPropertyAlt(Birthday.class, altRepresentations);
    }

    public void setBirthday(Birthday birthday) {
        this.setProperty(Birthday.class, birthday);
    }

    public List<Anniversary> getAnniversaries() {
        return this.getProperties(Anniversary.class);
    }

    public Anniversary getAnniversary() {
        return this.getProperty(Anniversary.class);
    }

    public void setAnniversaryAlt(Collection<Anniversary> altRepresentations) {
        this.setPropertyAlt(Anniversary.class, altRepresentations);
    }

    public void setAnniversaryAlt(Anniversary ... altRepresentations) {
        this.setPropertyAlt(Anniversary.class, altRepresentations);
    }

    public void setAnniversary(Anniversary anniversary) {
        this.setProperty(Anniversary.class, anniversary);
    }

    public Revision getRevision() {
        return this.getProperty(Revision.class);
    }

    public void setRevision(Revision rev) {
        this.setProperty(Revision.class, rev);
    }

    public Revision setRevision(Date rev) {
        Revision type = null;
        if (rev != null) {
            type = new Revision(rev);
        }
        this.setRevision(type);
        return type;
    }

    public ProductId getProductId() {
        return this.getProperty(ProductId.class);
    }

    public void setProductId(ProductId productId) {
        this.setProperty(ProductId.class, productId);
    }

    public ProductId setProductId(String productId) {
        ProductId type = null;
        if (productId != null) {
            type = new ProductId(productId);
        }
        this.setProductId(type);
        return type;
    }

    public List<Address> getAddresses() {
        return this.getProperties(Address.class);
    }

    public void addAddress(Address address) {
        this.addProperty(address);
    }

    public void addAddressAlt(Collection<Address> altRepresentations) {
        this.addPropertyAlt(Address.class, altRepresentations);
    }

    public void addAddressAlt(Address ... altRepresentations) {
        this.addPropertyAlt(Address.class, altRepresentations);
    }

    public List<Label> getOrphanedLabels() {
        return this.getProperties(Label.class);
    }

    public void addOrphanedLabel(Label label) {
        this.addProperty(label);
    }

    public List<Email> getEmails() {
        return this.getProperties(Email.class);
    }

    public void addEmail(Email email) {
        this.addProperty(email);
    }

    public Email addEmail(String email, EmailType ... types) {
        Email type = new Email(email);
        for (EmailType t : types) {
            type.addType(t);
        }
        this.addEmail(type);
        return type;
    }

    public void addEmailAlt(Collection<Email> altRepresentations) {
        this.addPropertyAlt(Email.class, altRepresentations);
    }

    public void addEmailAlt(Email ... altRepresentations) {
        this.addPropertyAlt(Email.class, altRepresentations);
    }

    public List<Telephone> getTelephoneNumbers() {
        return this.getProperties(Telephone.class);
    }

    public void addTelephoneNumber(Telephone telephoneNumber) {
        this.addProperty(telephoneNumber);
    }

    public Telephone addTelephoneNumber(String telephoneNumber, TelephoneType ... types) {
        Telephone type = new Telephone(telephoneNumber);
        for (TelephoneType t : types) {
            type.addType(t);
        }
        this.addTelephoneNumber(type);
        return type;
    }

    public void addTelephoneNumberAlt(Collection<Telephone> altRepresentations) {
        this.addPropertyAlt(Telephone.class, altRepresentations);
    }

    public void addTelephoneNumberAlt(Telephone ... altRepresentations) {
        this.addPropertyAlt(Telephone.class, altRepresentations);
    }

    public Mailer getMailer() {
        return this.getProperty(Mailer.class);
    }

    public void setMailer(Mailer mailer) {
        this.setProperty(Mailer.class, mailer);
    }

    public Mailer setMailer(String mailer) {
        Mailer type = null;
        if (mailer != null) {
            type = new Mailer(mailer);
        }
        this.setMailer(type);
        return type;
    }

    public List<Url> getUrls() {
        return this.getProperties(Url.class);
    }

    public void addUrl(Url url) {
        this.addProperty(url);
    }

    public Url addUrl(String url) {
        Url type = new Url(url);
        this.addUrl(type);
        return type;
    }

    public void addUrlAlt(Collection<Url> altRepresentations) {
        this.addPropertyAlt(Url.class, altRepresentations);
    }

    public void addUrlAlt(Url ... altRepresentations) {
        this.addPropertyAlt(Url.class, altRepresentations);
    }

    public List<Timezone> getTimezones() {
        return this.getProperties(Timezone.class);
    }

    public Timezone getTimezone() {
        return this.getProperty(Timezone.class);
    }

    public void setTimezoneAlt(Collection<Timezone> altRepresentations) {
        this.setPropertyAlt(Timezone.class, altRepresentations);
    }

    public void setTimezoneAlt(Timezone ... altRepresentations) {
        this.setPropertyAlt(Timezone.class, altRepresentations);
    }

    public void addTimezoneAlt(Collection<Timezone> altRepresentations) {
        this.addPropertyAlt(Timezone.class, altRepresentations);
    }

    public void addTimezoneAlt(Timezone ... altRepresentations) {
        this.addPropertyAlt(Timezone.class, altRepresentations);
    }

    public void setTimezone(Timezone timezone) {
        this.setProperty(Timezone.class, timezone);
    }

    public void addTimezone(Timezone timezone) {
        this.addProperty(timezone);
    }

    public List<Geo> getGeos() {
        return this.getProperties(Geo.class);
    }

    public Geo getGeo() {
        return this.getProperty(Geo.class);
    }

    public void setGeoAlt(Collection<Geo> altRepresentations) {
        this.setPropertyAlt(Geo.class, altRepresentations);
    }

    public void addGeoAlt(Collection<Geo> altRepresentations) {
        this.addPropertyAlt(Geo.class, altRepresentations);
    }

    public void addGeoAlt(Geo ... altRepresentations) {
        this.addPropertyAlt(Geo.class, altRepresentations);
    }

    public void setGeo(Geo geo) {
        this.setProperty(Geo.class, geo);
    }

    public void addGeo(Geo geo) {
        this.addProperty(geo);
    }

    public Geo setGeo(double latitude, double longitude) {
        Geo type = new Geo(latitude, longitude);
        this.setGeo(type);
        return type;
    }

    public List<Organization> getOrganizations() {
        return this.getProperties(Organization.class);
    }

    public Organization getOrganization() {
        return this.getProperty(Organization.class);
    }

    public void setOrganizationAlt(Collection<Organization> altRepresentations) {
        this.setPropertyAlt(Organization.class, altRepresentations);
    }

    public void setOrganizationAlt(Organization ... altRepresentations) {
        this.setPropertyAlt(Organization.class, altRepresentations);
    }

    public void addOrganizationAlt(Collection<Organization> altRepresentations) {
        this.addPropertyAlt(Organization.class, altRepresentations);
    }

    public void addOrganizationAlt(Organization ... altRepresentations) {
        this.addPropertyAlt(Organization.class, altRepresentations);
    }

    public void setOrganization(Organization organization) {
        this.setProperty(Organization.class, organization);
    }

    public void addOrganization(Organization organization) {
        this.addProperty(organization);
    }

    public Organization setOrganization(String ... departments) {
        Organization type = null;
        if (departments != null) {
            type = new Organization();
            for (String department : departments) {
                type.addValue(department);
            }
        }
        this.setOrganization(type);
        return type;
    }

    public List<Categories> getCategoriesList() {
        return this.getProperties(Categories.class);
    }

    public Categories getCategories() {
        return this.getProperty(Categories.class);
    }

    public void setCategoriesAlt(Collection<Categories> altRepresentations) {
        this.setPropertyAlt(Categories.class, altRepresentations);
    }

    public void setCategoriesAlt(Categories ... altRepresentations) {
        this.setPropertyAlt(Categories.class, altRepresentations);
    }

    public void addCategoriesAlt(Collection<Categories> altRepresentations) {
        this.addPropertyAlt(Categories.class, altRepresentations);
    }

    public void addCategoriesAlt(Categories ... altRepresentations) {
        this.addPropertyAlt(Categories.class, altRepresentations);
    }

    public void setCategories(Categories categories) {
        this.setProperty(Categories.class, categories);
    }

    public void addCategories(Categories categories) {
        this.addProperty(categories);
    }

    public Categories setCategories(String ... categories) {
        Categories type = null;
        if (categories != null) {
            type = new Categories();
            for (String category : categories) {
                type.addValue(category);
            }
        }
        this.setCategories(type);
        return type;
    }

    public Agent getAgent() {
        return this.getProperty(Agent.class);
    }

    public void setAgent(Agent agent) {
        this.setProperty(Agent.class, agent);
    }

    public List<Note> getNotes() {
        return this.getProperties(Note.class);
    }

    public void addNote(Note note) {
        this.addProperty(note);
    }

    public Note addNote(String note) {
        Note type = new Note(note);
        this.addNote(type);
        return type;
    }

    public void addNoteAlt(Collection<Note> altRepresentations) {
        this.addPropertyAlt(Note.class, altRepresentations);
    }

    public void addNoteAlt(Note ... altRepresentations) {
        this.addPropertyAlt(Note.class, altRepresentations);
    }

    public Uid getUid() {
        return this.getProperty(Uid.class);
    }

    public void setUid(Uid uid) {
        this.setProperty(Uid.class, uid);
    }

    public List<Key> getKeys() {
        return this.getProperties(Key.class);
    }

    public void addKey(Key key) {
        this.addProperty(key);
    }

    public void addKeyAlt(Collection<Key> altRepresentations) {
        this.addPropertyAlt(Key.class, altRepresentations);
    }

    public void addKeyAlt(Key ... altRepresentations) {
        this.addPropertyAlt(Key.class, altRepresentations);
    }

    public List<Impp> getImpps() {
        return this.getProperties(Impp.class);
    }

    public void addImpp(Impp impp) {
        this.addProperty(impp);
    }

    public void addImppAlt(Collection<Impp> altRepresentations) {
        this.addPropertyAlt(Impp.class, altRepresentations);
    }

    public void addImppAlt(Impp ... altRepresentations) {
        this.addPropertyAlt(Impp.class, altRepresentations);
    }

    public List<Related> getRelations() {
        return this.getProperties(Related.class);
    }

    public void addRelated(Related related) {
        this.addProperty(related);
    }

    public void addRelatedAlt(Collection<Related> altRepresentations) {
        this.addPropertyAlt(Related.class, altRepresentations);
    }

    public void addRelatedAlt(Related ... altRepresentations) {
        this.addPropertyAlt(Related.class, altRepresentations);
    }

    public List<Language> getLanguages() {
        return this.getProperties(Language.class);
    }

    public void addLanguage(Language language) {
        this.addProperty(language);
    }

    public Language addLanguage(String language) {
        Language type = new Language(language);
        this.addLanguage(type);
        return type;
    }

    public void addLanguageAlt(Collection<Language> altRepresentations) {
        this.addPropertyAlt(Language.class, altRepresentations);
    }

    public void addLanguageAlt(Language ... altRepresentations) {
        this.addPropertyAlt(Language.class, altRepresentations);
    }

    public List<CalendarRequestUri> getCalendarRequestUris() {
        return this.getProperties(CalendarRequestUri.class);
    }

    public void addCalendarRequestUri(CalendarRequestUri calendarRequestUri) {
        this.addProperty(calendarRequestUri);
    }

    public void addCalendarRequestUriAlt(Collection<CalendarRequestUri> altRepresentations) {
        this.addPropertyAlt(CalendarRequestUri.class, altRepresentations);
    }

    public void addCalendarRequestUriAlt(CalendarRequestUri ... altRepresentations) {
        this.addPropertyAlt(CalendarRequestUri.class, altRepresentations);
    }

    public List<CalendarUri> getCalendarUris() {
        return this.getProperties(CalendarUri.class);
    }

    public void addCalendarUri(CalendarUri calendarUri) {
        this.addProperty(calendarUri);
    }

    public void addCalendarUriAlt(Collection<CalendarUri> altRepresentations) {
        this.addPropertyAlt(CalendarUri.class, altRepresentations);
    }

    public void addCalendarUriAlt(CalendarUri ... altRepresentations) {
        this.addPropertyAlt(CalendarUri.class, altRepresentations);
    }

    public List<FreeBusyUrl> getFbUrls() {
        return this.getProperties(FreeBusyUrl.class);
    }

    public void addFbUrl(FreeBusyUrl fbUrl) {
        this.addProperty(fbUrl);
    }

    public void addFbUrlAlt(Collection<FreeBusyUrl> altRepresentations) {
        this.addPropertyAlt(FreeBusyUrl.class, altRepresentations);
    }

    public void addFbUrlAlt(FreeBusyUrl ... altRepresentations) {
        this.addPropertyAlt(FreeBusyUrl.class, altRepresentations);
    }

    public List<ClientPidMap> getClientPidMaps() {
        return this.getProperties(ClientPidMap.class);
    }

    public void addClientPidMap(ClientPidMap clientPidMap) {
        this.addProperty(clientPidMap);
    }

    public List<Xml> getXmls() {
        return this.getProperties(Xml.class);
    }

    public void addXml(Xml xml) {
        this.addProperty(xml);
    }

    public void addXmlAlt(Collection<Xml> altRepresentations) {
        this.addPropertyAlt(Xml.class, altRepresentations);
    }

    public void addXmlAlt(Xml ... altRepresentations) {
        this.addPropertyAlt(Xml.class, altRepresentations);
    }

    public List<Expertise> getExpertise() {
        return this.getProperties(Expertise.class);
    }

    public void addExpertise(Expertise expertise) {
        this.addProperty(expertise);
    }

    public Expertise addExpertise(String expertise) {
        Expertise type = new Expertise(expertise);
        this.addExpertise(type);
        return type;
    }

    public void addExpertiseAlt(Collection<Expertise> altRepresentations) {
        this.addPropertyAlt(Expertise.class, altRepresentations);
    }

    public void addExpertiseAlt(Expertise ... altRepresentations) {
        this.addPropertyAlt(Expertise.class, altRepresentations);
    }

    public List<Hobby> getHobbies() {
        return this.getProperties(Hobby.class);
    }

    public void addHobby(Hobby hobby) {
        this.addProperty(hobby);
    }

    public Hobby addHobby(String hobby) {
        Hobby type = new Hobby(hobby);
        this.addHobby(type);
        return type;
    }

    public void addHobbyAlt(Collection<Hobby> altRepresentations) {
        this.addPropertyAlt(Hobby.class, altRepresentations);
    }

    public void addHobbyAlt(Hobby ... altRepresentations) {
        this.addPropertyAlt(Hobby.class, altRepresentations);
    }

    public List<Interest> getInterests() {
        return this.getProperties(Interest.class);
    }

    public void addInterest(Interest interest) {
        this.addProperty(interest);
    }

    public Interest addInterest(String interest) {
        Interest type = new Interest(interest);
        this.addInterest(type);
        return type;
    }

    public void addInterestAlt(Collection<Interest> altRepresentations) {
        this.addPropertyAlt(Interest.class, altRepresentations);
    }

    public void addInterestAlt(Interest ... altRepresentations) {
        this.addPropertyAlt(Interest.class, altRepresentations);
    }

    public List<OrgDirectory> getOrgDirectories() {
        return this.getProperties(OrgDirectory.class);
    }

    public void addOrgDirectory(OrgDirectory orgDirectory) {
        this.addProperty(orgDirectory);
    }

    public OrgDirectory addOrgDirectory(String orgDirectory) {
        OrgDirectory type = new OrgDirectory(orgDirectory);
        this.addOrgDirectory(type);
        return type;
    }

    public void addOrgDirectoryAlt(Collection<OrgDirectory> altRepresentations) {
        this.addPropertyAlt(OrgDirectory.class, altRepresentations);
    }

    public void addOrgDirectoryAlt(OrgDirectory ... altRepresentations) {
        this.addPropertyAlt(OrgDirectory.class, altRepresentations);
    }

    @Override
    public Iterator<VCardProperty> iterator() {
        return this.properties.values().iterator();
    }

    public <T extends VCardProperty> T getProperty(Class<T> clazz) {
        return (T)((VCardProperty)clazz.cast(this.properties.first(clazz)));
    }

    public <T extends VCardProperty> List<T> getProperties(Class<T> clazz) {
        List<VCardProperty> props = this.properties.get(clazz);
        ArrayList<T> ret = new ArrayList<T>(props.size());
        for (VCardProperty property : props) {
            ret.add(clazz.cast(property));
        }
        return ret;
    }

    public <T extends VCardProperty> List<List<T>> getPropertiesAlt(Class<T> clazz) {
        ArrayList<VCardProperty> nullAltId = new ArrayList<VCardProperty>();
        ListMultimap<String, VCardProperty> map = new ListMultimap<String, VCardProperty>();
        for (VCardProperty property : this.getProperties(clazz)) {
            String altId = ((HasAltId)((Object)property)).getAltId();
            if (altId == null) {
                nullAltId.add(property);
                continue;
            }
            map.put(altId, property);
        }
        ArrayList<List<T>> list = new ArrayList<List<T>>();
        for (Map.Entry entry : map) {
            list.add(entry.getValue());
        }
        for (VCardProperty property : nullAltId) {
            ArrayList<VCardProperty> l = new ArrayList<VCardProperty>(1);
            l.add(property);
            list.add(l);
        }
        return list;
    }

    public Collection<VCardProperty> getProperties() {
        return this.properties.values();
    }

    public void addProperty(VCardProperty property) {
        this.properties.put(property.getClass(), property);
    }

    public <T extends VCardProperty> void setProperty(Class<T> clazz, T property) {
        this.properties.replace(clazz, property);
    }

    public void removeProperty(VCardProperty property) {
        this.properties.remove(property.getClass(), property);
    }

    public void removeProperties(Class<? extends VCardProperty> clazz) {
        this.properties.removeAll(clazz);
    }

    public RawProperty getExtendedProperty(String name) {
        for (RawProperty raw : this.getProperties(RawProperty.class)) {
            if (!raw.getPropertyName().equalsIgnoreCase(name)) continue;
            return raw;
        }
        return null;
    }

    public List<RawProperty> getExtendedProperties(String name) {
        ArrayList<RawProperty> props = new ArrayList<RawProperty>();
        for (RawProperty raw : this.getProperties(RawProperty.class)) {
            if (!raw.getPropertyName().equalsIgnoreCase(name)) continue;
            props.add(raw);
        }
        return props;
    }

    public List<RawProperty> getExtendedProperties() {
        return this.getProperties(RawProperty.class);
    }

    public RawProperty addExtendedProperty(String name, String value) {
        RawProperty raw = new RawProperty(name, value);
        this.addProperty(raw);
        return raw;
    }

    public RawProperty setExtendedProperty(String name, String value) {
        this.removeExtendedProperty(name);
        RawProperty raw = new RawProperty(name, value);
        this.addProperty(raw);
        return raw;
    }

    public void removeExtendedProperty(String name) {
        List<RawProperty> xproperties = this.getExtendedProperties(name);
        for (RawProperty xproperty : xproperties) {
            this.properties.remove(xproperty.getClass(), xproperty);
        }
    }

    public <T extends VCardProperty> void addPropertyAlt(Class<T> propertyClass, T ... altRepresentations) {
        this.addPropertyAlt(propertyClass, (Collection<T>)Arrays.asList(altRepresentations));
    }

    public <T extends VCardProperty> void addPropertyAlt(Class<T> propertyClass, Collection<T> altRepresentations) {
        String altId = VCard.generateAltId(this.getProperties(propertyClass));
        for (VCardProperty property : altRepresentations) {
            ((HasAltId)((Object)property)).setAltId(altId);
            this.addProperty(property);
        }
    }

    public <T extends VCardProperty> void setPropertyAlt(Class<T> propertyClass, T ... altRepresentations) {
        this.setPropertyAlt(propertyClass, (Collection<T>)Arrays.asList(altRepresentations));
    }

    public <T extends VCardProperty> void setPropertyAlt(Class<T> propertyClass, Collection<T> altRepresentations) {
        this.removeProperties(propertyClass);
        this.addPropertyAlt(propertyClass, altRepresentations);
    }

    public ValidationWarnings validate(VCardVersion version) {
        ValidationWarnings warnings = new ValidationWarnings();
        if (this.getStructuredName() == null && (version == VCardVersion.V2_1 || version == VCardVersion.V3_0)) {
            warnings.add(null, new Warning(0, new Object[0]));
        }
        if (this.getFormattedName() == null && (version == VCardVersion.V3_0 || version == VCardVersion.V4_0)) {
            warnings.add(null, new Warning(1, new Object[0]));
        }
        for (VCardProperty property : this) {
            List<Warning> propWarnings = property.validate(version, this);
            if (propWarnings.isEmpty()) continue;
            warnings.add(property, propWarnings);
        }
        return warnings;
    }

    static <T extends HasAltId> String generateAltId(Collection<T> properties) {
        HashSet<String> altIds = new HashSet<String>();
        for (HasAltId property : properties) {
            String altId = property.getAltId();
            if (altId == null) continue;
            altIds.add(altId);
        }
        int altId = 1;
        while (altIds.contains(altId + "")) {
            ++altId;
        }
        return altId + "";
    }
}

