/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapStoreDeleteProcessor;
import com.hazelcast.map.MapStoreWriteProcessor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.ArrayList;
import java.util.Collection;

public class MapStoreProcessor
implements ScheduledEntryProcessor<Data, Object> {
    private final ScheduledEntryProcessor writeProcessor;
    private final ScheduledEntryProcessor deleteProcessor;

    public MapStoreProcessor(MapContainer mapContainer, MapService mapService) {
        this.writeProcessor = new MapStoreWriteProcessor(mapContainer, mapService);
        this.deleteProcessor = new MapStoreDeleteProcessor(mapContainer, mapService);
    }

    @Override
    public void process(EntryTaskScheduler<Data, Object> scheduler, Collection<ScheduledEntry<Data, Object>> scheduledEntries) {
        if (scheduledEntries == null || scheduledEntries.isEmpty()) {
            return;
        }
        ArrayList writes = new ArrayList();
        ArrayList deletes = new ArrayList();
        for (ScheduledEntry<Data, Object> entry : scheduledEntries) {
            if (entry.getValue() == null) {
                deletes.add(entry);
                continue;
            }
            writes.add(entry);
        }
        this.writeProcessor.process(scheduler, writes);
        this.deleteProcessor.process(scheduler, deletes);
    }
}

