/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.attachment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBAttachmentSchemaValidationHack
extends AbstractPhaseInterceptor<Message> {
    public static final Interceptor INSTANCE = new JAXBAttachmentSchemaValidationHack();
    private static final String SAVED_DATASOURCES = JAXBAttachmentSchemaValidationHack.class.getName() + ".SAVED_DATASOURCES";

    private JAXBAttachmentSchemaValidationHack() {
        super("post-protocol");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Object en = message.getContextualProperty("schema-validation-enabled");
        if ((Boolean.TRUE.equals(en) || "true".equals(en)) && message.getAttachments() != null) {
            ArrayList<AttachmentDataSource> dss = new ArrayList<AttachmentDataSource>();
            for (Attachment at : message.getAttachments()) {
                if (!(at.getDataHandler().getDataSource() instanceof AttachmentDataSource)) continue;
                AttachmentDataSource ds = (AttachmentDataSource)at.getDataHandler().getDataSource();
                try {
                    ds.hold();
                }
                catch (IOException e) {
                    throw new Fault(e);
                }
                dss.add(ds);
            }
            if (!dss.isEmpty()) {
                message.put(SAVED_DATASOURCES, dss);
                message.getInterceptorChain().add(EndingInterceptor.INSTANCE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EndingInterceptor
    extends AbstractPhaseInterceptor<Message> {
        static final EndingInterceptor INSTANCE = new EndingInterceptor();

        EndingInterceptor() {
            super("pre-logical");
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            List<AttachmentDataSource> dss = CastUtils.cast((List)message.get(SAVED_DATASOURCES));
            for (AttachmentDataSource ds : dss) {
                ds.release();
            }
        }
    }
}

